/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.util.Comparator;
import java.util.Date;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import rice.environment.Environment;
import rice.p2p.commonapi.RangeCannotBeDeterminedException;
import rice.pastry.Id;
import rice.pastry.IdRange;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSet;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.leafset.InitiateLeafSetMaintenance;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.routing.InitiateRouteSetMaintenance;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.testing.RegrTestApp;

public abstract class PastryRegrTest {
    protected PastryNodeFactory factory;
    public Vector pastryNodes;
    public SortedMap pastryNodesSorted;
    public SortedMap pastryNodesSortedReady;
    public Vector pastryNodesLastAdded;
    public boolean inConcJoin;
    private Vector rtApps;
    public Message lastMsg;
    public Id.Distance lastDist;
    public Id lastNode;
    protected Environment environment;

    protected abstract NodeHandle getBootstrap(boolean var1);

    protected abstract void registerapp(PastryNode var1, RegrTestApp var2);

    protected abstract boolean simulate();

    protected abstract boolean isReallyAlive(NodeHandle var1);

    protected abstract void killNode(PastryNode var1);

    protected PastryRegrTest(Environment env) {
        this.environment = env;
        this.pastryNodes = new Vector();
        this.pastryNodesSorted = new TreeMap();
        this.pastryNodesSortedReady = new TreeMap();
        this.pastryNodesLastAdded = new Vector();
        this.inConcJoin = false;
        this.rtApps = new Vector();
    }

    private void makePastryNode() {
        NodeHandle bootstrap = this.getBootstrap(this.pastryNodes.size() == 0);
        PastryNode pn = this.generateNode(bootstrap);
        this.pastryNodes.addElement(pn);
        this.pastryNodesSorted.put(pn.getNodeId(), pn);
        this.pastryNodesLastAdded.clear();
        this.pastryNodesLastAdded.addElement(pn);
        RegrTestApp rta = new RegrTestApp(pn, this);
        this.rtApps.addElement(rta);
        this.registerapp(pn, rta);
        this.checkLeafSet(rta);
        this.checkRoutingTable(rta);
    }

    protected PastryNode generateNode(NodeHandle bootstrap) {
        PastryNode pn = this.factory.newNode(bootstrap);
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makePastryNode(int num) {
        PastryNode pn;
        int i;
        RegrTestApp[] rta = new RegrTestApp[num];
        this.pause(1000);
        this.pastryNodesLastAdded.clear();
        this.inConcJoin = true;
        int n = this.pastryNodes.size();
        if (n == 0) {
            num = 1;
        }
        for (i = 0; i < num; ++i) {
            NodeHandle bootstrap = this.getBootstrap(n == 0);
            PastryNode pn2 = this.generateNode(bootstrap);
            this.pastryNodes.addElement(pn2);
            this.pastryNodesSorted.put(pn2.getNodeId(), pn2);
            this.pastryNodesLastAdded.addElement(pn2);
            rta[i] = new RegrTestApp(pn2, this);
            this.rtApps.addElement(rta[i]);
            this.registerapp(pn2, rta[i]);
            if (bootstrap == null || n != 0) continue;
            PastryNode pastryNode = pn2;
            synchronized (pastryNode) {
                while (!pn2.isReady()) {
                    try {
                        pn2.wait(500L);
                    }
                    catch (InterruptedException ie) {}
                }
                continue;
            }
        }
        for (i = 0; i < this.pastryNodesLastAdded.size(); ++i) {
            PastryNode pastryNode = pn = (PastryNode)this.pastryNodesLastAdded.get(i);
            synchronized (pastryNode) {
                while (!pn.isReady()) {
                    try {
                        pn.wait(500L);
                    }
                    catch (InterruptedException ie) {}
                }
                continue;
            }
        }
        this.pause(2500);
        this.inConcJoin = false;
        for (i = 0; i < num; ++i) {
            System.out.println("created " + rta[i].getNodeId());
            pn = rta[i].getPastryNode();
            this.pastryNodesSortedReady.put(pn.getNodeId(), pn);
            this.checkLeafSet(rta[i]);
            this.checkRoutingTable(rta[i]);
        }
        for (i = 0; i < this.rtApps.size(); ++i) {
        }
    }

    public abstract void pause(int var1);

    public void sendPings(int k) {
        int n = this.rtApps.size();
        for (int i = 0; i < k; ++i) {
            int from = this.environment.getRandomSource().nextInt(n);
            int to = this.environment.getRandomSource().nextInt(n);
            byte[] keyBytes = new byte[20];
            this.environment.getRandomSource().nextBytes(keyBytes);
            Id key = Id.build(keyBytes);
            RegrTestApp rta = (RegrTestApp)this.rtApps.get(from);
            PastryNode pn = (PastryNode)this.pastryNodes.get(to);
            rta.sendTrace(pn.getNodeId());
            rta.sendTrace(key);
        }
    }

    private void checkLeafSet(RegrTestApp rta) {
        Id nid;
        int inBetween;
        NodeHandle nh;
        int i;
        LeafSet ls = rta.getLeafSet();
        Id localId = rta.getNodeId();
        if (ls.size() < ls.maxSize() && (this.pastryNodesSorted.size() - 1) * 2 != ls.size()) {
            System.out.println("checkLeafSet: incorrect size " + rta.getNodeId() + " ls.size()=" + ls.size() + " total nodes=" + this.pastryNodesSorted.size() + "\n" + ls);
        }
        for (i = -ls.ccwSize(); i < 0; ++i) {
            nh = ls.get(i);
            if (!nh.isAlive()) {
                System.out.println("checkLeafSet: dead node handle " + nh.getNodeId() + " in leafset at " + rta.getNodeId() + "\n" + ls);
            }
            if ((inBetween = localId.compareTo(nid = ls.get(i).getNodeId()) > 0 ? this.pastryNodesSorted.subMap(nid, localId).size() : this.pastryNodesSorted.tailMap(nid).size() + this.pastryNodesSorted.headMap(localId).size()) == -i) continue;
            System.out.println("checkLeafSet: failure at" + rta.getNodeId() + "i=" + i + " inBetween=" + inBetween + "\n" + ls);
        }
        for (i = 1; i <= ls.cwSize(); ++i) {
            nh = ls.get(i);
            if (!nh.isAlive()) {
                System.out.println("checkLeafSet: dead node handle " + nh.getNodeId() + " in leafset at " + rta.getNodeId() + "\n" + ls);
            }
            if ((inBetween = localId.compareTo(nid = ls.get(i).getNodeId()) < 0 ? this.pastryNodesSorted.subMap(localId, nid).size() : this.pastryNodesSorted.tailMap(localId).size() + this.pastryNodesSorted.headMap(nid).size()) == i) continue;
            System.out.println("checkLeafSet: failure at" + rta.getNodeId() + "i=" + i + " inBetween=" + inBetween + "\n" + ls);
        }
        for (int k = -ls.ccwSize(); k <= ls.cwSize(); ++k) {
            Id id = ls.get(k).getNodeId();
            class DistComp
            implements Comparator {
                Id id;

                public DistComp(Id id) {
                    this.id = id;
                }

                public int compare(Object o1, Object o2) {
                    Id nid1 = (Id)o1;
                    Id nid2 = (Id)o2;
                    return nid1.distance(this.id).compareTo(nid2.distance(this.id));
                }
            }
            TreeSet<Id> distanceSet = new TreeSet<Id>(new DistComp(id));
            for (int i2 = -ls.ccwSize(); i2 <= ls.cwSize(); ++i2) {
                NodeHandle nh2 = ls.get(i2);
                distanceSet.add(nh2.getNodeId());
            }
            int expectedSize = distanceSet.headSet(ls.get(-ls.ccwSize()).getNodeId()).size() + 1;
            int expectedSize1 = distanceSet.headSet(ls.get(ls.cwSize()).getNodeId()).size() + 1;
            if (expectedSize1 < expectedSize) {
                expectedSize = expectedSize1;
            }
            if (ls.overlaps()) {
                expectedSize = distanceSet.size();
            }
            NodeSet rs = ls.replicaSet(id, expectedSize);
            for (int i3 = 0; i3 < rs.size(); ++i3) {
                NodeHandle nh3 = rs.get(i3);
                Id nid2 = nh3.getNodeId();
                int inBetween2 = distanceSet.subSet(id, nid2).size();
                if (inBetween2 == i3) continue;
                System.out.println("checkLeafSet: replicaSet failure at" + rta.getNodeId() + " i=" + i3 + " k=" + k + " inBetween=" + inBetween2 + "\n" + rs + "\n" + ls);
            }
            if (rs.size() != expectedSize) {
                System.out.println("checkLeafSet: replicaSet size failure at " + rta.getNodeId() + " k=" + k + " expectedSize=" + expectedSize + " " + "\n" + rs + "\n" + ls + " distanceSet:" + distanceSet);
            }
            int maxRank = ls.overlaps() || ls.size() == 0 ? rs.size() - 1 : (k > 0 ? ls.cwSize() - k - 1 : ls.ccwSize() + k - 1);
            Id nearest = null;
            for (int j = -1; j <= maxRank * 2 + 1; ++j) {
                IdRange range = null;
                if (j < 0) {
                    try {
                        range = rta.range(ls.get(k), maxRank, nearest, true);
                    }
                    catch (IllegalArgumentException iae) {
                    }
                    catch (RangeCannotBeDeterminedException rcbde) {
                    }
                    catch (NullPointerException npe) {}
                } else {
                    try {
                        range = rta.range(ls.get(k), j / 2, nearest, false);
                    }
                    catch (NullPointerException npe) {
                    }
                    catch (RangeCannotBeDeterminedException rcbde) {
                        // empty catch block
                    }
                }
                if (range == null) {
                    if (maxRank < 0) continue;
                    System.out.println("checkLeafSet: range size failure at " + rta.getNodeId() + " k=" + k + " maxRank=" + maxRank + "\n" + rs + "\n" + ls);
                    continue;
                }
                nearest = ls.get(k).getNodeId();
                int nearestPos = k;
                NodeSet cs = ls.replicaSet(range.getCCW(), maxRank + 1);
                if (j >= 0 && cs.get(j / 2) == null || j >= 0 && !cs.get(j / 2).getNodeId().equals(nearest) || j < 0 && !ls.overlaps() && !cs.get(maxRank).getNodeId().equals(nearest) || j < 0 && ls.overlaps() && !range.isFull()) {
                    System.out.println("checkLeafSet: range failure 1 at " + rta.getNodeId() + " k=" + k + " j=" + j + " maxRank=" + maxRank + "\n" + cs + "\n" + ls + "\n" + range + "\nnearest=" + nearest);
                    System.out.println("dist(nearest)=" + nearest.distance(range.getCCW()));
                    if (ls.get(nearestPos - 1) != null) {
                        System.out.println("dist(nearest-1)=" + ls.get(nearestPos - 1).getNodeId().distance(range.getCCW()));
                    }
                    if (ls.get(nearestPos + 1) != null) {
                        System.out.println("dist(nearest+1)=" + ls.get(nearestPos + 1).getNodeId().distance(range.getCCW()));
                    }
                }
                cs = ls.replicaSet(range.getCW().getCCW(), maxRank + 1);
                if (j >= 0 && cs.get(j / 2) == null || j >= 0 && !cs.get(j / 2).getNodeId().equals(nearest) || j < 0 && !ls.overlaps() && !cs.get(maxRank).getNodeId().equals(nearest) || j < 0 && ls.overlaps() && !range.isFull()) {
                    System.out.println("checkLeafSet: range failure 2 at " + rta.getNodeId() + " k=" + k + " j=" + j + " maxRank=" + maxRank + "\n" + cs + "\n" + ls + "\n" + range + "\nnearest=" + nearest);
                    System.out.println("dist(nearest)=" + nearest.distance(range.getCW()));
                    if (ls.get(nearestPos - 1) != null) {
                        System.out.println("dist(nearest-1)=" + ls.get(nearestPos - 1).getNodeId().distance(range.getCW()));
                    }
                    if (ls.get(nearestPos + 1) != null) {
                        System.out.println("dist(nearest+1)=" + ls.get(nearestPos + 1).getNodeId().distance(range.getCW()));
                    }
                }
                nearest = range.getCW();
            }
        }
    }

    protected void checkRoutingTable(RegrTestApp rta) {
        RoutingTable rt = rta.getRoutingTable();
        for (int i = rt.numRows() - 1; i >= 0; --i) {
            for (int j = 0; j < rt.numColumns(); ++j) {
                RouteSet rs = rt.getRouteSet(i, j);
                Id domainFirst = rta.getNodeId().getDomainPrefix(i, j, 0, rt.baseBitLength());
                Id domainLast = rta.getNodeId().getDomainPrefix(i, j, -1, rt.baseBitLength());
                if (rs == null || rs.size() == 0) {
                    int inBetween = this.pastryNodesSorted.subMap(domainFirst, domainLast).size() + (this.pastryNodesSorted.containsKey(domainLast) ? 1 : 0);
                    if (inBetween <= 0) continue;
                    System.out.println("checkRoutingTable: missing RT entry at" + rta.getNodeId() + "row=" + i + " column=" + j + " inBetween=" + inBetween);
                    continue;
                }
                NodeHandle nh = rs.closestNode();
                int bestProximity = Integer.MAX_VALUE;
                if (nh != null && (bestProximity = rta.getPastryNode().proximity(nh)) == Integer.MAX_VALUE) {
                    System.out.println("checkRoutingTable failure 0, row=" + i + " column=" + j);
                }
                for (int k = 0; k < rs.size(); ++k) {
                    NodeHandle nh2;
                    Id id;
                    if (rs.get(k).isAlive() && rta.getPastryNode().proximity(rs.get(k)) < bestProximity) {
                        System.out.println("checkRoutingTable failure 1, row=" + i + " column=" + j + " rank=" + k);
                    }
                    if (!this.pastryNodesSorted.containsKey(id = (nh2 = rs.get(k)).getNodeId())) {
                        if (!this.isReallyAlive(nh2)) continue;
                        System.out.println("checkRoutingTable failure 2, row=" + i + " column=" + j + " rank=" + k);
                        continue;
                    }
                    if (this.pastryNodesSorted.subMap(domainFirst, domainLast).containsKey(id) || domainLast.equals(id)) continue;
                    System.out.println("checkRoutingTable failure 3, row=" + i + " column=" + j + " rank=" + k);
                }
            }
        }
    }

    private void initiateLeafSetMaintenance() {
        for (int i = 0; i < this.pastryNodes.size(); ++i) {
            PastryNode pn = (PastryNode)this.pastryNodes.get(i);
            pn.receiveMessage(new InitiateLeafSetMaintenance());
            while (this.simulate()) {
            }
        }
    }

    private void initiateRouteSetMaintenance() {
        for (int i = 0; i < this.pastryNodes.size(); ++i) {
            PastryNode pn = (PastryNode)this.pastryNodes.get(i);
            pn.receiveMessage(new InitiateRouteSetMaintenance());
            while (this.simulate()) {
            }
        }
    }

    private void killNodes(int num) {
        for (int i = 0; i < num; ++i) {
            int n = this.environment.getRandomSource().nextInt(this.pastryNodes.size());
            PastryNode pn = (PastryNode)this.pastryNodes.get(n);
            this.pastryNodes.remove(n);
            this.rtApps.remove(n);
            this.pastryNodesSorted.remove(pn.getNodeId());
            this.pastryNodesSortedReady.remove(pn.getNodeId());
            this.killNode(pn);
            System.out.println("Killed " + pn.getNodeId());
            try {
                this.environment.getTimeSource().sleep(2000L);
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    protected static void mainfunc(PastryRegrTest pt, String[] args, int n, int d, int k, int m, int numConcJoins) {
        int i;
        Date old = new Date();
        while (pt.pastryNodes.size() < n) {
            int remaining = n - pt.pastryNodes.size();
            if (remaining > numConcJoins) {
                remaining = numConcJoins;
            }
            pt.makePastryNode(remaining);
            if (pt.pastryNodes.size() % m == 0) {
                Date now = new Date();
                System.out.println(pt.pastryNodes.size() + " " + (now.getTime() - old.getTime()));
                old = now;
            }
            pt.sendPings(k);
        }
        System.out.println(pt.pastryNodes.size() + " nodes constructed");
        System.out.println("starting RT and leafset check");
        for (int j = 0; j < pt.rtApps.size(); ++j) {
            pt.checkLeafSet((RegrTestApp)pt.rtApps.get(j));
            pt.checkRoutingTable((RegrTestApp)pt.rtApps.get(j));
        }
        System.out.println("finished RT and leafset check");
        pt.killNodes(d);
        System.out.println(d + " nodes killed");
        pt.sendPings((n - d) * k);
        System.out.println((n - d) * k + " messages sent");
        System.out.println("starting leafset/RT maintenance");
        pt.initiateLeafSetMaintenance();
        pt.initiateRouteSetMaintenance();
        System.out.println("finished leafset/RT maintenance");
        pt.sendPings((n - d) * k);
        System.out.println((n - d) * k + " messages sent");
        pt.pause(5000);
        System.out.println("starting RT and leafset check");
        for (i = 0; i < pt.rtApps.size(); ++i) {
            pt.checkLeafSet((RegrTestApp)pt.rtApps.get(i));
            pt.checkRoutingTable((RegrTestApp)pt.rtApps.get(i));
        }
        for (i = 0; i < 4; ++i) {
            System.out.println("Starting leafset/RT maintenance, round " + (i + 2));
            pt.initiateLeafSetMaintenance();
            pt.initiateRouteSetMaintenance();
            System.out.println("finished leafset/RT maintenance, round " + (i + 2));
            pt.sendPings((n - d) * k);
            System.out.println((n - d) * k + " messages sent");
            System.out.println("starting RT and leafset check, round " + (i + 2));
            for (int j = 0; j < pt.rtApps.size(); ++j) {
                pt.checkLeafSet((RegrTestApp)pt.rtApps.get(j));
                pt.checkRoutingTable((RegrTestApp)pt.rtApps.get(j));
            }
            pt.pause(1000);
        }
        pt.pause(5000);
        System.out.println("finished, exiting...");
        System.exit(0);
    }
}

