/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.io.IOException;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Vector;
import rice.environment.Environment;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.SphereNetwork;
import rice.pastry.standard.RandomNodeIdFactory;

public class ClosestRegrTest {
    public static int NUM_NODES = 1000;
    private PastryNodeFactory factory;
    private NetworkSimulator simulator;
    private Vector pastryNodes;
    int incorrect = 0;
    double sum = 0.0;
    private Environment environment = Environment.directEnvironment();

    private ClosestRegrTest() throws IOException {
        this.simulator = new SphereNetwork(this.environment);
        this.factory = new DirectPastryNodeFactory(new RandomNodeIdFactory(this.environment), this.simulator, this.environment);
        this.pastryNodes = new Vector();
    }

    protected NodeHandle getBootstrap() {
        NodeHandle bootstrap = null;
        try {
            PastryNode lastnode = (PastryNode)this.pastryNodes.lastElement();
            bootstrap = lastnode.getLocalHandle();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return bootstrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() {
        for (int i = 0; i < NUM_NODES; ++i) {
            PastryNode node;
            PastryNode pastryNode = node = this.factory.newNode(this.getBootstrap());
            synchronized (pastryNode) {
                while (!node.isReady()) {
                    try {
                        node.wait(500L);
                    }
                    catch (InterruptedException ie) {
                        return;
                    }
                }
            }
            if (i > 0) {
                this.test(i, (DirectNodeHandle)node.getLocalHandle());
            }
            System.out.println("CREATED NODE " + i + " " + node.getNodeId());
            this.pastryNodes.add(node);
            double ave = this.getAvgNumEntries(this.pastryNodes);
            System.out.println("Avg Num Entries:" + ave);
        }
        System.out.println("SO FAR: " + this.incorrect + "/" + NUM_NODES + " PERCENTAGE: " + this.sum / (double)this.incorrect);
    }

    protected double getAvgNumEntries(Collection nds) {
        double sum = 0.0;
        for (PastryNode pn : nds) {
            sum += (double)pn.getRoutingTable().numUniqueEntries();
        }
        return sum / (double)nds.size();
    }

    protected void test(int i, DirectNodeHandle handle) {
        PastryNode bootNode = (PastryNode)this.pastryNodes.elementAt(this.environment.getRandomSource().nextInt(i));
        NodeHandle bootstrap = bootNode.getLocalHandle();
        DirectNodeHandle closest = null;
        DirectNodeHandle realClosest = this.simulator.getClosest(handle);
        if (!closest.getNodeId().equals(realClosest.getNodeId())) {
            float cProx = this.simulator.proximity(closest, handle);
            float rProx = this.simulator.proximity(realClosest, handle);
            if (cProx == 0.0f) {
                System.out.println("ERROR: factory.getNearest(" + handle + ") returned " + closest);
            }
            if (rProx < cProx) {
                ++this.incorrect;
                this.sum += (double)(cProx / rProx);
                System.out.println("ERROR: CLOSEST TO " + handle + " WAS " + closest.getNodeId() + ":" + cProx + " REAL CLOSEST: " + realClosest.getNodeId() + ":" + rProx);
                System.out.println("SO FAR: " + this.incorrect + "/" + i + " PERCENTAGE: " + this.sum / (double)this.incorrect);
            }
        }
    }

    public boolean pass() {
        return this.incorrect < NUM_NODES / 2;
    }

    public static void main(String[] args) throws IOException {
        ClosestRegrTest pt = new ClosestRegrTest();
        pt.run();
        System.out.println("pass:" + pt.pass());
        pt.environment.destroy();
    }
}

