/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.nat.rendezvous;

import org.mpisws.p2p.transport.rendezvous.OutgoingPilotListener;
import org.mpisws.p2p.transport.rendezvous.PilotManager;
import org.mpisws.p2p.transport.rendezvous.RendezvousContact;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSetEventSource;
import rice.pastry.NodeSetListener;
import rice.pastry.leafset.LeafSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeafSetPilotStrategy<Identifier extends RendezvousContact>
implements NodeSetListener,
OutgoingPilotListener<Identifier> {
    LeafSet leafSet;
    PilotManager<Identifier> manager;
    Logger logger;

    public LeafSetPilotStrategy(LeafSet leafSet, PilotManager<Identifier> manager, Environment env) {
        this.leafSet = leafSet;
        this.manager = manager;
        this.manager.addOutgoingPilotListener(this);
        this.logger = env.getLogManager().getLogger(LeafSetPilotStrategy.class, null);
        leafSet.addNodeSetListener(this);
    }

    @Override
    public void nodeSetUpdate(NodeSetEventSource nodeSetEventSource, NodeHandle handle, boolean added) {
        RendezvousContact nh;
        if (this.logger.level <= 400) {
            this.logger.log("nodeSetUpdate(" + handle + ")");
        }
        if ((nh = (RendezvousContact)((Object)handle)).canContactDirect()) {
            if (added) {
                this.manager.openPilot(nh, null);
            } else {
                this.manager.closePilot(nh);
            }
        }
    }

    @Override
    public void pilotOpening(Identifier i) {
    }

    @Override
    public void pilotClosed(Identifier i) {
        if (this.leafSet.contains((NodeHandle)i)) {
            this.manager.openPilot(i, null);
        }
    }
}

