/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mpisws.p2p.transport.direct.Delivery;
import org.mpisws.p2p.transport.direct.DirectTransportLayer;
import org.mpisws.p2p.transport.direct.EventSimulator;
import org.mpisws.p2p.transport.direct.GenericNetworkSimulator;
import org.mpisws.p2p.transport.liveness.LivenessListener;
import rice.environment.Environment;
import rice.environment.params.Parameters;
import rice.environment.random.RandomSource;
import rice.p2p.commonapi.Cancellable;
import rice.p2p.commonapi.CancellableTask;
import rice.pastry.direct.DeliveryTimerTask;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectTimerTask;
import rice.pastry.direct.MessageDelivery;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.NodeRecord;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicNetworkSimulator<Identifier, MessageType>
extends EventSimulator
implements GenericNetworkSimulator<Identifier, MessageType> {
    Map<Identifier, Tupel> nodes = new HashMap<Identifier, Tupel>();
    NetworkSimulator<Identifier, MessageType> sim;
    protected int MIN_DELAY = 1;
    protected final int maxDiameter;
    protected final int minDelay;
    List<LivenessListener<Identifier>> livenessListeners = new ArrayList<LivenessListener<Identifier>>();

    public BasicNetworkSimulator(Environment env, RandomSource random, NetworkSimulator<Identifier, MessageType> sim) {
        super(env, random, env.getLogManager().getLogger(BasicNetworkSimulator.class, null));
        this.sim = sim;
        this.manager.useLoopListeners(false);
        Parameters params = env.getParameters();
        this.maxDiameter = params.getInt("pastry_direct_max_diameter");
        this.minDelay = params.getInt("pastry_direct_min_delay");
        this.start();
    }

    private void addTask(TimerTask dtt) {
        if (this.logger.level <= 500) {
            this.logger.log("addTask(" + dtt + ")");
        }
        this.manager.getTimer().schedule(dtt);
    }

    @Override
    public CancellableTask enqueueDelivery(Delivery d, int delay) {
        long time = this.timeSource.currentTimeMillis() + (long)delay;
        if (this.logger.level <= 500) {
            this.logger.log("BNS: enqueueDelivery " + d + ":" + time);
        }
        DeliveryTimerTask dtt = null;
        dtt = new DeliveryTimerTask(d, time, d.getSeq());
        this.addTask(dtt);
        return dtt;
    }

    public Cancellable deliverMessage(MessageType msg, Identifier node, Identifier from) {
        return this.deliverMessage(msg, node, from, 0);
    }

    @Override
    public Cancellable deliverMessage(MessageType msg, Identifier node, Identifier from, int delay) {
        if (delay > 0) {
            this.sim.notifySimulatorListenersSent(msg, from, node, delay);
        }
        return this.deliverMessage(msg, node, from, delay, 0);
    }

    void notifySimulatorListenersReceived(MessageType m, Identifier from, Identifier to) {
        this.sim.notifySimulatorListenersReceived(m, from, to);
    }

    public Cancellable deliverMessageFixedRate(MessageType msg, Identifier node, Identifier from, int delay, int period) {
        return this.deliverMessage(msg, node, from, delay, period);
    }

    public Cancellable deliverMessage(MessageType msg, Identifier node, Identifier from, int delay, int period) {
        if (this.logger.level <= 500) {
            this.logger.log("BNS: deliver " + msg + " to " + node);
        }
        DirectTimerTask dtt = null;
        if (from == null || this.isAlive(from)) {
            MessageDelivery<Identifier, MessageType> md = new MessageDelivery<Identifier, MessageType>(msg, node, from, null, this);
            dtt = new DirectTimerTask(md, this.timeSource.currentTimeMillis() + (long)delay, period);
            this.addTask(dtt);
        }
        return dtt;
    }

    public void registerIdentifier(Identifier i, DirectTransportLayer<Identifier, MessageType> dtl, NodeRecord record) {
        this.nodes.put(i, new Tupel(i, dtl, record));
    }

    @Override
    public void remove(Identifier i) {
        if (!this.environment.getSelectorManager().isSelectorThread()) {
            throw new IllegalStateException("Operation not permitted on non-selector thread.");
        }
        this.nodes.remove(i);
        this.notifyLivenessListeners(i, 3, null);
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public Environment getEnvironment(Identifier i) {
        return this.nodes.get(i).tl.getEnvironment();
    }

    @Override
    public RandomSource getRandomSource() {
        return this.random;
    }

    @Override
    public boolean isAlive(Identifier i) {
        return this.nodes.containsKey(i);
    }

    @Override
    public DirectTransportLayer<Identifier, MessageType> getTL(Identifier i) {
        Tupel t = this.nodes.get(i);
        if (t == null) {
            return null;
        }
        return t.tl;
    }

    @Override
    public float networkDelay(Identifier a, Identifier b) {
        Tupel ta = this.nodes.get(a);
        Tupel tb = this.nodes.get(b);
        if (ta == null) {
            throw new RuntimeException("asking about node proximity for unknown node " + a);
        }
        if (tb == null) {
            throw new RuntimeException("asking about node proximity for unknown node " + b);
        }
        NodeRecord nra = ta.record;
        NodeRecord nrb = tb.record;
        return nra.networkDelay(nrb);
    }

    public float proximity(Identifier a, Identifier b) {
        Tupel ta = this.nodes.get(a);
        Tupel tb = this.nodes.get(b);
        if (ta == null) {
            throw new RuntimeException("asking about node proximity for unknown node " + a);
        }
        if (tb == null) {
            throw new RuntimeException("asking about node proximity for unknown node " + b);
        }
        NodeRecord nra = ta.record;
        NodeRecord nrb = tb.record;
        return nra.proximity(nrb);
    }

    public NodeRecord getNodeRecord(DirectNodeHandle handle) {
        Tupel t = this.nodes.get(handle);
        if (t == null) {
            return null;
        }
        return t.record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLivenessListener(LivenessListener<Identifier> name) {
        List<LivenessListener<Identifier>> list = this.livenessListeners;
        synchronized (list) {
            this.livenessListeners.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLivenessListener(LivenessListener<Identifier> name) {
        List<LivenessListener<Identifier>> list = this.livenessListeners;
        synchronized (list) {
            return this.livenessListeners.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyLivenessListeners(Identifier i, int liveness, Map<String, Object> options) {
        ArrayList<LivenessListener<Identifier>> temp;
        if (this.logger.level <= 400) {
            this.logger.log("notifyLivenessListeners(" + i + "," + liveness + "):" + this.livenessListeners.get(0));
        }
        List<LivenessListener<Identifier>> list = this.livenessListeners;
        synchronized (list) {
            temp = new ArrayList<LivenessListener<Identifier>>(this.livenessListeners);
        }
        for (LivenessListener livenessListener : temp) {
            livenessListener.livenessChanged(i, liveness, options);
        }
    }

    @Override
    public boolean checkLiveness(Identifier i, Map<String, Object> options) {
        return false;
    }

    @Override
    public int getLiveness(Identifier i, Map<String, Object> options) {
        if (this.nodes.containsKey(i)) {
            return 1;
        }
        return 3;
    }

    @Override
    public void clearState(Identifier i) {
        throw new IllegalStateException("not implemented");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Tupel {
        Identifier i;
        DirectTransportLayer<Identifier, MessageType> tl;
        NodeRecord record;

        public Tupel(Identifier i, DirectTransportLayer<Identifier, MessageType> tl, NodeRecord record) {
            this.i = i;
            this.tl = tl;
            this.record = record;
        }
    }
}

