/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util;

import rice.environment.random.RandomSource;
import rice.p2p.util.Base64;

public class MathUtils {
    public static final char[] HEX_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private MathUtils() {
    }

    public static int mod(int a, int b) {
        return (a % b + b) % b;
    }

    public static byte[] xor(byte[] a, byte[] b) {
        byte[] result = new byte[a.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(a[i] ^ b[i]);
        }
        return result;
    }

    public static byte[] randomBytes(int len, RandomSource random) {
        byte[] result = new byte[len];
        random.nextBytes(result);
        return result;
    }

    public static int randomInt(RandomSource random) {
        return random.nextInt();
    }

    public static String toHex(byte[] text) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < text.length; ++i) {
            buffer.append(HEX_ARRAY[0xF & text[i] >> 4]);
            buffer.append(HEX_ARRAY[0xF & text[i]]);
        }
        return buffer.toString();
    }

    public static byte[] fromHex(String text) {
        byte[] result = new byte[text.length() / 2];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)((byte)(0xFFFFFFF0 & MathUtils.getByte(text.charAt(2 * i)) << 4) | MathUtils.getByte(text.charAt(2 * i + 1)));
        }
        return result;
    }

    public static String toBase64(byte[] text) {
        return Base64.encodeBytes(text);
    }

    public static byte[] fromBase64(String text) {
        return Base64.decode(text);
    }

    public static int simpleHash(byte[] b) {
        int hash = 0;
        for (int i = 0; i < b.length; ++i) {
            hash += b[i];
            hash += hash << 10;
            hash ^= hash >> 6;
        }
        hash += hash << 3;
        hash ^= hash >> 11;
        hash += hash << 15;
        return hash;
    }

    protected static byte getByte(char c) {
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48);
        }
        if (c >= 'A' && c <= 'F') {
            return (byte)(10 + (byte)(c - 65));
        }
        if (c >= 'a' && c <= 'f') {
            return (byte)(10 + (byte)(c - 97));
        }
        throw new RuntimeException("Could not decode hex character '" + c + "'");
    }

    public static byte[] intToByteArray(int input) {
        byte[] output = new byte[4];
        MathUtils.intToByteArray(input, output, 0);
        return output;
    }

    public static void intToByteArray(int input, byte[] output, int offset) {
        output[offset + 0] = (byte)(0xFF & input >> 24);
        output[offset + 1] = (byte)(0xFF & input >> 16);
        output[offset + 2] = (byte)(0xFF & input >> 8);
        output[offset + 3] = (byte)(0xFF & input);
    }

    public static int byteArrayToInt(byte[] input) {
        return MathUtils.byteArrayToInt(input, 0);
    }

    public static int byteArrayToInt(byte[] input, int offset) {
        input = MathUtils.correctLength(input, offset + 4);
        int result = (input[offset + 0] & 0xFF) << 24;
        result |= (input[offset + 1] & 0xFF) << 16;
        result |= (input[offset + 2] & 0xFF) << 8;
        return result |= input[offset + 3] & 0xFF;
    }

    public static byte[] longToByteArray(long input) {
        byte[] output = new byte[8];
        MathUtils.longToByteArray(input, output, 0);
        return output;
    }

    public static void longToByteArray(long input, byte[] output, int offset) {
        output[offset + 0] = (byte)(0xFFL & input >> 56);
        output[offset + 1] = (byte)(0xFFL & input >> 48);
        output[offset + 2] = (byte)(0xFFL & input >> 40);
        output[offset + 3] = (byte)(0xFFL & input >> 32);
        output[offset + 4] = (byte)(0xFFL & input >> 24);
        output[offset + 5] = (byte)(0xFFL & input >> 16);
        output[offset + 6] = (byte)(0xFFL & input >> 8);
        output[offset + 7] = (byte)(0xFFL & input);
    }

    public static long byteArrayToLong(byte[] input) {
        return MathUtils.byteArrayToLong(input, 0);
    }

    public static long byteArrayToLong(byte[] input, int offset) {
        input = MathUtils.correctLength(input, offset + 8);
        long result = (long)(input[offset + 0] & 0xFF) << 56;
        result |= (long)(input[offset + 1] & 0xFF) << 48;
        result |= (long)(input[offset + 2] & 0xFF) << 40;
        result |= (long)(input[offset + 3] & 0xFF) << 32;
        result |= (long)(input[offset + 4] & 0xFF) << 24;
        result |= (long)(input[offset + 5] & 0xFF) << 16;
        result |= (long)(input[offset + 6] & 0xFF) << 8;
        return result |= (long)(input[offset + 7] & 0xFF);
    }

    private static byte[] correctLength(byte[] data, int length) {
        return MathUtils.correctLength(data, 0, length);
    }

    private static byte[] correctLength(byte[] data, int offset, int length) {
        if (data.length >= length) {
            return data;
        }
        byte[] result = new byte[length];
        for (int i = 0; i < data.length && i < result.length; ++i) {
            result[i] = data[i];
        }
        return result;
    }
}

