/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.scribe.messaging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.scribe.ScribeContent;
import rice.p2p.scribe.Topic;
import rice.p2p.scribe.messaging.ScribeMessage;
import rice.p2p.scribe.rawserialization.JavaSerializedScribeContent;
import rice.p2p.scribe.rawserialization.RawScribeContent;
import rice.p2p.scribe.rawserialization.ScribeContentDeserializer;

public class AnycastMessage
extends ScribeMessage {
    public static final short TYPE = 1;
    protected RawScribeContent content;
    protected ArrayList<NodeHandle> visited;
    protected LinkedList<NodeHandle> toVisit;
    protected NodeHandle initialRequestor;

    public AnycastMessage(NodeHandle source, Topic topic, ScribeContent content) {
        this(source, topic, content instanceof RawScribeContent ? (RawScribeContent)content : new JavaSerializedScribeContent(content));
    }

    public AnycastMessage(NodeHandle source, Topic topic, RawScribeContent content) {
        super(source, topic);
        this.initialRequestor = source;
        this.content = content;
        this.visited = new ArrayList();
        this.toVisit = new LinkedList();
        this.addVisited(source);
    }

    public ScribeContent getContent() {
        if (this.content == null) {
            return null;
        }
        if (this.content.getType() == 0) {
            return ((JavaSerializedScribeContent)this.content).getContent();
        }
        return this.content;
    }

    public RawScribeContent getRawContent() {
        return this.content;
    }

    public void setContent(RawScribeContent content) {
        this.content = content;
    }

    public void setContent(ScribeContent content) {
        if (content instanceof RawScribeContent) {
            this.setContent(content);
        } else {
            this.setContent(new JavaSerializedScribeContent(content));
        }
    }

    public NodeHandle peekNext() {
        if (this.toVisit.size() == 0) {
            return null;
        }
        return this.toVisit.getFirst();
    }

    public NodeHandle getNext() {
        if (this.toVisit.size() == 0) {
            return null;
        }
        return this.toVisit.removeFirst();
    }

    public NodeHandle peekLastToVisit() {
        return this.toVisit.getLast();
    }

    public void addVisited(NodeHandle handle) {
        if (handle == null) {
            return;
        }
        if (!this.visited.contains(handle)) {
            this.visited.add(handle);
        }
        while (this.toVisit.remove(handle)) {
            this.toVisit.remove(handle);
        }
    }

    public void addFirst(NodeHandle handle) {
        if (handle == null) {
            return;
        }
        if (!this.toVisit.contains(handle) && !this.visited.contains(handle)) {
            this.toVisit.addFirst(handle);
        }
    }

    public void addLast(NodeHandle handle) {
        if (handle == null) {
            return;
        }
        if (!this.toVisit.contains(handle) && !this.visited.contains(handle)) {
            this.toVisit.addLast(handle);
        }
    }

    public String toString() {
        return "Anycast[" + this.getTopic() + " " + this.content + "]";
    }

    public NodeHandle getInitialRequestor() {
        return this.initialRequestor;
    }

    public NodeHandle getLastVisited() {
        if (this.visited.size() == 0) {
            return null;
        }
        return this.visited.get(this.visited.size() - 1);
    }

    public void remove(NodeHandle handle) {
        if (handle == null) {
            return;
        }
        this.toVisit.remove(handle);
        this.visited.remove(handle);
    }

    public int getVisitedSize() {
        return this.visited.size();
    }

    public int getToVisitSize() {
        return this.toVisit.size();
    }

    public boolean hasVisited(NodeHandle handle) {
        return this.visited.contains(handle);
    }

    public short getType() {
        return 1;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)1);
        this.serializeHelper(buf);
    }

    protected void serializeHelper(OutputBuffer buf) throws IOException {
        super.serialize(buf);
        this.initialRequestor.serialize(buf);
        buf.writeInt(this.toVisit.size());
        Iterator<Object> i = this.toVisit.iterator();
        while (i.hasNext()) {
            ((NodeHandle)i.next()).serialize(buf);
        }
        buf.writeInt(this.visited.size());
        i = this.visited.iterator();
        while (i.hasNext()) {
            ((NodeHandle)i.next()).serialize(buf);
        }
        if (this.content == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeShort(this.content.getType());
            this.content.serialize(buf);
        }
    }

    public static AnycastMessage build(InputBuffer buf, Endpoint endpoint, ScribeContentDeserializer scd) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 1: {
                return new AnycastMessage(buf, endpoint, scd);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }

    protected AnycastMessage(InputBuffer buf, Endpoint endpoint, ScribeContentDeserializer cd) throws IOException {
        super(buf, endpoint);
        this.initialRequestor = endpoint.readNodeHandle(buf);
        this.toVisit = new LinkedList();
        int toVisitLength = buf.readInt();
        for (int i = 0; i < toVisitLength; ++i) {
            this.toVisit.addLast(endpoint.readNodeHandle(buf));
        }
        int visitedLength = buf.readInt();
        this.visited = new ArrayList(visitedLength);
        for (int i = 0; i < visitedLength; ++i) {
            this.visited.add(endpoint.readNodeHandle(buf));
        }
        if (buf.readBoolean()) {
            short contentType = buf.readShort();
            this.content = contentType == 0 ? new JavaSerializedScribeContent(cd.deserializeScribeContent(buf, endpoint, contentType)) : (RawScribeContent)cd.deserializeScribeContent(buf, endpoint, contentType);
        }
    }
}

