/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.past.messaging.ContinuationMessage;

public class LookupHandlesMessage
extends ContinuationMessage {
    public static final short TYPE = 5;
    private Id id;
    private int max;

    public LookupHandlesMessage(int uid, Id id, int max, NodeHandle source, Id dest) {
        super(uid, source, dest);
        this.id = id;
        this.max = max;
    }

    public Id getId() {
        return this.id;
    }

    public int getMax() {
        return this.max;
    }

    public String toString() {
        return "[LookupHandlesMessage (response " + this.isResponse() + " " + this.response + ") for " + this.id + " max " + this.max + "]";
    }

    public short getType() {
        return 5;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        this.serializeHelper(buf);
    }

    protected void serializeHelper(OutputBuffer buf) throws IOException {
        if (this.response != null && this.response instanceof NodeHandleSet) {
            super.serialize(buf, false);
            NodeHandleSet set = (NodeHandleSet)this.response;
            buf.writeShort(set.getType());
            set.serialize(buf);
        } else {
            super.serialize(buf, true);
        }
        buf.writeInt(this.max);
        buf.writeShort(this.id.getType());
        this.id.serialize(buf);
    }

    public static LookupHandlesMessage build(InputBuffer buf, Endpoint endpoint) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new LookupHandlesMessage(buf, endpoint);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }

    protected LookupHandlesMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        super(buf, endpoint);
        if (this.serType == S_SUB) {
            short type = buf.readShort();
            this.response = endpoint.readNodeHandleSet(buf, type);
        }
        this.max = buf.readInt();
        this.id = endpoint.readId(buf, buf.readShort());
    }
}

