/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.multiring;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import rice.Continuation;
import rice.Executable;
import rice.environment.Environment;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.DeliveryNotification;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.MessageReceipt;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.multiring.MultiringIdRange;
import rice.p2p.multiring.MultiringNode;
import rice.p2p.multiring.MultiringNodeHandle;
import rice.p2p.multiring.MultiringNodeHandleSet;
import rice.p2p.multiring.RingId;
import rice.p2p.util.MRHAdapter;
import rice.p2p.util.rawserialization.JavaSerializedMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiringEndpoint
implements Endpoint {
    protected MultiringNode node;
    protected Application application;
    protected Endpoint endpoint;

    protected MultiringEndpoint(MultiringNode node, Endpoint endpoint, Application application) {
        this.node = node;
        this.endpoint = endpoint;
        this.application = application;
    }

    @Override
    public Id getId() {
        return RingId.build(this.node.getRingId(), this.endpoint.getId());
    }

    @Override
    public MessageReceipt route(Id id, Message message, NodeHandle hint) {
        return this.route(id, message, hint, null);
    }

    @Override
    public MessageReceipt route(Id id, Message message, NodeHandle hint, DeliveryNotification deliverAckToMe) {
        if (message instanceof RawMessage) {
            return this.route(id, (RawMessage)message, hint, deliverAckToMe);
        }
        MRHAdapter ret = new MRHAdapter();
        return this.route(id, new JavaSerializedMessage(message), hint, deliverAckToMe);
    }

    @Override
    public MessageReceipt route(Id id, RawMessage message, NodeHandle hint) {
        return this.route(id, message, hint, null);
    }

    @Override
    public MessageReceipt route(Id id, RawMessage message, NodeHandle hint, DeliveryNotification deliverAckToMe) {
        RingId mId = (RingId)id;
        MultiringNodeHandle mHint = (MultiringNodeHandle)hint;
        if (mId == null) {
            if (mHint.getRingId().equals(this.node.getRingId())) {
                return this.endpoint.route(null, message, mHint.getHandle(), deliverAckToMe);
            }
            return this.route(mHint.getId(), message, null, deliverAckToMe);
        }
        if (mId.getRingId().equals(this.node.getRingId())) {
            if (mHint != null && mHint.getRingId().equals(this.node.getRingId())) {
                return this.endpoint.route(mId.getId(), message, mHint.getHandle(), deliverAckToMe);
            }
            return this.endpoint.route(mId.getId(), message, null, deliverAckToMe);
        }
        return this.node.getCollection().route(mId, message, this.getInstance(), deliverAckToMe);
    }

    @Override
    public NodeHandleSet localLookup(Id id, int num, boolean safe) {
        return new MultiringNodeHandleSet(this.node.getRingId(), this.endpoint.localLookup(((RingId)id).getId(), num, safe));
    }

    @Override
    public NodeHandleSet neighborSet(int num) {
        return new MultiringNodeHandleSet(this.node.getRingId(), this.endpoint.neighborSet(num));
    }

    @Override
    public NodeHandleSet replicaSet(Id id, int maxRank) {
        if (((RingId)id).getRingId().equals(this.node.getRingId())) {
            return new MultiringNodeHandleSet(this.node.getRingId(), this.endpoint.replicaSet(((RingId)id).getId(), maxRank));
        }
        return new MultiringNodeHandleSet(((RingId)id).getRingId(), this.node.getNode().getIdFactory().buildNodeHandleSet());
    }

    @Override
    public NodeHandleSet replicaSet(Id id, int maxRank, NodeHandle root, NodeHandleSet set) {
        if (((RingId)id).getRingId().equals(this.node.getRingId())) {
            return new MultiringNodeHandleSet(this.node.getRingId(), this.endpoint.replicaSet(((RingId)id).getId(), maxRank, ((MultiringNodeHandle)root).getHandle(), ((MultiringNodeHandleSet)set).getSet()));
        }
        return new MultiringNodeHandleSet(((RingId)id).getRingId(), this.node.getNode().getIdFactory().buildNodeHandleSet());
    }

    @Override
    public IdRange range(NodeHandle handle, int rank, Id lkey) {
        IdRange result;
        if (lkey != null) {
            lkey = ((RingId)lkey).getId();
        }
        if ((result = this.endpoint.range(((MultiringNodeHandle)handle).getHandle(), rank, lkey)) != null) {
            return new MultiringIdRange(this.node.getRingId(), result);
        }
        return null;
    }

    @Override
    public IdRange range(NodeHandle handle, int rank, Id lkey, boolean cumulative) {
        IdRange result;
        if (lkey != null) {
            lkey = ((RingId)lkey).getId();
        }
        if ((result = this.endpoint.range(((MultiringNodeHandle)handle).getHandle(), rank, lkey, cumulative)) != null) {
            return new MultiringIdRange(this.node.getRingId(), result);
        }
        return null;
    }

    @Override
    public NodeHandle getLocalNodeHandle() {
        return new MultiringNodeHandle(this.node.getRingId(), this.endpoint.getLocalNodeHandle());
    }

    @Override
    public CancellableTask scheduleMessage(Message message, long delay) {
        return this.endpoint.scheduleMessage(message, delay);
    }

    @Override
    public CancellableTask scheduleMessage(Message message, long delay, long period) {
        return this.endpoint.scheduleMessage(message, delay, period);
    }

    @Override
    public CancellableTask scheduleMessageAtFixedRate(Message message, long delay, long period) {
        return this.endpoint.scheduleMessageAtFixedRate(message, delay, period);
    }

    @Override
    public List networkNeighbors(int num) {
        return this.endpoint.networkNeighbors(num);
    }

    @Override
    public void process(Executable task, Continuation command) {
        this.endpoint.process(task, command);
    }

    protected void deliver(RingId id, Message target) {
        this.application.deliver(id, target);
    }

    @Override
    public String getInstance() {
        return "multiring" + this.endpoint.getInstance();
    }

    @Override
    public Environment getEnvironment() {
        return this.node.getEnvironment();
    }

    @Override
    public void connect(NodeHandle handle, AppSocketReceiver receiver, int timeout) {
        MultiringNodeHandle mHandle = (MultiringNodeHandle)handle;
        this.endpoint.connect(mHandle.getHandle(), receiver, timeout);
    }

    @Override
    public void accept(AppSocketReceiver receiver) {
        this.endpoint.accept(receiver);
    }

    @Override
    public void setDeserializer(MessageDeserializer md) {
        this.endpoint.setDeserializer(md);
    }

    @Override
    public MessageDeserializer getDeserializer() {
        return this.endpoint.getDeserializer();
    }

    @Override
    public Id readId(InputBuffer buf, short type) throws IOException {
        if (type == RingId.TYPE) {
            return new RingId(buf, this.endpoint);
        }
        return this.endpoint.readId(buf, type);
    }

    @Override
    public NodeHandle readNodeHandle(InputBuffer buf) throws IOException {
        return new MultiringNodeHandle(buf, this.endpoint);
    }

    @Override
    public IdRange readIdRange(InputBuffer buf) throws IOException {
        return new MultiringIdRange(buf, this.endpoint);
    }

    @Override
    public NodeHandle coalesce(NodeHandle handle) {
        if (handle instanceof MultiringNodeHandle) {
            MultiringNodeHandle mnh = (MultiringNodeHandle)handle;
            mnh.handle = this.endpoint.coalesce(mnh.handle);
            return mnh;
        }
        return this.endpoint.coalesce(handle);
    }

    @Override
    public NodeHandleSet readNodeHandleSet(InputBuffer buf, short type) throws IOException {
        switch (type) {
            case 10: {
                return new MultiringNodeHandleSet(buf, this.endpoint);
            }
        }
        return this.endpoint.readNodeHandleSet(buf, type);
    }

    public String toString() {
        return "MRE[" + this.endpoint + "]";
    }

    @Override
    public void register() {
        this.endpoint.register();
    }

    @Override
    public int proximity(NodeHandle nh) {
        return this.endpoint.proximity(nh);
    }

    @Override
    public boolean isAlive(NodeHandle nh) {
        return this.endpoint.isAlive(nh);
    }

    @Override
    public void setConsistentRouting(boolean val) {
        this.endpoint.setConsistentRouting(val);
    }

    @Override
    public boolean routingConsistentFor(Id id) {
        return this.endpoint.routingConsistentFor(id);
    }

    @Override
    public void setSendOptions(Map<String, Object> options) {
        this.endpoint.setSendOptions(options);
    }
}

