/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.glacier.v2.messaging.GlacierMessage;

public class GlacierRefreshResponseMessage
extends GlacierMessage {
    public static final short TYPE = 12;
    protected IdRange range;
    protected boolean online;

    public GlacierRefreshResponseMessage(int uid, IdRange range, boolean online, NodeHandle source, Id dest, char tag) {
        super(uid, source, dest, true, tag);
        this.range = range;
        this.online = online;
    }

    public IdRange getRange() {
        return this.range;
    }

    public boolean isOnline() {
        return this.online;
    }

    public String toString() {
        return "[GlacierRefreshResponse for " + this.range + ", online=" + this.online + "]";
    }

    public short getType() {
        return 12;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        super.serialize(buf);
        this.range.serialize(buf);
        buf.writeBoolean(this.online);
    }

    public static GlacierRefreshResponseMessage build(InputBuffer buf, Endpoint endpoint) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new GlacierRefreshResponseMessage(buf, endpoint);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }

    private GlacierRefreshResponseMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        super(buf, endpoint);
        this.range = endpoint.readIdRange(buf);
        this.online = buf.readBoolean();
    }
}

