/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.glacier.v2.messaging.GlacierMessage;

public class GlacierRangeResponseMessage
extends GlacierMessage {
    public static final short TYPE = 8;
    protected IdRange commonRange;

    public GlacierRangeResponseMessage(int uid, IdRange commonRange, NodeHandle source, Id dest, char tag) {
        super(uid, source, dest, true, tag);
        this.commonRange = commonRange;
    }

    public IdRange getCommonRange() {
        return this.commonRange;
    }

    public String toString() {
        return "[GlacierRangeResponse to UID#" + this.getUID() + ", range=" + this.commonRange + "]";
    }

    public short getType() {
        return 8;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        super.serialize(buf);
        this.commonRange.serialize(buf);
    }

    public static GlacierRangeResponseMessage build(InputBuffer buf, Endpoint endpoint) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new GlacierRangeResponseMessage(buf, endpoint);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }

    private GlacierRangeResponseMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        super(buf, endpoint);
        this.commonRange = endpoint.readIdRange(buf);
    }
}

