/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.commonapi.testing;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import rice.environment.Environment;
import rice.environment.logging.LogManager;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.environment.params.simple.SimpleParameters;
import rice.environment.processing.sim.SimProcessor;
import rice.environment.time.TimeSource;
import rice.environment.time.simple.SimpleTimeSource;
import rice.environment.time.simulated.DirectTimeSource;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.commonapi.PastryIdFactory;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.EuclideanNetwork;
import rice.pastry.direct.GenericNetwork;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.SphereNetwork;
import rice.pastry.dist.DistPastryNodeFactory;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.socket.nat.rendezvous.RendezvousSocketPastryNodeFactory;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.selector.SelectorManager;

public abstract class CommonAPITest {
    protected Node[] nodes;
    protected PastryNodeFactory factory;
    protected NodeIdFactory idFactory;
    protected NetworkSimulator<NodeHandle, Message> simulator;
    protected Environment environment;
    protected Parameters params;
    public int NUM_NODES;
    public final IdFactory FACTORY;
    public static final String SUCCESS = "SUCCESS";
    public static final String FAILURE = "FAILURE";
    protected static final int PAD_SIZE = 60;
    public static final String PROTOCOL_DIRECT = "direct";
    public static final String PROTOCOL_SOCKET = "socket";
    public static final String PROTOCOL_RENDEZVOUS = "rendezvous";
    public static final String SIMULATOR_SPHERE = "sphere";
    public static final String SIMULATOR_EUCLIDEAN = "euclidean";
    public static final String SIMULATOR_GT_ITM = "gt-itm";
    public int PORT;
    public InetSocketAddress BOOTSTRAP;
    public static int BOOTSTRAP_PORT = 5009;
    public String PROTOCOL;
    public String SIMULATOR;
    public static String INSTANCE_NAME = "DistCommonAPITest";
    protected Logger logger;
    public static final int LEASE_PERIOD = 10000;
    public static final int TIME_TO_FIND_FAULTY = 15000;

    public CommonAPITest(Environment env) throws IOException {
        this.environment = env;
        this.setupParams(env);
        this.FACTORY = new PastryIdFactory(env);
        this.idFactory = new RandomNodeIdFactory(this.environment);
        if (this.PROTOCOL.equalsIgnoreCase(PROTOCOL_DIRECT)) {
            this.simulator = this.SIMULATOR.equalsIgnoreCase(SIMULATOR_SPHERE) ? new SphereNetwork<NodeHandle, Message>(env) : (this.SIMULATOR.equalsIgnoreCase(SIMULATOR_GT_ITM) ? new GenericNetwork<NodeHandle, Message>(env) : new EuclideanNetwork<NodeHandle, Message>(env));
            this.factory = new DirectPastryNodeFactory(this.idFactory, this.simulator, env);
        } else if (this.PROTOCOL.equalsIgnoreCase(PROTOCOL_SOCKET)) {
            InetSocketAddress address = this.params.getInetSocketAddress("commonapi_testing_bootstrap");
            this.factory = new SocketPastryNodeFactory(this.idFactory, address.getAddress(), this.PORT, env);
        } else if (this.PROTOCOL.equalsIgnoreCase(PROTOCOL_RENDEZVOUS)) {
            InetSocketAddress address = this.params.getInetSocketAddress("commonapi_testing_bootstrap");
            this.factory = new RendezvousSocketPastryNodeFactory(this.idFactory, address.getAddress(), this.PORT, env, false);
        }
        if (this.factory == null) {
            this.factory = DistPastryNodeFactory.getFactory(this.idFactory, DistPastryNodeFactory.PROTOCOL_SOCKET, this.PORT, env);
        }
        this.nodes = new Node[this.NUM_NODES + 1];
    }

    public void waitToRecoverFromKilling(int additionalTime) {
        this.waitOnClock(25000 + additionalTime);
    }

    public void waitOnClock(int time) {
        if (this.environment.getSelectorManager().isSelectorThread()) {
            return;
        }
        try {
            this.environment.getTimeSource().sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setupParams(Environment env) {
        this.params = env.getParameters();
        this.params.setInt("pastry_socket_scm_num_ping_tries", 2);
        this.params.setString("nat_search_policy", "never");
        this.params.setInt("pastry_protocol_periodicLeafSet_ping_neighbor_period", 8000);
        this.params.setInt("pastry_protocol_periodicLeafSet_lease_period", 10000);
        this.params.setInt("pastry_protocol_periodicLeafSet_request_lease_throttle", 2000);
        this.logger = env.getLogManager().getLogger(this.getClass(), null);
        this.NUM_NODES = this.params.getInt("commonapi_testing_num_nodes");
        this.PORT = this.params.getInt("commonapi_testing_startPort");
        this.PROTOCOL = this.params.getString("commonapi_testing_protocol");
        this.SIMULATOR = this.params.getString("direct_simulator_topology");
    }

    public void createNodes() {
        if (this.simulator != null) {
            this.simulator.setMaxSpeed(10.0f);
        }
        long last = this.environment.getTimeSource().currentTimeMillis();
        for (int i = 0; i < this.NUM_NODES; ++i) {
            this.nodes[i] = this.createNode(i);
            this.simulate();
            this.processNode(i, this.nodes[i]);
            this.simulate();
            long now = this.environment.getTimeSource().currentTimeMillis();
            System.out.println("Created node " + i + " with id " + this.nodes[i] + " at " + now + " " + (now - last));
            last = now;
            if (this.logger.level > 500) continue;
            this.logger.log(((PastryNode)this.nodes[i]).getLeafSet().toString());
        }
        if (this.logger.level <= 800) {
            this.logger.log(((PastryNode)this.nodes[0]).getLeafSet().toString());
        }
        if (this.simulator != null) {
            this.simulator.setFullSpeed();
        }
    }

    public void start() {
        this.createNodes();
        System.out.println("\nTest Beginning\n");
        this.runTest();
    }

    protected void simulate() {
        this.simulate(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void simulate(int numOps) {
        if (this.environment.getSelectorManager().isSelectorThread()) {
            return;
        }
        CommonAPITest commonAPITest = this;
        synchronized (commonAPITest) {
            try {
                this.wait(500 * numOps);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node createNode(int num) {
        PastryNode ret = num == 0 ? this.factory.newNode((rice.pastry.NodeHandle)null) : this.factory.newNode(this.getBootstrap());
        PastryNode pastryNode = ret;
        synchronized (pastryNode) {
            while (!ret.isReady()) {
                try {
                    ret.wait(1000L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                    return null;
                }
                if (ret.isReady() || this.logger.level > 800) continue;
                this.logger.log("Node " + ret + " is not yet ready.");
            }
        }
        return ret;
    }

    protected rice.pastry.NodeHandle getBootstrap() {
        if (this.PROTOCOL.equalsIgnoreCase(PROTOCOL_DIRECT)) {
            return ((PastryNode)this.nodes[0]).getLocalHandle();
        }
        try {
            InetSocketAddress address = this.params.getInetSocketAddress("commonapi_testing_bootstrap");
            return ((SocketPastryNodeFactory)this.factory).getNodeHandle(address);
        }
        catch (UnknownHostException uhe) {
            throw new RuntimeException(uhe);
        }
    }

    protected synchronized void pause(int ms) {
        try {
            this.environment.getTimeSource().sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void kill(int n) {
        ((PastryNode)this.nodes[n]).destroy();
        if (!this.PROTOCOL.equalsIgnoreCase(PROTOCOL_DIRECT)) {
            this.pause(2000);
        }
    }

    protected abstract void processNode(int var1, Node var2);

    protected abstract void runTest();

    protected final void sectionStart(String name) {
        System.out.println(name);
    }

    protected final void sectionDone() {
        System.out.println();
    }

    protected final void stepStart(String name) {
        System.out.print(this.pad("  " + name));
    }

    protected final void stepDone() {
        this.stepDone(SUCCESS);
    }

    protected final void stepDone(String status) {
        this.stepDone(status, "");
    }

    protected final void stepDone(String status, String message) {
        System.out.println("[" + status + "]");
        if (message != null && !message.equals("")) {
            System.out.println("     " + message);
        }
        if (status.equals(FAILURE)) {
            if (this.environment.getParameters().getBoolean("commonapi_testing_exit_on_failure")) {
                System.exit(1);
            } else {
                try {
                    Thread.sleep(100000000L);
                }
                catch (InterruptedException ie) {
                    System.exit(1);
                }
            }
        }
    }

    protected final void stepException(Exception e) {
        this.logger.logException("\nException occurred during testing.", e);
        System.exit(2);
    }

    private final String pad(String start) {
        if (start.length() >= 60) {
            return start.substring(0, 60);
        }
        int spaceLength = 60 - start.length();
        char[] spaces = new char[spaceLength];
        Arrays.fill(spaces, '.');
        return start.concat(new String(spaces));
    }

    protected final void assertTrue(String intention, boolean test) {
        if (!test) {
            this.stepDone(FAILURE, "Assertion '" + intention + "' failed.");
        }
    }

    protected final void assertEquals(String description, Object expected, Object actual) {
        if (!expected.equals(actual)) {
            this.stepDone(FAILURE, "Assertion '" + description + "' failed, expected: '" + expected + "' got: " + actual + "'");
        }
    }

    public static Environment parseArgs(String[] args) throws IOException {
        TimeSource timeSource;
        int p;
        int i;
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (!args[i2].equals("-help")) continue;
            System.out.println("Usage: DistCommonAPITest [-params paramsfile] [-port p] [-protocol (direct|socket)] [-bootstrap host[:port]] [-help]");
            System.exit(1);
        }
        SimpleParameters params = null;
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-params") || i + 1 >= args.length) continue;
            params = new SimpleParameters(Environment.defaultParamFileArray, args[i + 1]);
            break;
        }
        if (params == null) {
            params = new SimpleParameters(Environment.defaultParamFileArray, null);
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-protocol") || i + 1 >= args.length) continue;
            params.setString("commonapi_testing_protocol", args[i + 1]);
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-simulator") || i + 1 >= args.length) continue;
            params.setString("direct_simulator_topology", args[i + 1]);
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-nodes") || i + 1 >= args.length) continue;
            p = Integer.parseInt(args[i + 1]);
            if (p <= 0) break;
            params.setInt("commonapi_testing_num_nodes", p);
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-port") || i + 1 >= args.length) continue;
            p = Integer.parseInt(args[i + 1]);
            if (p <= 0) break;
            params.setInt("commonapi_testing_startPort", p);
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-bootstrap") || i + 1 >= args.length) continue;
            String str = args[i + 1];
            int index = str.indexOf(58);
            if (index == -1) {
                params.setInetSocketAddress("commonapi_testing_bootstrap", new InetSocketAddress(InetAddress.getByName(str), params.getInt("commonapi_testing_startPort")));
                break;
            }
            params.setString("commonapi_testing_bootstrap", str);
            break;
        }
        if (!params.contains("commonapi_testing_bootstrap")) {
            try {
                InetAddress localHost = InetAddress.getLocalHost();
                params.setInetSocketAddress("commonapi_testing_bootstrap", new InetSocketAddress(localHost, params.getInt("commonapi_testing_startPort")));
            }
            catch (UnknownHostException e) {
                System.err.println("Error determining local host: " + e);
            }
        }
        SelectorManager selector = null;
        SimProcessor proc = null;
        LogManager logManager = null;
        if (params.getString("commonapi_testing_protocol").equals(PROTOCOL_DIRECT)) {
            timeSource = new DirectTimeSource(params);
            logManager = Environment.generateDefaultLogManager(timeSource, params);
            ((DirectTimeSource)timeSource).setLogManager(logManager);
            selector = Environment.generateDefaultSelectorManager(timeSource, logManager);
            ((DirectTimeSource)timeSource).setSelectorManager(selector);
            proc = new SimProcessor(selector);
        } else {
            timeSource = new SimpleTimeSource();
        }
        return new Environment(selector, proc, null, timeSource, logManager, params, null);
    }
}

