/*
 * Decompiled with CFR 0.152.
 */
package rice.environment.processing.simple;

import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import rice.Continuation;
import rice.Executable;
import rice.environment.Environment;
import rice.environment.logging.LogManager;
import rice.environment.processing.Processor;
import rice.environment.processing.WorkRequest;
import rice.environment.processing.simple.BlockingIOThread;
import rice.environment.processing.simple.ProcessingRequest;
import rice.environment.processing.simple.ProcessingThread;
import rice.environment.processing.simple.WorkQueue;
import rice.environment.time.TimeSource;
import rice.selector.SelectorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleProcessor
implements Processor {
    private PriorityBlockingQueue<ProcessingRequest> QUEUE;
    private ProcessingThread THREAD;
    private WorkQueue workQueue;
    private BlockingIOThread bioThread;
    long seq = Long.MIN_VALUE;

    public SimpleProcessor(String name) {
        this.QUEUE = new PriorityBlockingQueue();
        this.THREAD = new ProcessingThread(name + ".ProcessingThread", this.QUEUE);
        this.THREAD.start();
        this.THREAD.setPriority(1);
        this.workQueue = new WorkQueue();
        this.bioThread = new BlockingIOThread(this.workQueue);
        this.bioThread.start();
    }

    @Override
    public <R, E extends Exception> void process(Executable<R> task, Continuation<R, E> command, SelectorManager selector, TimeSource ts, LogManager log) {
        this.process(task, command, 0, selector, ts, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R, E extends Exception> void process(Executable<R> task, Continuation<R, E> command, int priority, SelectorManager selector, TimeSource ts, LogManager log) {
        long nextSeq;
        SimpleProcessor simpleProcessor = this;
        synchronized (simpleProcessor) {
            nextSeq = this.seq++;
        }
        this.QUEUE.offer(new ProcessingRequest(task, command, priority, nextSeq, log, ts, selector));
    }

    @Override
    public void processBlockingIO(WorkRequest workRequest) {
        this.workQueue.enqueue(workRequest);
    }

    public Queue<ProcessingRequest> getQueue() {
        return this.QUEUE;
    }

    @Override
    public void destroy() {
        this.THREAD.destroy();
        this.QUEUE.clear();
        this.bioThread.destroy();
        this.workQueue.destroy();
    }

    public WorkQueue getIOQueue() {
        return this.workQueue;
    }

    public static void main(String[] args) throws Exception {
        Environment env = new Environment();
        Processor p = env.getProcessor();
        p.process(new Executable(){

            public Object execute() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return null;
            }
        }, new Continuation(){

            public void receiveResult(Object result) {
                System.out.println("Done blocking.");
            }

            public void receiveException(Exception exception) {
                exception.printStackTrace();
            }
        }, env.getSelectorManager(), env.getTimeSource(), env.getLogManager());
        int seq = 0;
        while (seq < 10) {
            final int mySeq = seq++;
            p.process(new Executable(){

                public Object execute() {
                    System.out.println("Executed Seq: " + mySeq);
                    return null;
                }
            }, new Continuation(){

                public void receiveResult(Object result) {
                    System.out.println("Received Seq: " + mySeq);
                }

                public void receiveException(Exception exception) {
                    exception.printStackTrace();
                }
            }, env.getSelectorManager(), env.getTimeSource(), env.getLogManager());
            System.out.println("Done scheduling " + mySeq);
        }
    }
}

