/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.wire;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.util.SocketRequestHandleImpl;
import org.mpisws.p2p.transport.wire.SocketManager;
import org.mpisws.p2p.transport.wire.WireTransportLayerImpl;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.selector.SelectionKeyHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCPLayer
extends SelectionKeyHandler {
    public static final Map<String, Object> OPTIONS;
    public final int MAX_OPEN_SOCKETS;
    public final int SOCKET_BUFFER_SIZE;
    WireTransportLayerImpl wire;
    private SelectionKey key;
    private ByteBuffer buffer;
    Logger logger;
    Collection<SocketManager> sockets = new HashSet<SocketManager>();

    public TCPLayer(WireTransportLayerImpl wire, boolean enableServer) throws IOException {
        this.wire = wire;
        this.logger = wire.environment.getLogManager().getLogger(TCPLayer.class, null);
        Parameters p = wire.environment.getParameters();
        this.MAX_OPEN_SOCKETS = p.getInt("pastry_socket_scm_max_open_sockets");
        this.SOCKET_BUFFER_SIZE = p.getInt("pastry_socket_scm_socket_buffer_size");
        ServerSocketChannel temp = null;
        if (enableServer) {
            ServerSocketChannel channel;
            temp = channel = ServerSocketChannel.open();
            channel.configureBlocking(false);
            channel.socket().setReuseAddress(true);
            channel.socket().bind(wire.bindAddress);
            if (this.logger.level <= 800) {
                this.logger.log("TCPLayer bound to " + wire.bindAddress);
            }
            this.key = wire.environment.getSelectorManager().register(channel, this, 16);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketRequestHandle<InetSocketAddress> openSocket(InetSocketAddress destination, SocketCallback<InetSocketAddress> deliverSocketToMe, Map<String, Object> options) {
        if (this.isDestroyed()) {
            return null;
        }
        if (this.logger.level <= 300) {
            this.logger.logException("openSocket(" + destination + ")", new Exception("Stack Trace"));
        } else if (this.logger.level <= 500) {
            this.logger.log("openSocket(" + destination + ")");
        }
        if (deliverSocketToMe == null) {
            throw new IllegalArgumentException("deliverSocketToMe must be non-null!");
        }
        try {
            this.wire.broadcastChannelOpened(destination, options, true);
            Collection<SocketManager> collection = this.sockets;
            synchronized (collection) {
                SocketManager sm = new SocketManager(this, destination, deliverSocketToMe, options);
                this.sockets.add(sm);
                return sm;
            }
        }
        catch (IOException e) {
            if (this.logger.level <= 900) {
                this.logger.logException("GOT ERROR " + e + " OPENING PATH - MARKING PATH " + destination + " AS DEAD!", e);
            }
            SocketRequestHandleImpl<InetSocketAddress> can = new SocketRequestHandleImpl<InetSocketAddress>(destination, options, this.logger);
            deliverSocketToMe.receiveException(can, e);
            return can;
        }
    }

    protected void socketClosed(SocketManager sm) {
        this.wire.broadcastChannelClosed(sm.addr, sm.options);
        this.sockets.remove(sm);
    }

    public void destroy() {
        if (this.logger.level <= 800) {
            this.logger.log("destroy()");
        }
        try {
            this.key.channel().close();
            this.key.cancel();
            this.key.attach(null);
        }
        catch (IOException ioe) {
            this.wire.errorHandler.receivedException(null, ioe);
        }
        for (SocketManager socket : new ArrayList<SocketManager>(this.sockets)) {
            socket.close();
        }
    }

    public void acceptSockets(final boolean b) {
        Runnable r = new Runnable(){

            public void run() {
                if (b) {
                    TCPLayer.this.key.interestOps(TCPLayer.this.key.interestOps() | 0x10);
                } else {
                    TCPLayer.this.key.interestOps(TCPLayer.this.key.interestOps() & 0xFFFFFFEF);
                }
            }
        };
        if (this.wire.environment.getSelectorManager().isSelectorThread()) {
            r.run();
        } else {
            this.wire.environment.getSelectorManager().invoke(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(SelectionKey key) {
        block5: {
            try {
                SocketManager sm = new SocketManager(this, key);
                Collection<SocketManager> collection = this.sockets;
                synchronized (collection) {
                    this.sockets.add(sm);
                }
                this.wire.incomingSocket(sm);
            }
            catch (IOException e) {
                if (this.logger.level > 900) break block5;
                this.logger.log("ERROR (accepting connection): " + e);
            }
        }
    }

    public boolean isDestroyed() {
        return this.wire.isDestroyed();
    }

    static {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("transport_type", 1);
        OPTIONS = Collections.unmodifiableMap(map);
    }
}

