/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.sourceroute;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import rice.p2p.commonapi.rawserialization.OutputBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceRoute<Identifier> {
    protected List<Identifier> path;

    protected SourceRoute(List<Identifier> path) {
        this.path = new ArrayList<Identifier>(path);
        for (Identifier i : this.path) {
            if (i != null) continue;
            throw new IllegalArgumentException("path[" + i + "] is null");
        }
    }

    protected SourceRoute(Identifier address) {
        this.path = new ArrayList<Identifier>(1);
        this.path.add(address);
    }

    protected SourceRoute(Identifier local, Identifier remote) {
        this.path = new ArrayList<Identifier>(1);
        this.path.add(local);
        this.path.add(remote);
    }

    public int hashCode() {
        int result = 399388937;
        for (Identifier i : this.path) {
            result ^= i.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SourceRoute)) {
            return false;
        }
        SourceRoute that = (SourceRoute)o;
        return ((Object)this.path).equals(that.path);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("{");
        for (int i = 0; i < this.path.size(); ++i) {
            Identifier thePath = this.path.get(i);
            result.append(thePath.toString());
            if (i >= this.path.size() - 1) continue;
            result.append(" -> ");
        }
        result.append("}");
        return result.toString();
    }

    public Identifier getFirstHop() {
        return this.path.get(0);
    }

    public Identifier getLastHop() {
        return this.path.get(this.path.size() - 1);
    }

    public int getNumHops() {
        return this.path.size();
    }

    public Identifier getHop(int i) {
        return this.path.get(i);
    }

    public boolean isDirect() {
        return this.path.size() <= 2;
    }

    public boolean goesThrough(Identifier address) {
        return this.path.contains(address);
    }

    public int getHop(Identifier identifier) {
        for (int i = 0; i < this.path.size(); ++i) {
            Identifier id = this.path.get(i);
            if (!id.equals(identifier)) continue;
            return i;
        }
        return -1;
    }

    public abstract void serialize(OutputBuffer var1) throws IOException;

    public abstract int getSerializedLength();
}

