/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.simpleidentity;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.mpisws.p2p.transport.simpleidentity.LocalIdentifierStrategy;
import org.mpisws.p2p.transport.simpleidentity.Serializer;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableInetSocketAddressStrategy
implements LocalIdentifierStrategy<InetSocketAddress> {
    int port;
    Serializer<InetSocketAddress> serializer;
    InetAddress lastLocalAddress;
    byte[] lastBytes;

    public MutableInetSocketAddressStrategy(int port, Serializer<InetSocketAddress> serializer) {
        this.serializer = serializer;
        this.port = port;
    }

    @Override
    public synchronized byte[] getLocalIdentifierBytes() throws IOException {
        InetAddress newAddr = this.getLocalAddress();
        if (this.lastLocalAddress == null || newAddr.equals(this.lastLocalAddress)) {
            this.lastLocalAddress = newAddr;
            this.lastBytes = this.serializeAddress(new InetSocketAddress(newAddr, this.port));
        }
        return this.lastBytes;
    }

    protected byte[] serializeAddress(InetSocketAddress addr) throws IOException {
        System.out.println("Address changed to " + addr);
        SimpleOutputBuffer sob = new SimpleOutputBuffer();
        this.serializer.serialize(addr, sob);
        return sob.getBytes();
    }

    protected InetAddress getLocalAddress() throws IOException {
        return InetAddress.getLocalHost();
    }
}

