/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.replay.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.mpisws.p2p.transport.ClosedChannelException;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.peerreview.PeerReviewEvents;
import org.mpisws.p2p.transport.peerreview.replay.record.RecordLayer;
import org.mpisws.p2p.transport.util.SocketWrapperSocket;
import rice.environment.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordSocket<Identifier>
extends SocketWrapperSocket<Identifier, Identifier>
implements PeerReviewEvents {
    int socketId;
    ByteBuffer socketIdBuffer;
    RecordLayer<Identifier> recordLayer;
    boolean closed = false;
    boolean outputShutdown = false;

    public RecordSocket(Identifier identifier, P2PSocket<Identifier> socket, Logger logger, Map<String, Object> options, int socketId, ByteBuffer sib, RecordLayer<Identifier> recordLayer) {
        super(identifier, socket, logger, recordLayer.handler, options);
        this.socketId = socketId;
        this.socketIdBuffer = sib;
        this.recordLayer = recordLayer;
    }

    @Override
    public long read(ByteBuffer dsts) throws IOException {
        int ret;
        block6: {
            int pos = dsts.position();
            ret = (int)super.read(dsts);
            if (ret < 0) {
                try {
                    this.socketIdBuffer.clear();
                    this.recordLayer.logEvent((short)12, this.socketIdBuffer);
                }
                catch (IOException ioe) {
                    if (this.logger.level <= 900) {
                        this.logger.logException(this + ".read()", ioe);
                    }
                    break block6;
                }
            }
            ByteBuffer bits = ByteBuffer.wrap(dsts.array());
            bits.position(pos);
            bits.limit(pos + ret);
            try {
                this.socketIdBuffer.clear();
                this.recordLayer.logEvent((short)16, this.socketIdBuffer, bits);
            }
            catch (IOException ioe) {
                if (this.logger.level > 900) break block6;
                this.logger.logException(this + ".read()", ioe);
            }
        }
        return ret;
    }

    @Override
    public long write(ByteBuffer srcs) throws IOException {
        int ret;
        block6: {
            int pos = srcs.position();
            ret = (int)super.write(srcs);
            if (ret < 0) {
                try {
                    this.socketIdBuffer.clear();
                    this.recordLayer.logEvent((short)12, this.socketIdBuffer);
                }
                catch (IOException ioe) {
                    if (this.logger.level <= 900) {
                        this.logger.logException(this + ".write()", ioe);
                    }
                    break block6;
                }
            }
            ByteBuffer bits = ByteBuffer.wrap(srcs.array());
            bits.position(pos);
            bits.limit(pos + ret);
            try {
                this.socketIdBuffer.clear();
                this.recordLayer.logEvent((short)17, this.socketIdBuffer, bits);
            }
            catch (IOException ioe) {
                if (this.logger.level > 900) break block6;
                this.logger.logException(this + ".write()", ioe);
            }
        }
        return ret;
    }

    @Override
    public void close() {
        block2: {
            try {
                this.closed = true;
                this.socketIdBuffer.clear();
                this.recordLayer.logEvent((short)11, this.socketIdBuffer);
            }
            catch (IOException ioe2) {
                if (this.logger.level > 900) break block2;
                this.logger.logException(this + ".receiveException()", ioe2);
            }
        }
        super.close();
    }

    @Override
    public void shutdownOutput() {
        block2: {
            try {
                this.outputShutdown = true;
                this.socketIdBuffer.clear();
                this.recordLayer.logEvent((short)20, this.socketIdBuffer);
            }
            catch (IOException ioe2) {
                if (this.logger.level > 900) break block2;
                this.logger.logException(this + ".receiveException()", ioe2);
            }
        }
        super.shutdownOutput();
    }

    @Override
    public void register(boolean wantToRead, boolean wantToWrite, final P2PSocketReceiver<Identifier> receiver) {
        if (this.closed) {
            receiver.receiveException(this, new ClosedChannelException("Socket " + this + " already closed."));
            return;
        }
        if (wantToWrite && this.outputShutdown) {
            receiver.receiveException(this, new ClosedChannelException("Socket " + this + " already shutdown output."));
            return;
        }
        super.register(wantToRead, wantToWrite, new P2PSocketReceiver<Identifier>(){

            @Override
            public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
                block8: {
                    short evt;
                    if (canRead && canWrite) {
                        evt = 15;
                    } else if (canRead) {
                        evt = 13;
                    } else if (canWrite) {
                        evt = 14;
                    } else {
                        throw new IOException("I can't read or write. canRead:" + canRead + " canWrite:" + canWrite);
                    }
                    try {
                        RecordSocket.this.socketIdBuffer.clear();
                        RecordSocket.this.recordLayer.logEvent(evt, RecordSocket.this.socketIdBuffer);
                    }
                    catch (IOException ioe2) {
                        if (((RecordSocket)RecordSocket.this).logger.level > 900) break block8;
                        RecordSocket.this.logger.logException(this + ".receiveException()", ioe2);
                    }
                }
                receiver.receiveSelectResult(RecordSocket.this, canRead, canWrite);
            }

            @Override
            public void receiveException(P2PSocket<Identifier> socket, Exception ioe) {
                block2: {
                    try {
                        RecordSocket.this.socketIdBuffer.clear();
                        RecordSocket.this.recordLayer.logSocketException(RecordSocket.this.socketIdBuffer, ioe);
                    }
                    catch (IOException ioe2) {
                        if (((RecordSocket)RecordSocket.this).logger.level > 900) break block2;
                        RecordSocket.this.logger.logException(this + "@" + RecordSocket.this.socketId + ".receiveException()", ioe2);
                    }
                }
                receiver.receiveException(socket, ioe);
            }
        });
    }
}

