/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.replay.playback;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.mpisws.p2p.transport.ClosedChannelException;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.peerreview.Verifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaySocket<Identifier>
implements P2PSocket<Identifier>,
SocketRequestHandle<Identifier> {
    protected Identifier identifier;
    protected int socketId;
    protected Verifier<Identifier> verifier;
    boolean closed = false;
    boolean outputShutdown = false;
    Map<String, Object> options;
    P2PSocketReceiver<Identifier> reader;
    P2PSocketReceiver<Identifier> writer;
    SocketCallback<Identifier> deliverSocketToMe;

    public ReplaySocket(Identifier identifier, int socketId, Verifier<Identifier> verifier, Map<String, Object> options) {
        this.identifier = identifier;
        this.socketId = socketId;
        this.verifier = verifier;
        this.options = options;
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Override
    public long read(ByteBuffer dst) throws IOException {
        return this.verifier.readSocket(this.socketId, dst);
    }

    @Override
    public long write(ByteBuffer src) throws IOException {
        return this.verifier.writeSocket(this.socketId, src);
    }

    @Override
    public void register(boolean wantToRead, boolean wantToWrite, P2PSocketReceiver<Identifier> receiver) {
        if (this.closed) {
            receiver.receiveException(this, new ClosedChannelException("Socket " + this + " already closed."));
            return;
        }
        if (wantToWrite && this.outputShutdown) {
            receiver.receiveException(this, new ClosedChannelException("Socket " + this + " already shutdown output."));
            return;
        }
        if (wantToWrite && this.writer != null && this.writer != receiver) {
            throw new IllegalStateException("Already registered " + this.writer + " for writing, you can't register " + receiver + " for writing as well!");
        }
        if (wantToRead) {
            if (this.reader != null && this.reader != receiver) {
                throw new IllegalStateException("Already registered " + this.reader + " for reading, you can't register " + receiver + " for reading as well!");
            }
            this.reader = receiver;
        }
        if (wantToWrite) {
            this.writer = receiver;
        }
    }

    public void notifyIO(boolean canRead, boolean canWrite) throws IOException {
        if (!canRead && !canWrite) {
            throw new IOException("I can't read or write. canRead:" + canRead + " canWrite:" + canWrite);
        }
        if (canRead && canWrite) {
            if (this.writer != this.reader) {
                throw new IllegalStateException("weader != writer canRead:" + canRead + " canWrite:" + canWrite);
            }
            P2PSocketReceiver<Identifier> temp = this.writer;
            this.writer = null;
            this.reader = null;
            temp.receiveSelectResult(this, canRead, canWrite);
            return;
        }
        if (canRead) {
            if (this.reader == null) {
                throw new IllegalStateException("reader:" + this.reader + " canRead:" + canRead);
            }
            P2PSocketReceiver<Identifier> temp = this.reader;
            this.reader = null;
            temp.receiveSelectResult(this, canRead, canWrite);
            return;
        }
        if (canWrite) {
            if (this.writer == null) {
                throw new IllegalStateException("writer:" + this.writer + " canWrite:" + canWrite);
            }
            P2PSocketReceiver<Identifier> temp = this.writer;
            this.writer = null;
            temp.receiveSelectResult(this, canRead, canWrite);
            return;
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.verifier.close(this.socketId);
    }

    public void setDeliverSocketToMe(SocketCallback<Identifier> deliverSocketToMe) {
        this.deliverSocketToMe = deliverSocketToMe;
    }

    public void socketOpened() {
        this.deliverSocketToMe.receiveResult(this, this);
        this.deliverSocketToMe = null;
    }

    @Override
    public void shutdownOutput() {
        this.outputShutdown = true;
        this.verifier.shutdownOutput(this.socketId);
    }

    public void receiveException(IOException ioe) {
        if (this.deliverSocketToMe != null) {
            this.deliverSocketToMe.receiveException(this, ioe);
            return;
        }
        if (this.writer != null) {
            if (this.writer == this.reader) {
                this.writer.receiveException(this, ioe);
                this.writer = null;
                this.reader = null;
            } else {
                this.writer.receiveException(this, ioe);
                this.writer = null;
            }
        }
        if (this.reader != null) {
            this.reader.receiveException(this, ioe);
            this.reader = null;
        }
    }

    @Override
    public boolean cancel() {
        throw new RuntimeException("Not implemented.");
    }
}

