/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.replay;

import java.io.IOException;
import org.mpisws.p2p.transport.peerreview.PeerReviewEvents;
import org.mpisws.p2p.transport.peerreview.history.IndexEntry;
import org.mpisws.p2p.transport.peerreview.history.SecureHistory;
import org.mpisws.p2p.transport.peerreview.history.SecureHistoryFactoryImpl;
import org.mpisws.p2p.transport.peerreview.history.reader.EntryDeserializer;
import org.mpisws.p2p.transport.peerreview.history.reader.LogReader;
import org.mpisws.p2p.transport.peerreview.history.stub.NullHashProvider;
import rice.environment.Environment;
import rice.p2p.util.rawserialization.SimpleInputBuffer;

public class BasicEntryDeserializer
implements PeerReviewEvents,
EntryDeserializer {
    public String entryId(short id) {
        switch (id) {
            case 0: {
                return "Send";
            }
            case 1: {
                return "Receive";
            }
            case 2: {
                return "Sign";
            }
            case 3: {
                return "Ack";
            }
            case 4: {
                return "Checkpoint";
            }
            case 5: {
                return "Init";
            }
            case 6: {
                return "Send_sign";
            }
            case 9: {
                return "Socket_open_incoming";
            }
            case 10: {
                return "Socket_open_outgoing";
            }
            case 18: {
                return "Socket_opened_outgoing";
            }
            case 19: {
                return "Socket_exception";
            }
            case 11: {
                return "Socket_close";
            }
            case 12: {
                return "Socket_closed";
            }
            case 13: {
                return "Socket_can_R";
            }
            case 14: {
                return "Socket_can_W";
            }
            case 15: {
                return "Socket_can_RW";
            }
            case 16: {
                return "Socket_R";
            }
            case 17: {
                return "Socket_W";
            }
            case 20: {
                return "Socket_shutdown_output";
            }
        }
        return null;
    }

    public String read(IndexEntry ie, SecureHistory history) throws IOException {
        if (ie.getType() >= 9 && ie.getType() <= 20) {
            return this.entryId(ie.getType()) + " n:" + ie.getSeq() + " i:" + ie.getFileIndex() + " sock:" + new SimpleInputBuffer(history.getEntry(ie, 4)).readInt();
        }
        return this.entryId(ie.getType()) + " n:" + ie.getSeq() + " s:" + ie.getSizeInFile() + " i:" + ie.getFileIndex();
    }

    public static void printLog(String name, EntryDeserializer deserializer, Environment env) throws IOException {
        String line;
        System.out.println("printLog(" + name + ")");
        NullHashProvider hashProv = new NullHashProvider();
        int ctr = 0;
        LogReader reader = new LogReader(name, new SecureHistoryFactoryImpl(hashProv, env), deserializer);
        while ((line = reader.readEntry()) != null) {
            System.out.println("#" + ctr + " " + line);
            ++ctr;
        }
    }

    public static final void main(String[] args) throws IOException {
        BasicEntryDeserializer.printLog(args[0], new BasicEntryDeserializer(), new Environment());
    }
}

