/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.mpisws.p2p.transport.ClosedChannelException;
import org.mpisws.p2p.transport.peerreview.PeerReviewCallback;
import org.mpisws.p2p.transport.peerreview.PeerReviewEvents;
import org.mpisws.p2p.transport.peerreview.history.Hash;
import org.mpisws.p2p.transport.peerreview.history.HashProvider;
import org.mpisws.p2p.transport.peerreview.history.IndexEntry;
import org.mpisws.p2p.transport.peerreview.history.SecureHistory;
import org.mpisws.p2p.transport.peerreview.replay.EventCallback;
import org.mpisws.p2p.transport.peerreview.replay.IdentifierSerializer;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.util.rawserialization.SimpleInputBuffer;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Verifier<Identifier>
implements PeerReviewEvents {
    protected Identifier localHandle;
    protected SecureHistory history;
    PeerReviewCallback app;
    int numEventCallbacks;
    boolean foundFault;
    boolean haveNextEvent;
    long nextEventIndex;
    IndexEntry next;
    boolean nextEventIsHashed;
    InputBuffer nextEvent;
    boolean initialized;
    short signatureSizeBytes;
    short hashSizeBytes;
    int numTimers;
    int[] eventToCallback = new int[256];
    protected Logger logger;
    protected IdentifierSerializer<Identifier> serializer;
    protected HashProvider hashProv;
    boolean useSendSign = false;
    boolean useSenderSeq = false;
    boolean useLogHashFlag = false;
    Map<Short, EventCallback> eventCallback = new HashMap<Short, EventCallback>();

    public Verifier(IdentifierSerializer<Identifier> serializer, HashProvider hashProv, SecureHistory history, Identifier localHandle, short signatureSizeBytes, short hashSizeBytes, int firstEntryToReplay, Logger logger) throws IOException {
        this.logger = logger;
        this.history = history;
        this.numEventCallbacks = 0;
        this.serializer = serializer;
        this.hashProv = hashProv;
        this.localHandle = localHandle;
        this.foundFault = false;
        this.haveNextEvent = false;
        this.nextEventIndex = firstEntryToReplay - 1;
        this.initialized = false;
        this.signatureSizeBytes = signatureSizeBytes;
        this.hashSizeBytes = hashSizeBytes;
        this.numTimers = 0;
        for (int i = 0; i < 256; ++i) {
            this.eventToCallback[i] = -1;
        }
        this.fetchNextEvent();
        if (!this.haveNextEvent) {
            this.foundFault = true;
        }
    }

    public boolean verifiedOK() {
        return !this.foundFault;
    }

    public IndexEntry getNextEvent() {
        return this.next;
    }

    protected abstract void receive(Identifier var1, ByteBuffer var2) throws IOException;

    protected abstract void incomingSocket(Identifier var1, int var2) throws IOException;

    protected abstract void socketIO(int var1, boolean var2, boolean var3) throws IOException;

    protected abstract void socketOpened(int var1) throws IOException;

    protected abstract void socketException(int var1, IOException var2) throws IOException;

    protected void fetchNextEvent() {
        this.haveNextEvent = false;
        ++this.nextEventIndex;
        try {
            this.next = this.history.statEntry(this.nextEventIndex);
        }
        catch (IOException ioe) {
            if (this.logger.level <= 900) {
                this.logger.logException("Error fetching log entry #" + this.nextEventIndex, ioe);
            }
            this.foundFault = true;
            return;
        }
        if (this.logger.level <= 500) {
            this.logger.log("fetchNextEvent():" + this.next);
        }
        if (this.next == null) {
            return;
        }
        if (this.next.getSizeInFile() < 0) {
            this.nextEventIsHashed = true;
            this.nextEvent = new SimpleInputBuffer(this.next.getContentHash().getBytes());
            if (this.logger.level <= 500) {
                this.logger.log("Fetched log entry #" + this.nextEventIndex + " (type " + this.next.getType() + ", hashed, seq=" + this.next.getSeq() + ")");
            }
        } else {
            this.nextEventIsHashed = false;
            try {
                this.nextEvent = new SimpleInputBuffer(this.history.getEntry(this.nextEventIndex, this.next.getSizeInFile()));
            }
            catch (IOException ioe) {
                if (this.logger.level <= 900) {
                    this.logger.logException("Error fetching log entry #" + this.nextEventIndex + " (type " + this.next.getType() + ", size " + this.next.getSizeInFile() + " bytes, seq=" + this.next.getSeq() + ")", ioe);
                }
                this.foundFault = true;
                return;
            }
            if (this.logger.level <= 500) {
                this.logger.log("Fetched log entry #" + this.nextEventIndex + " (type " + this.next.getType() + ", size " + this.next.getSizeInFile() + " bytes, seq=" + this.next.getSeq() + ")");
            }
        }
        this.haveNextEvent = true;
    }

    protected void send(Identifier target, ByteBuffer message, int relevantLen) throws IOException {
        int msgLen = message.remaining();
        int pos = message.position();
        int lim = message.limit();
        if (relevantLen < 0) {
            relevantLen = message.remaining();
        }
        if (this.logger.level <= 500) {
            this.logger.log("Verifier::send(" + target + ", " + relevantLen + "/" + message.remaining() + " bytes)");
        }
        if (!this.haveNextEvent) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: Send event after end of segment; marking as invalid");
            }
            this.foundFault = true;
            return;
        }
        if (this.next.getType() == 5) {
            if (this.logger.level <= 400) {
                this.logger.log("Skipped; next event is an INIT");
            }
            return;
        }
        if (this.next.getType() != 0) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay(" + this.nextEventIndex + "): SEND event during replay, but next event in log is #" + this.next.getType() + "; marking as invalid");
            }
            this.foundFault = true;
            return;
        }
        if (this.nextEventIsHashed) {
            Hash cHash;
            SimpleOutputBuffer buf = new SimpleOutputBuffer();
            this.serializer.serialize(target, buf);
            if (this.useLogHashFlag) {
                buf.writeBoolean(relevantLen < msgLen);
            }
            buf.write(message.array(), message.position(), relevantLen);
            if (relevantLen < msgLen) {
                message.position(pos);
                message.limit(lim);
                Hash hash = this.hashProv.hash(message);
            }
            if (!(cHash = this.hashProv.hash(ByteBuffer.wrap(buf.getBytes()))).equals(this.next.getContentHash())) {
                if (this.logger.level <= 900) {
                    this.logger.log("Replay: SEND is hashed, but hash of predicted SEND entry does not match hash in the log");
                }
                this.foundFault = true;
                return;
            }
            if (this.useSendSign) {
                this.fetchNextEvent();
                assert (this.next.getType() == 6);
            }
            this.fetchNextEvent();
            return;
        }
        Identifier logReceiver = this.serializer.deserialize(this.nextEvent);
        if (!logReceiver.equals(target)) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay(" + this.nextEventIndex + "): SEND to " + target + " during replay, but log shows SEND to " + logReceiver + "; marking as invalid");
            }
            this.nextEvent = new SimpleInputBuffer(this.history.getEntry(this.next, this.next.getSizeInFile()));
            this.foundFault = true;
            return;
        }
        boolean logIsHashed = false;
        if (this.useLogHashFlag) {
            logIsHashed = this.nextEvent.readBoolean();
        }
        if (logIsHashed) {
            if (relevantLen >= msgLen) {
                if (this.logger.level <= 900) {
                    this.logger.log("Replay: Message sent during replay is entirely relevant, but log entry is partly hashed; marking as invalid");
                }
                this.foundFault = true;
                return;
            }
            int logRelevantLen = this.nextEvent.bytesRemaining() - this.hashSizeBytes;
            assert (logRelevantLen >= 0);
            if (relevantLen != logRelevantLen) {
                if (this.logger.level <= 900) {
                    this.logger.log("Replay: Message sent during replay has " + relevantLen + " relevant bytes, but log entry has " + logRelevantLen + "; marking as invalid");
                }
                this.foundFault = true;
                return;
            }
            byte[] loggedMsg = new byte[logRelevantLen];
            this.nextEvent.read(loggedMsg);
            ByteBuffer loggedMsgBB = ByteBuffer.wrap(loggedMsg);
            if (relevantLen > 0 && message.equals(loggedMsgBB)) {
                if (this.logger.level <= 900) {
                    this.logger.log("Replay: Relevant part of partly hashed message differs");
                }
                if (this.logger.level <= 500) {
                    this.logger.log("Expected: [" + loggedMsgBB + "]");
                }
                if (this.logger.level <= 500) {
                    this.logger.log("Actual:   [" + message + "]");
                }
                this.foundFault = true;
                return;
            }
            Hash logHash = this.hashProv.build(this.nextEvent);
            byte[] msgHashBytes = message.array();
            Hash msgHash = this.hashProv.build(msgHashBytes, msgHashBytes.length - this.hashSizeBytes, this.hashSizeBytes);
            assert (msgLen == relevantLen + this.hashSizeBytes);
            if (!msgHash.equals(logHash)) {
                if (this.logger.level <= 900) {
                    this.logger.log("Replay: Hashed part of partly hashed message differs");
                }
                if (this.logger.level <= 500) {
                    this.logger.log("Expected: [" + logHash + "]");
                }
                if (this.logger.level <= 500) {
                    this.logger.log("Actual:   [" + msgHash + "]");
                }
                this.foundFault = true;
                return;
            }
        } else {
            if (relevantLen < msgLen) {
                if (this.logger.level <= 900) {
                    this.logger.log("Replay: Message sent during replay is only partly relevant, but log entry is not hashed; marking as invalid");
                }
                this.foundFault = true;
                return;
            }
            int logMsglen = this.nextEvent.bytesRemaining();
            if (msgLen != logMsglen) {
                if (this.logger.level <= 900) {
                    this.logger.log("Replay: Message sent during replay has " + msgLen + " bytes, but log entry has " + logMsglen + "; marking as invalid");
                }
                this.foundFault = true;
                return;
            }
            byte[] loggedMsg = new byte[this.nextEvent.bytesRemaining()];
            this.nextEvent.read(loggedMsg);
            byte[] sentMsg = new byte[message.remaining()];
            message.get(sentMsg);
            if (loggedMsg.length != sentMsg.length) {
                if (this.logger.level <= 900) {
                    this.logger.log("Replay: Message sent during replay differs from message in the log by length log:" + loggedMsg.length + " sent:" + sentMsg.length);
                }
                this.foundFault = true;
                return;
            }
            if (msgLen > 0 && !Arrays.equals(loggedMsg, sentMsg)) {
                if (this.logger.level <= 900) {
                    this.logger.log("Replay: Message sent during replay differs from message in the log");
                }
                this.foundFault = true;
                return;
            }
        }
        if (this.useSendSign) {
            this.fetchNextEvent();
            assert (this.next.getType() == 6);
        }
        this.fetchNextEvent();
    }

    public int openSocket(Identifier target) throws IOException {
        if (!this.haveNextEvent) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: OpenSocket event after end of segment; marking as invalid");
            }
            this.foundFault = true;
            return Integer.MIN_VALUE;
        }
        if (this.next.getType() != 10) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: SOCKET_OPEN_OUTGOING event during replay, but next event in log is #" + this.next.getType() + "; marking as invalid");
            }
            this.foundFault = true;
            return Integer.MIN_VALUE;
        }
        int ret = this.nextEvent.readInt();
        Identifier logReceiver = this.serializer.deserialize(this.nextEvent);
        if (!logReceiver.equals(target)) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: SOCKET_OPEN_OUTGOING to " + target + " during replay, but log shows SOCKET_OPEN_OUTGOING to " + logReceiver + "; marking as invalid");
            }
            this.foundFault = true;
            return Integer.MIN_VALUE;
        }
        this.fetchNextEvent();
        return ret;
    }

    public int readSocket(int socketId, ByteBuffer dst) throws IOException {
        if (!this.haveNextEvent) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: ReadSocket event after end of segment; marking as invalid");
            }
            this.foundFault = true;
            return 0;
        }
        if (this.next.getType() == 12) {
            this.fetchNextEvent();
            return -1;
        }
        if (this.next.getType() != 16) {
            if (this.logger.level <= 900) {
                this.logger.logException("Replay (" + this.nextEventIndex + "): SOCKET_READ event during replay, but next event in log is #" + this.next.getType() + "; marking as invalid", new Exception("Stack Trace"));
            }
            this.foundFault = true;
            return Integer.MIN_VALUE;
        }
        int loggedSocket = this.nextEvent.readInt();
        if (loggedSocket != socketId) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: SOCKET_READ on socket " + socketId + " during replay, but log shows SOCKET_READ to " + loggedSocket + "; marking as invalid");
            }
            this.foundFault = true;
            return 0;
        }
        int ret = this.nextEvent.bytesRemaining();
        if (dst.remaining() < ret) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: SOCKET_READ reading a maximum of " + dst.remaining() + " on socket " + socketId + " during replay, but log shows SOCKET_READ reading " + ret + " bytes; marking as invalid");
            }
            this.foundFault = true;
            return 0;
        }
        this.nextEvent.read(dst.array(), dst.position(), ret);
        dst.position(dst.position() + ret);
        this.fetchNextEvent();
        return ret;
    }

    public void generatedSocketException(int socketId, IOException ioe) {
        block8: {
            if (!this.haveNextEvent) {
                if (this.logger.level <= 900) {
                    this.logger.log("Replay: WriteSocket event after end of segment; marking as invalid");
                }
                this.foundFault = true;
                return;
            }
            if (this.next.getType() != 19) {
                if (this.logger.level <= 900) {
                    this.logger.log("Replay: EVT_SOCKET_EXCEPTION event during replay, but next event in log is #" + this.next.getType() + "; marking as invalid");
                }
                this.foundFault = true;
                return;
            }
            try {
                int loggedSocket = this.nextEvent.readInt();
                if (loggedSocket != socketId) {
                    if (this.logger.level <= 900) {
                        this.logger.log("Replay: EVT_SOCKET_EXCEPTION on socket " + socketId + " during replay, but log shows EVT_SOCKET_EXCEPTION to " + loggedSocket + "; marking as invalid");
                    }
                    this.foundFault = true;
                    return;
                }
            }
            catch (IOException ioe2) {
                if (this.logger.level > 900) break block8;
                this.logger.logException("Replay: Error reading log", ioe2);
            }
        }
        this.fetchNextEvent();
    }

    public int writeSocket(int socketId, ByteBuffer src) throws IOException {
        if (!this.haveNextEvent) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: WriteSocket event after end of segment; marking as invalid");
            }
            this.foundFault = true;
            return 0;
        }
        if (this.next.getType() == 12) {
            this.fetchNextEvent();
            return -1;
        }
        if (this.next.getType() != 17) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: SOCKET_WRITE event during replay, but next event in log is #" + this.next.getType() + "; marking as invalid");
            }
            this.foundFault = true;
            return Integer.MIN_VALUE;
        }
        int loggedSocket = this.nextEvent.readInt();
        if (loggedSocket != socketId) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: SOCKET_WRITE on socket " + socketId + " during replay, but log shows SOCKET_WRITE to " + loggedSocket + "; marking as invalid");
            }
            this.foundFault = true;
            return 0;
        }
        int ret = this.nextEvent.bytesRemaining();
        if (src.remaining() < ret) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: SOCKET_WRITE writing a maximum of " + src.remaining() + " on socket " + socketId + " during replay, but log shows SOCKET_WRITE writing " + ret + " bytes; marking as invalid");
            }
            this.foundFault = true;
            return 0;
        }
        byte[] loggedMsg = new byte[ret];
        byte[] sentMsg = new byte[ret];
        this.nextEvent.read(loggedMsg);
        src.get(sentMsg);
        if (!Arrays.equals(loggedMsg, sentMsg)) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: Message wrote during replay differs from message in the log");
            }
            this.foundFault = true;
            return 0;
        }
        this.fetchNextEvent();
        return ret;
    }

    public void close(int socketId) {
        int loggedSocket;
        if (!this.haveNextEvent) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay(" + this.nextEventIndex + "): SOCKET_CLOSE event after end of segment; marking as invalid");
            }
            this.foundFault = true;
            return;
        }
        if (this.next.getType() != 11) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay(" + this.nextEventIndex + "): SOCKET_CLOSE event during replay, but next event in log is #" + this.next.getType() + "; marking as invalid");
            }
            this.foundFault = true;
            return;
        }
        try {
            loggedSocket = this.nextEvent.readInt();
        }
        catch (IOException ioe) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: Error deserializing event " + this.next);
            }
            this.foundFault = true;
            return;
        }
        if (loggedSocket != socketId) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: SOCKET_CLOSE on socket " + socketId + " during replay, but log shows SOCKET_CLOSE to " + loggedSocket + "; marking as invalid");
            }
            this.foundFault = true;
            return;
        }
        this.fetchNextEvent();
    }

    public void shutdownOutput(int socketId) {
        int loggedSocket;
        if (!this.haveNextEvent) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: EVT_SOCKET_SHUTDOWN_OUTPUT event after end of segment; marking as invalid");
            }
            this.foundFault = true;
            return;
        }
        if (this.next.getType() != 20) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: EVT_SOCKET_SHUTDOWN_OUTPUT event during replay, but next event in log is #" + this.next.getType() + "; marking as invalid");
            }
            this.foundFault = true;
            return;
        }
        try {
            loggedSocket = this.nextEvent.readInt();
        }
        catch (IOException ioe) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: Error deserializing event " + this.next);
            }
            this.foundFault = true;
            return;
        }
        if (loggedSocket != socketId) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: EVT_SOCKET_SHUTDOWN_OUTPUT on socket " + socketId + " during replay, but log shows EVT_SOCKET_SHUTDOWN_OUTPUT to " + loggedSocket + "; marking as invalid");
            }
            this.foundFault = true;
            return;
        }
        this.fetchNextEvent();
    }

    public void registerEvent(EventCallback callback, short ... eventType) {
        for (short s : eventType) {
            this.registerEvent(callback, s);
        }
    }

    public void registerEvent(EventCallback callback, short eventType) {
        if (this.eventCallback.containsKey(eventType) && callback != this.eventCallback.get(eventType)) {
            throw new IllegalStateException("Event #" + eventType + " registered twice");
        }
        this.eventCallback.put(eventType, callback);
    }

    public boolean makeProgress() {
        if (this.logger.level <= 500) {
            this.logger.log("makeProgress()");
        }
        if (this.foundFault || !this.haveNextEvent) {
            return false;
        }
        if (!this.initialized && this.next.getType() != 4 && this.next.getType() != 5) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: No INIT or CHECKPOINT found at the beginning of the log; marking as invalid " + this.next);
            }
            this.foundFault = true;
            return false;
        }
        if (!this.haveNextEvent) {
            return false;
        }
        if (this.logger.level <= 500) {
            this.logger.log("Replaying event #" + this.nextEventIndex + " (type " + this.next.getType() + ", seq=" + this.next.getSeq() + ")");
        }
        if (this.nextEventIsHashed && this.next.getType() != 4 && this.next.getType() != 5) {
            if (this.logger.level <= 900) {
                this.logger.log("Replay: Trying to replay hashed event");
            }
            this.foundFault = true;
            return false;
        }
        try {
            switch (this.next.getType()) {
                case 0: {
                    if (this.logger.level <= 900) {
                        this.logger.logException("Replay: Encountered EVT_SEND evt #" + this.nextEventIndex + "; marking as invalid", new Exception("Stack Trace"));
                    }
                    this.foundFault = true;
                    return false;
                }
                case 16: {
                    if (this.logger.level <= 900) {
                        this.logger.logException("Replay: Encountered EVT_SOCKET_READ evt #" + this.nextEventIndex + "; marking as invalid", new Exception("Stack Trace"));
                    }
                    this.foundFault = true;
                    return false;
                }
                case 11: {
                    if (this.logger.level <= 900) {
                        this.logger.logException("Replay: Encountered EVT_SOCKET_CLOSE evt #" + this.nextEventIndex + "; marking as invalid", new Exception("Stack Trace"));
                    }
                    this.foundFault = true;
                    return false;
                }
                case 20: {
                    if (this.logger.level <= 900) {
                        this.logger.logException("Replay: Encountered EVT_SOCKET_SHUTDOWN_OUTPUT evt #" + this.nextEventIndex + "; marking as invalid", new Exception("Stack Trace"));
                    }
                    this.foundFault = true;
                    return false;
                }
                case 1: {
                    Identifier sender = this.serializer.deserialize(this.nextEvent);
                    long senderSeq = 0L;
                    if (this.useSenderSeq) {
                        senderSeq = this.nextEvent.readLong();
                    }
                    boolean hashed = false;
                    if (this.useLogHashFlag) {
                        hashed = this.nextEvent.readBoolean();
                    }
                    int msgLen = this.nextEvent.bytesRemaining();
                    int relevantLen = hashed ? msgLen - this.hashSizeBytes : msgLen;
                    byte[] msgBytes = new byte[msgLen];
                    this.nextEvent.read(msgBytes);
                    ByteBuffer msgBuf = ByteBuffer.wrap(msgBytes);
                    if (this.useSendSign) {
                        this.fetchNextEvent();
                        if (!this.haveNextEvent || this.next.getType() != 2 || this.next.getSizeInFile() != this.hashSizeBytes + this.signatureSizeBytes) {
                            if (this.logger.level <= 900) {
                                this.logger.log("Replay: RECV event not followed by SIGN; marking as invalid");
                            }
                            this.foundFault = true;
                            return false;
                        }
                    }
                    this.fetchNextEvent();
                    this.receive(sender, msgBuf);
                    break;
                }
                case 2: {
                    if (this.logger.level <= 900) {
                        this.logger.log("Replay: Spurious SIGN event; marking as invalid");
                    }
                    this.foundFault = true;
                    return false;
                }
                case 3: {
                    this.fetchNextEvent();
                    break;
                }
                case 6: {
                    this.fetchNextEvent();
                    break;
                }
                case 4: 
                case 5: {
                    this.initialized = true;
                    this.fetchNextEvent();
                    break;
                }
                case 9: {
                    int socketId = this.nextEvent.readInt();
                    Identifier opener = this.serializer.deserialize(this.nextEvent);
                    this.fetchNextEvent();
                    this.incomingSocket(opener, socketId);
                    break;
                }
                case 18: {
                    int socketId = this.nextEvent.readInt();
                    this.fetchNextEvent();
                    this.socketOpened(socketId);
                    break;
                }
                case 13: {
                    int socketId = this.nextEvent.readInt();
                    this.fetchNextEvent();
                    this.socketIO(socketId, true, false);
                    break;
                }
                case 14: {
                    int socketId = this.nextEvent.readInt();
                    this.fetchNextEvent();
                    this.socketIO(socketId, false, true);
                    break;
                }
                case 15: {
                    int socketId = this.nextEvent.readInt();
                    this.fetchNextEvent();
                    this.socketIO(socketId, true, true);
                    break;
                }
                case 19: {
                    int socketId = this.nextEvent.readInt();
                    IOException ex = this.deserializeException(this.nextEvent);
                    this.logger.log("deserializeException(" + ex + ")");
                    this.fetchNextEvent();
                    this.socketException(socketId, ex);
                    break;
                }
                default: {
                    if (!this.eventCallback.containsKey(this.next.getType())) {
                        if (this.logger.level <= 900) {
                            this.logger.log("Replay(" + this.nextEventIndex + "): Unregistered event #" + this.next.getType() + "; marking as invalid");
                        }
                        this.foundFault = true;
                        return false;
                    }
                    IndexEntry temp = this.next;
                    InputBuffer tempEvent = this.nextEvent;
                    this.fetchNextEvent();
                    this.eventCallback.get(temp.getType()).replayEvent(temp.getType(), tempEvent);
                    break;
                }
            }
        }
        catch (IOException ioe) {
            if (this.logger.level <= 900) {
                this.logger.logException("Exception handling event #" + this.nextEventIndex + " " + this.next, ioe);
            }
            this.foundFault = true;
            return false;
        }
        return true;
    }

    public long getNextEventTime() {
        return this.next.getSeq() / 1000000L;
    }

    public boolean isSuccess() {
        return this.initialized && this.verifiedOK() && this.next == null;
    }

    protected IOException deserializeException(InputBuffer nextEvent) throws IOException {
        short exType = nextEvent.readShort();
        switch (exType) {
            case 1: {
                return new IOException(nextEvent.readUTF());
            }
            case 2: {
                return new ClosedChannelException(nextEvent.readUTF());
            }
            case 0: {
                Class<?> c;
                String className = nextEvent.readUTF();
                String message = nextEvent.readUTF();
                try {
                    c = Class.forName(className);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RuntimeException("Couldn't find class" + className + " " + message);
                }
                Class[] parameterTypes = new Class[]{String.class};
                try {
                    Constructor<?> ctor = c.getConstructor(parameterTypes);
                    IOException ioe = (IOException)ctor.newInstance(message);
                    return ioe;
                }
                catch (Exception e) {
                    try {
                        Constructor<?> ctor = c.getConstructor(new Class[0]);
                        IOException ioe = (IOException)ctor.newInstance(message);
                        return ioe;
                    }
                    catch (Exception e2) {
                        throw new RuntimeException("Couldn't find constructor for" + className + " " + message);
                    }
                }
            }
        }
        throw new RuntimeException("Unknown EX_TYPE:" + exType);
    }
}

