/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.filetransfer;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.mpisws.p2p.filetransfer.BBReceipt;
import org.mpisws.p2p.filetransfer.FileAllocationStrategy;
import org.mpisws.p2p.filetransfer.FileReceipt;
import org.mpisws.p2p.filetransfer.FileTransfer;
import org.mpisws.p2p.filetransfer.FileTransferCallback;
import org.mpisws.p2p.filetransfer.FileTransferListener;
import org.mpisws.p2p.filetransfer.OperationCancelledException;
import org.mpisws.p2p.filetransfer.Receipt;
import org.mpisws.p2p.filetransfer.TempFileAllocationStrategy;
import org.mpisws.p2p.filetransfer.TransferFailedException;
import org.mpisws.p2p.transport.ClosedChannelException;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.processing.Processor;
import rice.environment.processing.WorkRequest;
import rice.p2p.commonapi.appsocket.AppSocket;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;
import rice.p2p.util.MathUtils;
import rice.p2p.util.SortedLinkedList;
import rice.selector.SelectorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTransferImpl
implements FileTransfer,
AppSocketReceiver {
    public static final byte MSG_FILE_HEADER = 1;
    public static final byte MSG_BB_HEADER = 2;
    public static final byte MSG_CHUNK = 3;
    public static final byte MSG_CANCEL = 4;
    public static final byte MSG_CANCEL_REQUEST = 5;
    protected FileAllocationStrategy fileAllocater;
    protected AppSocket socket;
    protected FileTransferCallback callback;
    int MAX_QUEUE_SIZE = 1024;
    protected int CHUNK_SIZE = 8192;
    protected int FILE_CACHE = 10;
    ByteBuffer byteBuffer;
    protected SelectorManager selectorManager;
    protected Logger logger;
    protected Processor processor;
    protected Environment environment;
    public static final byte MAX_PRIORITY = -15;
    public static final byte HIGH_PRIORITY = -10;
    public static final byte MEDIUM_HIGH_PRIORITY = -5;
    public static final byte MEDIUM_PRIORITY = 0;
    public static final byte MEDIUM_LOW_PRIORITY = 5;
    public static final byte LOW_PRIORITY = 10;
    public static final byte LOWEST_PRIORITY = 15;
    public static final byte DEFAULT_PRIORITY = 0;
    public static final byte CANCEL_PRIORITY = -20;
    boolean failed = false;
    public static final int MAX_FILE_CHUNKS_IN_MEMORY = 100;
    public int fileChunksInMemory = 0;
    int seq = Integer.MIN_VALUE;
    SortedLinkedList<MessageWrapper> queue;
    MessageWrapper messageThatIsBeingWritten = null;
    boolean registered = false;
    ArrayList<FileTransferListener> listeners = new ArrayList();
    Map<Integer, ReceiptImpl> outgoingData = new HashMap<Integer, ReceiptImpl>();
    final MsgTypeReader msgTypeReader = new MsgTypeReader();
    final BBHeaderReader bbHeaderReader = new BBHeaderReader();
    final FileHeaderReader fileHeaderReader = new FileHeaderReader();
    final FileNameReader fileNameReader = new FileNameReader();
    final ChunkReader chunkReader = new ChunkReader();
    Reader reader = this.msgTypeReader;
    Map<Integer, DataReader> incomingData = new HashMap<Integer, DataReader>();

    public FileTransferImpl(AppSocket socket, FileTransferCallback callback, FileAllocationStrategy fileAllocater, Environment env) {
        this.socket = socket;
        this.callback = callback;
        this.fileAllocater = fileAllocater;
        this.queue = new SortedLinkedList();
        this.selectorManager = env.getSelectorManager();
        this.logger = env.getLogManager().getLogger(FileTransferImpl.class, null);
        this.processor = env.getProcessor();
        this.environment = env;
        socket.register(true, false, -1, this);
    }

    public FileTransferImpl(AppSocket socket, FileTransferCallback callback, Environment env) {
        this(socket, callback, new TempFileAllocationStrategy(), env);
    }

    protected void socketClosed() {
        this.receiveException(this.socket, new ClosedChannelException("Underlieing socket was closed."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveException(AppSocket socket, Exception e) {
        SortedLinkedList<MessageWrapper> sortedLinkedList = this.queue;
        synchronized (sortedLinkedList) {
            if (this.failed) {
                return;
            }
        }
        if (this.callback != null) {
            this.callback.receiveException(e);
        }
        this.purge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purge() {
        ArrayList<MessageWrapper> dropMe;
        SortedLinkedList<MessageWrapper> sortedLinkedList = this.queue;
        synchronized (sortedLinkedList) {
            this.failed = true;
            dropMe = new ArrayList<MessageWrapper>(this.queue);
        }
        for (MessageWrapper messageWrapper : dropMe) {
            messageWrapper.drop();
        }
        for (DataReader dataReader : new ArrayList<DataReader>(this.incomingData.values())) {
            this.notifyListenersTransferFailed(dataReader, true);
        }
        for (ReceiptImpl receiptImpl : new ArrayList<ReceiptImpl>(this.outgoingData.values())) {
            receiptImpl.failed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(MessageWrapper ret) {
        SortedLinkedList<MessageWrapper> sortedLinkedList = this.queue;
        synchronized (sortedLinkedList) {
            if (this.failed) {
                return;
            }
            this.queue.add(ret);
            while (this.queue.size() > this.MAX_QUEUE_SIZE) {
                MessageWrapper w = (MessageWrapper)this.queue.removeLast();
                if (this.logger.level <= 700) {
                    this.logger.log("Dropping " + w + " because queue is full. MAX_QUEUE_SIZE:" + this.MAX_QUEUE_SIZE);
                }
                w.drop();
            }
        }
        if (this.selectorManager.isSelectorThread()) {
            this.scheduleToWriteIfNeeded();
        } else {
            this.selectorManager.invoke(new Runnable(){

                public void run() {
                    FileTransferImpl.this.scheduleToWriteIfNeeded();
                }
            });
        }
    }

    protected void scheduleToWriteIfNeeded() {
        if (!this.selectorManager.isSelectorThread()) {
            throw new IllegalStateException("Must be called on the selector");
        }
        if (!this.registered && this.haveMessageToSend()) {
            this.registered = true;
            if (this.logger.level <= 300) {
                this.logger.log(this + ".scheduleToWriteIfNeeded() registering to write");
            }
            this.socket.register(false, true, 300000, this);
        }
    }

    private MessageWrapper peek() {
        if (this.messageThatIsBeingWritten == null) {
            return (MessageWrapper)this.queue.peek();
        }
        return this.messageThatIsBeingWritten;
    }

    private MessageWrapper poll() {
        if (this.messageThatIsBeingWritten == null) {
            this.messageThatIsBeingWritten = (MessageWrapper)this.queue.poll();
            if (this.logger.level <= 300) {
                this.logger.log(this + ".poll() set messageThatIsBeingWritten = " + this.messageThatIsBeingWritten);
            }
        }
        if (this.queue.size() >= this.MAX_QUEUE_SIZE - 1 && this.logger.level <= 800) {
            this.logger.log(this + "polling from full queue (" + this.queue.size() + ") (this is a good thing) " + this.messageThatIsBeingWritten);
        }
        return this.messageThatIsBeingWritten;
    }

    private boolean haveMessageToSend() {
        return this.messageThatIsBeingWritten != null || !this.queue.isEmpty();
    }

    protected boolean complete(MessageWrapper wrapper) {
        if (this.logger.level <= 300) {
            this.logger.log(this + ".complete(" + wrapper + ")");
        }
        if (wrapper != this.messageThatIsBeingWritten) {
            throw new IllegalArgumentException("Wrapper:" + wrapper + " messageThatIsBeingWritten:" + this.messageThatIsBeingWritten);
        }
        this.messageThatIsBeingWritten = null;
        wrapper.complete();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(FileTransferListener listener) {
        ArrayList<FileTransferListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(FileTransferListener listener) {
        ArrayList<FileTransferListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<FileTransferListener> getListeners() {
        ArrayList<FileTransferListener> arrayList = this.listeners;
        synchronized (arrayList) {
            return new ArrayList<FileTransferListener>(this.listeners);
        }
    }

    protected void notifyListenersSendMsgProgress(BBReceipt receipt, int bytesSent, int bytesTotal) {
        if (this.logger.level <= 500) {
            this.logger.log("notifyListenersSendMsgProgress(" + receipt + "," + bytesSent + "," + bytesTotal + ")");
        }
        for (FileTransferListener l : this.getListeners()) {
            l.msgTransferred(receipt, bytesSent, bytesTotal, false);
        }
    }

    protected void notifyListenersReceiveMsgProgress(BBReceipt receipt, int bytesReceived, int bytesTotal) {
        if (this.logger.level <= 500) {
            this.logger.log("notifyListenersReceiveMsgProgress(" + receipt + "," + bytesReceived + "," + bytesTotal + ")");
        }
        for (FileTransferListener l : this.getListeners()) {
            l.msgTransferred(receipt, bytesReceived, bytesTotal, true);
        }
    }

    protected void notifyListenersSendFileProgress(FileReceipt receipt, long bytesSent, long bytesTotal) {
        if (this.logger.level <= 500) {
            this.logger.log("notifyListenersSendFileProgress(" + receipt + "," + bytesSent + "," + bytesTotal + ")");
        }
        for (FileTransferListener l : this.getListeners()) {
            l.fileTransferred(receipt, bytesSent, bytesTotal, false);
        }
    }

    protected void notifyListenersReceiveFileProgress(FileReceipt receipt, long bytesReceived, long bytesTotal) {
        if (this.logger.level <= 500) {
            this.logger.log("notifyListenersReceiveFileProgress(" + receipt + "," + bytesReceived + "," + bytesTotal + ")");
        }
        for (FileTransferListener l : this.getListeners()) {
            l.fileTransferred(receipt, bytesReceived, bytesTotal, true);
        }
    }

    protected void notifyListenersSenderCancelled(DataReader receipt) {
        if (this.logger.level <= 500) {
            this.logger.log("notifyListenersSenderCancelled(" + receipt + ")");
        }
        for (FileTransferListener l : this.getListeners()) {
            l.transferCancelled(receipt, true);
        }
    }

    protected void notifyListenersReceiverCancelled(Receipt receipt) {
        if (this.logger.level <= 500) {
            this.logger.log("notifyListenersReceiverCancelled(" + receipt + ")");
        }
        for (FileTransferListener l : this.getListeners()) {
            l.transferCancelled(receipt, false);
        }
    }

    protected void notifyListenersTransferFailed(Receipt receipt, boolean incoming) {
        if (this.logger.level <= 500) {
            this.logger.log("notifyListenersTransferFailed(" + receipt + ")");
        }
        for (FileTransferListener l : this.getListeners()) {
            l.transferFailed(receipt, incoming);
        }
    }

    @Override
    public FileReceipt sendFile(File f, ByteBuffer metadata, byte priority, Continuation<FileReceipt, Exception> c) throws IOException {
        return this.sendFile(f, metadata, priority, 0L, f.length(), c);
    }

    @Override
    public FileReceipt sendFile(File f, ByteBuffer metadataBB, byte priority, long offset, long length, Continuation<FileReceipt, Exception> c) throws IOException {
        if (f == null || !f.exists() || f.isDirectory()) {
            throw new IllegalArgumentException("File f must be non-null, exist, and must not be a directory. " + f);
        }
        byte[] metadata = new byte[metadataBB.remaining()];
        metadataBB.get(metadata);
        FileReceiptImpl ret = new FileReceiptImpl(f, metadata, priority, offset, length, this.getUid(), c);
        return ret;
    }

    @Override
    public BBReceipt sendMsg(ByteBuffer bb, byte priority, Continuation<BBReceipt, Exception> c) {
        if (bb == null) {
            throw new IllegalArgumentException("ByteBuffer bb must be non-null");
        }
        BBReceiptImpl ret = new BBReceiptImpl(bb, priority, this.getUid(), c);
        return ret;
    }

    protected synchronized int getUid() {
        return this.seq++;
    }

    @Override
    public void receiveSelectResult(AppSocket socket, boolean canRead, boolean canWrite) {
        if (canWrite) {
            try {
                this.registered = false;
                if (this.logger.level <= 300) {
                    this.logger.log("receivedSelectResult(" + socket + "," + canRead + "," + canWrite);
                }
                MessageWrapper current = this.poll();
                while (current != null && current.receiveSelectResult(socket)) {
                    current = this.poll();
                }
                this.scheduleToWriteIfNeeded();
            }
            catch (IOException ioe) {
                if (this.logger.level <= 300) {
                    this.logger.logException(this + ".rsr(" + socket + ")", ioe);
                }
                this.receiveException(socket, ioe);
                return;
            }
        }
        if (canRead) {
            try {
                while (this.reader.read(socket)) {
                }
                this.registerToReadIfPossible();
            }
            catch (IOException ioe) {
                this.receiveException(socket, ioe);
            }
        }
    }

    protected void incrementFileChunksInMemory() {
        if (!this.environment.getSelectorManager().isSelectorThread()) {
            throw new IllegalStateException("Must be called on selector thread to maintain sync.");
        }
        ++this.fileChunksInMemory;
    }

    protected void decrementFileChunksInMemory() {
        if (!this.environment.getSelectorManager().isSelectorThread()) {
            throw new IllegalStateException("Must be called on selector thread to maintain sync.");
        }
        --this.fileChunksInMemory;
        this.registerToReadIfPossible();
    }

    public void registerToReadIfPossible() {
        if (!this.environment.getSelectorManager().isSelectorThread()) {
            throw new IllegalStateException("Must be called on selector thread to maintain sync.");
        }
        if (this.fileChunksInMemory < 100) {
            this.socket.register(true, false, -1, this);
        }
    }

    protected void receiverCancelled(int uid) {
        ReceiptImpl writer = this.outgoingData.remove(uid);
        if (writer != null) {
            writer.cancel();
            writer.notifyReceiverCancelled();
            this.notifyListenersReceiverCancelled(writer);
        } else if (this.logger.level <= 900) {
            this.logger.log("receiverCanclled(" + uid + ") no record of the uid.");
        }
    }

    protected void senderCancelled(int uid) {
        DataReader reader = this.incomingData.remove(uid);
        if (reader != null) {
            reader.cancelled(reader);
        } else if (this.logger.level <= 900) {
            this.logger.log("senderCanclled(" + uid + ") no record of the uid.");
        }
    }

    public void addIncomingMessage(int uid, int size) {
        if (this.incomingData.containsKey(uid)) {
            throw new IllegalArgumentException("DataReader with uid " + uid + " already exists! " + this.incomingData.get(uid) + " " + size);
        }
        BBDataReader bbdr = new BBDataReader(uid, size);
        this.incomingData.put(uid, bbdr);
        this.notifyListenersReceiveMsgProgress(bbdr, 0, size);
    }

    public void addIncomingFile(int uid, byte[] metadata, long offset, long length) throws IOException {
        File f = this.fileAllocater.getFile(ByteBuffer.wrap(metadata), offset, length);
        if (this.incomingData.containsKey(uid)) {
            throw new IllegalArgumentException("DataReader with uid " + uid + " already exists! " + this.incomingData.get(uid) + " " + metadata.length);
        }
        FileDataReader fdr = new FileDataReader(uid, metadata, f, offset, length);
        this.incomingData.put(uid, fdr);
        this.notifyListenersReceiveFileProgress(fdr, 0L, length);
    }

    @Override
    public void receiveSocket(AppSocket socket) {
        throw new RuntimeException("Not Implemented, shouldn't be called.");
    }

    protected boolean requestCancel(int uid) {
        this.enqueue(new SimpleMessageWrapper(5, uid));
        return false;
    }

    protected boolean sendCancel(int uid) {
        this.enqueue(new SimpleMessageWrapper(4, uid));
        return false;
    }

    class SimpleMessageWrapper
    implements MessageWrapper {
        ByteBuffer msg;
        int uid;
        byte msgType;

        public SimpleMessageWrapper(byte msgType, int uid) {
            this.uid = uid;
            this.msgType = msgType;
            this.msg = ByteBuffer.allocate(5);
            this.msg.put(msgType);
            this.msg.put(MathUtils.intToByteArray(uid));
            this.msg.clear();
        }

        public String toString() {
            if (this.msgType == 4) {
                return "Cancel msg <" + this.uid + ">";
            }
            if (this.msgType == 5) {
                return "Cancel request <" + this.uid + ">";
            }
            return "Unknown message";
        }

        public void complete() {
        }

        public void drop() {
        }

        public byte getPriority() {
            return -20;
        }

        public long getSeq() {
            return Integer.MIN_VALUE;
        }

        public int getUid() {
            return this.uid;
        }

        public int compareTo(MessageWrapper that) {
            if (this.getPriority() == that.getPriority()) {
                if (this.uid == that.getUid()) {
                    return (int)(this.getSeq() - that.getSeq());
                }
                return this.uid - that.getUid();
            }
            return this.getPriority() - that.getPriority();
        }

        public boolean receiveSelectResult(AppSocket socket) throws IOException {
            long bytesWritten;
            if (FileTransferImpl.this.logger.level <= 300) {
                FileTransferImpl.this.logger.log(this + ".receiveSelectResult(" + socket + ")");
            }
            if ((bytesWritten = socket.write(this.msg)) == -1L) {
                FileTransferImpl.this.socketClosed();
                return false;
            }
            if (this.msg.hasRemaining()) {
                if (FileTransferImpl.this.logger.level <= 300) {
                    FileTransferImpl.this.logger.log(this + ".rsr(" + socket + ") has remaining");
                }
                return false;
            }
            return FileTransferImpl.this.complete(this);
        }
    }

    class FileDataReader
    implements DataReader,
    FileReceipt {
        int uid;
        byte[] bytes;
        ByteBuffer curReader;
        RandomAccessFile file;
        File f;
        byte[] metadata;
        long offset;
        long length;
        long ptr;
        boolean requestedCancel = false;
        boolean cancelled = false;
        Exception exception = null;

        public FileDataReader(int uid, byte[] metadata, File f, long offset, long length) throws IOException {
            this.uid = uid;
            this.f = f;
            this.ptr = offset;
            this.offset = offset;
            this.length = length;
            this.file = new RandomAccessFile(f, "rw");
            this.metadata = metadata;
            this.file.seek(offset);
            this.bytes = new byte[FileTransferImpl.this.CHUNK_SIZE];
            this.curReader = ByteBuffer.wrap(this.bytes);
        }

        public String toString() {
            return "Incoming file<" + this.uid + "> " + this.metadata.length + " off:" + this.offset + " length:" + this.length + " " + this.f;
        }

        public boolean read(AppSocket socket, int numToRead) throws IOException {
            if (this.curReader.position() != 0) {
                throw new IllegalStateException("curReader has " + this.curReader.remaining() + " bytes remaining. " + numToRead);
            }
            this.curReader.limit(numToRead);
            FileTransferImpl.this.reader = this;
            return this.read(socket);
        }

        public boolean read(AppSocket socket) throws IOException {
            long ret = socket.read(this.curReader);
            if (ret < 0L) {
                FileTransferImpl.this.socketClosed();
                return false;
            }
            if (this.curReader.hasRemaining()) {
                return false;
            }
            this.completeChunk();
            return true;
        }

        public void completeChunk() {
            this.curReader.flip();
            final byte[] writeMe = new byte[this.curReader.remaining()];
            this.curReader.get(writeMe);
            this.curReader.clear();
            FileTransferImpl.this.incrementFileChunksInMemory();
            WorkRequest<Long> wr = new WorkRequest<Long>((Continuation)new Continuation<Long, Exception>(){

                @Override
                public void receiveResult(Long myPtrL) {
                    FileTransferImpl.this.decrementFileChunksInMemory();
                    if (FileDataReader.this.cancelled) {
                        return;
                    }
                    long myPtr = myPtrL;
                    FileTransferImpl.this.notifyListenersReceiveFileProgress(FileDataReader.this, myPtr - FileDataReader.this.offset, FileDataReader.this.length);
                    if (myPtr == FileDataReader.this.offset + FileDataReader.this.length) {
                        FileDataReader.this.complete();
                    }
                }

                @Override
                public void receiveException(Exception exception) {
                    if (FileTransferImpl.this.logger.level <= 900) {
                        FileTransferImpl.this.logger.logException("Error writing file " + FileDataReader.this.f + " " + FileDataReader.this.metadata.length, exception);
                    }
                    FileDataReader.this.cancel();
                    FileTransferImpl.this.decrementFileChunksInMemory();
                }
            }, FileTransferImpl.this.environment.getSelectorManager()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Long doWork() throws Exception {
                    if (FileDataReader.this.cancelled) {
                        return -1L;
                    }
                    FileDataReader.this.file.write(writeMe);
                    FileDataReader fileDataReader = FileDataReader.this;
                    synchronized (fileDataReader) {
                        FileDataReader.this.ptr += (long)writeMe.length;
                    }
                    return FileDataReader.this.ptr;
                }
            };
            FileTransferImpl.this.processor.processBlockingIO(wr);
            FileTransferImpl.this.reader = FileTransferImpl.this.msgTypeReader;
        }

        public void complete() {
            block2: {
                FileTransferImpl.this.incomingData.remove(this.uid);
                try {
                    this.file.close();
                }
                catch (IOException ioe) {
                    if (FileTransferImpl.this.logger.level > 900) break block2;
                    FileTransferImpl.this.logger.logException("Error closing file " + this.file, ioe);
                }
            }
            FileTransferImpl.this.callback.fileReceived(this.getFile(), this.getMetadata());
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public byte getPriority() {
            throw new RuntimeException("Unknown priority.  Don't call this on the receiving side.");
        }

        public long getSize() {
            return this.bytes.length;
        }

        public int getUID() {
            return this.uid;
        }

        public boolean cancel() {
            if (this.requestedCancel) {
                return false;
            }
            this.requestedCancel = true;
            return FileTransferImpl.this.requestCancel(this.uid);
        }

        public File getFile() {
            return this.f;
        }

        public long getLength() {
            return this.length;
        }

        public ByteBuffer getMetadata() {
            return ByteBuffer.wrap(this.metadata);
        }

        public long getOffset() {
            return this.offset;
        }

        public void cancelled(final DataReader reader) {
            this.cancelled = true;
            WorkRequest<RandomAccessFile> wr = new WorkRequest<RandomAccessFile>((Continuation)new Continuation<RandomAccessFile, Exception>(){

                @Override
                public void receiveResult(RandomAccessFile result) {
                    if (FileTransferImpl.this.logger.level <= 800) {
                        FileTransferImpl.this.logger.log("File Cancelled<" + FileDataReader.this.uid + "> " + FileDataReader.this.f + "," + FileDataReader.this.offset + "," + (FileDataReader.this.ptr - FileDataReader.this.offset) + "," + FileDataReader.this.length);
                    }
                    FileTransferImpl.this.fileAllocater.fileCancelled(ByteBuffer.wrap(FileDataReader.this.metadata), FileDataReader.this.f, FileDataReader.this.offset, FileDataReader.this.ptr - FileDataReader.this.offset, FileDataReader.this.length, FileDataReader.this.exception);
                    FileTransferImpl.this.notifyListenersSenderCancelled(reader);
                }

                @Override
                public void receiveException(Exception exception) {
                    if (FileTransferImpl.this.logger.level <= 900) {
                        FileTransferImpl.this.logger.logException("Error closing file " + FileDataReader.this.file, exception);
                    }
                }
            }, FileTransferImpl.this.environment.getSelectorManager()){

                @Override
                public RandomAccessFile doWork() throws Exception {
                    FileDataReader.this.file.close();
                    return FileDataReader.this.file;
                }
            };
            FileTransferImpl.this.processor.processBlockingIO(wr);
        }
    }

    class BBDataReader
    implements DataReader,
    BBReceipt {
        int uid;
        byte[] bytes;
        ByteBuffer curReader;
        boolean requestedCancel = false;

        public BBDataReader(int uid, int size) {
            this.uid = uid;
            this.bytes = new byte[size];
            this.curReader = ByteBuffer.wrap(this.bytes);
            this.curReader.limit(0);
        }

        public String toString() {
            return "Incoming msg<" + this.uid + "> of length" + this.bytes.length;
        }

        public boolean read(AppSocket socket, int numToRead) throws IOException {
            if (this.curReader.hasRemaining()) {
                throw new IllegalStateException("curReader has " + this.curReader.remaining() + " bytes remaining. " + numToRead);
            }
            this.curReader.limit(this.curReader.position() + numToRead);
            FileTransferImpl.this.reader = this;
            return this.read(socket);
        }

        public boolean read(AppSocket socket) throws IOException {
            long ret = socket.read(this.curReader);
            if (ret < 0L) {
                FileTransferImpl.this.socketClosed();
                return false;
            }
            if (this.curReader.hasRemaining()) {
                return false;
            }
            this.completeChunk();
            return true;
        }

        public void completeChunk() {
            FileTransferImpl.this.notifyListenersReceiveMsgProgress(this, this.curReader.position(), this.bytes.length);
            if (this.curReader.position() == this.bytes.length) {
                this.complete();
            }
            FileTransferImpl.this.reader = FileTransferImpl.this.msgTypeReader;
        }

        public void complete() {
            FileTransferImpl.this.incomingData.remove(this.uid);
            FileTransferImpl.this.callback.messageReceived(ByteBuffer.wrap(this.getBytes()));
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public byte getPriority() {
            throw new RuntimeException("Unknown priority.  Don't call this on the receiving side.");
        }

        public long getSize() {
            return this.bytes.length;
        }

        public int getUID() {
            return this.uid;
        }

        public boolean cancel() {
            if (this.requestedCancel) {
                return false;
            }
            this.requestedCancel = true;
            return FileTransferImpl.this.requestCancel(this.uid);
        }

        public void cancelled(DataReader reader) {
            FileTransferImpl.this.notifyListenersSenderCancelled(reader);
        }
    }

    static interface DataReader
    extends Reader,
    Receipt {
        public boolean read(AppSocket var1, int var2) throws IOException;

        public void cancelled(DataReader var1);
    }

    class ChunkReader
    implements Reader {
        byte[] bytes = new byte[4];
        ByteBuffer buf = ByteBuffer.wrap(this.bytes);
        int uid;

        ChunkReader() {
        }

        public void setUID(int uid) {
            this.uid = uid;
        }

        public boolean read(AppSocket socket) throws IOException {
            long bytesRead = socket.read(this.buf);
            if (bytesRead < 0L) {
                FileTransferImpl.this.socketClosed();
                return false;
            }
            if (this.buf.hasRemaining()) {
                return false;
            }
            this.buf.clear();
            int size = MathUtils.byteArrayToInt(this.bytes);
            this.buf.clear();
            DataReader dataReader = FileTransferImpl.this.incomingData.get(this.uid);
            if (dataReader == null) {
                throw new IllegalStateException("No record of uid " + this.uid);
            }
            return dataReader.read(socket, size);
        }
    }

    class FileNameReader
    implements Reader {
        byte[] bytes = new byte[20];
        ByteBuffer buf = ByteBuffer.wrap(this.bytes);
        int uid;
        long offset;
        long length;

        FileNameReader() {
        }

        public void initialize(int uid, long offset, long length, int nameSize) {
            this.uid = uid;
            this.offset = offset;
            this.length = length;
            if (this.bytes.length < nameSize) {
                this.bytes = new byte[nameSize];
                this.buf = ByteBuffer.wrap(this.bytes);
            }
            this.buf.clear();
            this.buf.limit(nameSize);
        }

        public boolean read(AppSocket socket) throws IOException {
            long bytesRead = socket.read(this.buf);
            if (bytesRead < 0L) {
                FileTransferImpl.this.socketClosed();
                return false;
            }
            if (this.buf.hasRemaining()) {
                return false;
            }
            this.buf.flip();
            byte[] returnBytes = new byte[this.buf.remaining()];
            this.buf.get(returnBytes);
            this.buf.clear();
            FileTransferImpl.this.addIncomingFile(this.uid, returnBytes, this.offset, this.length);
            FileTransferImpl.this.reader = FileTransferImpl.this.msgTypeReader;
            return true;
        }
    }

    class FileHeaderReader
    implements Reader {
        byte[] bytes = new byte[20];
        ByteBuffer buf = ByteBuffer.wrap(this.bytes);
        int uid;

        FileHeaderReader() {
        }

        public void setUID(int uid) {
            this.uid = uid;
        }

        public boolean read(AppSocket socket) throws IOException {
            long bytesRead = socket.read(this.buf);
            if (bytesRead < 0L) {
                FileTransferImpl.this.socketClosed();
                return false;
            }
            if (this.buf.hasRemaining()) {
                return false;
            }
            this.buf.clear();
            long offset = MathUtils.byteArrayToLong(this.bytes, 0);
            long length = MathUtils.byteArrayToLong(this.bytes, 8);
            int nameSize = MathUtils.byteArrayToInt(this.bytes, 16);
            this.buf.clear();
            FileTransferImpl.this.fileNameReader.initialize(this.uid, offset, length, nameSize);
            FileTransferImpl.this.reader = FileTransferImpl.this.fileNameReader;
            return true;
        }
    }

    class BBHeaderReader
    implements Reader {
        byte[] bytes = new byte[4];
        ByteBuffer buf = ByteBuffer.wrap(this.bytes);
        int uid;

        BBHeaderReader() {
        }

        public void setUID(int uid) {
            this.uid = uid;
        }

        public boolean read(AppSocket socket) throws IOException {
            long bytesRead = socket.read(this.buf);
            if (bytesRead < 0L) {
                FileTransferImpl.this.socketClosed();
                return false;
            }
            if (this.buf.hasRemaining()) {
                return false;
            }
            this.buf.clear();
            int size = MathUtils.byteArrayToInt(this.bytes);
            this.buf.clear();
            FileTransferImpl.this.addIncomingMessage(this.uid, size);
            FileTransferImpl.this.reader = FileTransferImpl.this.msgTypeReader;
            return true;
        }
    }

    class MsgTypeReader
    implements Reader {
        byte[] bytes = new byte[5];
        ByteBuffer buf = ByteBuffer.wrap(this.bytes);

        MsgTypeReader() {
        }

        public boolean read(AppSocket socket) throws IOException {
            long bytesRead = socket.read(this.buf);
            if (bytesRead < 0L) {
                FileTransferImpl.this.socketClosed();
                return false;
            }
            if (this.buf.hasRemaining()) {
                return false;
            }
            this.buf.clear();
            byte msgType = this.bytes[0];
            int uid = MathUtils.byteArrayToInt(this.bytes, 1);
            this.buf.clear();
            switch (msgType) {
                case 2: {
                    FileTransferImpl.this.bbHeaderReader.setUID(uid);
                    FileTransferImpl.this.reader = FileTransferImpl.this.bbHeaderReader;
                    break;
                }
                case 1: {
                    FileTransferImpl.this.fileHeaderReader.setUID(uid);
                    FileTransferImpl.this.reader = FileTransferImpl.this.fileHeaderReader;
                    break;
                }
                case 3: {
                    FileTransferImpl.this.chunkReader.setUID(uid);
                    FileTransferImpl.this.reader = FileTransferImpl.this.chunkReader;
                    break;
                }
                case 4: {
                    FileTransferImpl.this.senderCancelled(uid);
                    break;
                }
                case 5: {
                    FileTransferImpl.this.receiverCancelled(uid);
                }
            }
            return true;
        }
    }

    static interface Reader {
        public boolean read(AppSocket var1) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MessageWrapperImpl
    implements MessageWrapper {
        boolean started = false;
        ReceiptImpl receipt;
        LinkedList<ByteBuffer> message;
        long seq;

        public MessageWrapperImpl(ReceiptImpl receipt, long seq, LinkedList<ByteBuffer> message) {
            this.receipt = receipt;
            this.seq = seq;
            this.message = message;
        }

        public String toString() {
            return "Part " + this.seq + " of " + this.receipt;
        }

        @Override
        public void drop() {
            this.receipt.failed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel() {
            if (this.equals(FileTransferImpl.this.messageThatIsBeingWritten)) {
                return !this.started;
            }
            SortedLinkedList<MessageWrapper> sortedLinkedList = FileTransferImpl.this.queue;
            synchronized (sortedLinkedList) {
                return FileTransferImpl.this.queue.remove(this);
            }
        }

        public void clear(LinkedList<ByteBuffer> message, long seq) {
            this.started = false;
            this.message = message;
            this.seq = seq;
        }

        @Override
        public int compareTo(MessageWrapper that) {
            if (this.receipt.priority == that.getPriority()) {
                if (this.receipt.uid == that.getUid()) {
                    return (int)(this.seq - that.getSeq());
                }
                return this.receipt.uid - that.getUid();
            }
            return this.receipt.priority - that.getPriority();
        }

        @Override
        public boolean receiveSelectResult(AppSocket socket) throws IOException {
            if (FileTransferImpl.this.logger.level <= 300) {
                FileTransferImpl.this.logger.log(this + ".receiveSelectResult(" + socket + ")");
            }
            if (this.receipt.isCancelled() && !this.started) {
                if (FileTransferImpl.this.logger.level <= 300) {
                    FileTransferImpl.this.logger.log(this + ".rsr(" + socket + ") cancelled");
                }
                FileTransferImpl.this.messageThatIsBeingWritten = null;
                return true;
            }
            this.started = true;
            long bytesWritten = socket.write(this.message.getFirst());
            if (bytesWritten == -1L) {
                FileTransferImpl.this.socketClosed();
                return false;
            }
            if (this.message.getFirst().hasRemaining()) {
                if (FileTransferImpl.this.logger.level <= 300) {
                    FileTransferImpl.this.logger.log(this + ".rsr(" + socket + ") has remaining");
                }
                return false;
            }
            this.message.removeFirst();
            if (!this.message.isEmpty()) {
                return this.receiveSelectResult(socket);
            }
            return FileTransferImpl.this.complete(this);
        }

        @Override
        public void complete() {
            this.receipt.complete(this);
        }

        @Override
        public byte getPriority() {
            return this.receipt.getPriority();
        }

        @Override
        public long getSeq() {
            return this.seq;
        }

        @Override
        public int getUid() {
            return this.receipt.getUID();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface MessageWrapper
    extends Comparable<MessageWrapper> {
        public byte getPriority();

        public void complete();

        public void drop();

        public int getUid();

        public long getSeq();

        public boolean receiveSelectResult(AppSocket var1) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FileReceiptImpl
    extends ReceiptImpl
    implements FileReceipt {
        FileInputStream file;
        File f;
        byte[] metadata;
        Continuation<FileReceipt, Exception> deliverAckToMe;
        LinkedList<ByteBuffer> msgList;
        MessageWrapperImpl outstanding;
        int wrapperSeq;
        final ByteBuffer chunk;
        byte[] chunkBytes;
        long lastByte;
        long ptr;
        long length;
        long initialPosition;
        ByteBuffer header;

        public FileReceiptImpl(File f, byte[] metadata, byte priority, long offset, long length, int uid, Continuation<FileReceipt, Exception> c) throws IOException {
            super(priority, uid);
            this.wrapperSeq = Integer.MIN_VALUE;
            if (offset + length > f.length()) {
                throw new IllegalArgumentException("File is only " + f.length() + " but you are trying to send " + length + " bytes starting at " + offset);
            }
            this.f = f;
            this.metadata = metadata;
            try {
                this.file = new FileInputStream(f);
            }
            catch (IOException ioe) {
                this.failed();
                throw ioe;
            }
            catch (RuntimeException re) {
                this.failed();
                throw re;
            }
            catch (Throwable t) {
                this.failed();
                throw new RuntimeException(t);
            }
            this.file.skip(offset);
            this.lastByte = offset + length;
            this.deliverAckToMe = c;
            this.initialPosition = offset;
            this.ptr = offset;
            this.length = length;
            this.msgList = new LinkedList();
            long chunkSize = length;
            if (length > (long)FileTransferImpl.this.CHUNK_SIZE) {
                chunkSize = FileTransferImpl.this.CHUNK_SIZE;
            }
            this.chunkBytes = new byte[(int)chunkSize];
            this.chunk = ByteBuffer.wrap(this.chunkBytes);
            this.header = ByteBuffer.allocate(9);
            ByteBuffer hdr = ByteBuffer.allocate(25);
            hdr.put((byte)1);
            hdr.put(MathUtils.intToByteArray(uid));
            hdr.put(MathUtils.longToByteArray(offset));
            hdr.put(MathUtils.longToByteArray(length));
            hdr.put(MathUtils.intToByteArray(metadata.length));
            hdr.clear();
            this.msgList.add(hdr);
            this.msgList.add(ByteBuffer.wrap(metadata));
            this.outstanding = new MessageWrapperImpl(this, this.wrapperSeq++, this.msgList);
            FileTransferImpl.this.enqueue(this.outstanding);
        }

        @Override
        void failed() {
            if (this.deliverAckToMe != null) {
                this.deliverAckToMe.receiveException(new TransferFailedException(this));
            }
            super.failed();
        }

        public String toString() {
            return "Outgoing file<" + this.uid + "> " + this.metadata.length + " size:" + this.getSize() + " priority:" + this.priority + " " + this.f;
        }

        @Override
        void complete(MessageWrapper wrapper) {
            block9: {
                FileTransferImpl.this.notifyListenersSendFileProgress(this, this.ptr - this.initialPosition, this.length);
                if (this.cancelled) {
                    return;
                }
                if (this.ptr < this.lastByte) {
                    try {
                        long ret = this.file.read(this.chunkBytes);
                        if (ret < 0L) {
                            throw new EOFException("Unexpected EOF... cancelling " + this.uid + " " + this.f + ".");
                        }
                        this.ptr += ret;
                        this.chunk.clear();
                        this.chunk.limit((int)ret);
                        this.header.clear();
                        this.header.put((byte)3);
                        this.header.put(MathUtils.intToByteArray(this.uid));
                        this.header.put(MathUtils.intToByteArray(this.chunk.remaining()));
                        this.header.clear();
                        this.msgList.add(this.header);
                        this.msgList.add(this.chunk);
                        this.outstanding.clear(this.msgList, this.wrapperSeq++);
                        FileTransferImpl.this.enqueue(this.outstanding);
                        return;
                    }
                    catch (IOException ioe) {
                        if (this.deliverAckToMe != null) {
                            this.deliverAckToMe.receiveException(ioe);
                        }
                        FileTransferImpl.this.sendCancel(this.uid);
                        return;
                    }
                }
                try {
                    this.file.close();
                }
                catch (IOException ioe) {
                    if (FileTransferImpl.this.logger.level > 900) break block9;
                    FileTransferImpl.this.logger.logException("Error closing file <" + this.uid + "> " + this.file + " " + this.metadata.length, ioe);
                }
            }
            FileTransferImpl.this.outgoingData.remove(this.uid);
            if (this.deliverAckToMe != null) {
                this.deliverAckToMe.receiveResult(this);
            }
        }

        @Override
        public long getSize() {
            return this.length;
        }

        @Override
        public File getFile() {
            return this.f;
        }

        public long getLength() {
            return this.length;
        }

        @Override
        public ByteBuffer getMetadata() {
            return ByteBuffer.wrap(this.metadata);
        }

        @Override
        public long getOffset() {
            return this.initialPosition;
        }

        @Override
        public boolean cancel() {
            block2: {
                try {
                    this.file.close();
                }
                catch (IOException ioe) {
                    if (FileTransferImpl.this.logger.level > 900) break block2;
                    FileTransferImpl.this.logger.logException("Error closing file <" + this.uid + "> " + this.file, ioe);
                }
            }
            this.outstanding.cancel();
            return super.cancel();
        }

        @Override
        public void notifyReceiverCancelled() {
            if (this.deliverAckToMe != null) {
                this.deliverAckToMe.receiveException(new OperationCancelledException(this));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BBReceiptImpl
    extends ReceiptImpl
    implements BBReceipt {
        ByteBuffer msg;
        byte[] msgBytes;
        LinkedList<ByteBuffer> msgList;
        ByteBuffer header;
        MessageWrapperImpl outstanding;
        int wrapperSeq;
        final ByteBuffer chunkBuffer;
        int initialPosition;
        Continuation<BBReceipt, Exception> deliverAckToMe;

        public BBReceiptImpl(ByteBuffer bb, byte priority, int uid, Continuation<BBReceipt, Exception> c) {
            super(priority, uid);
            this.wrapperSeq = -2147483638;
            this.deliverAckToMe = c;
            this.msg = bb;
            this.initialPosition = this.msg.position();
            this.msgBytes = bb.array();
            this.msgList = new LinkedList();
            this.chunkBuffer = ByteBuffer.wrap(this.msgBytes);
            this.chunkBuffer.position(this.msg.position());
            this.chunkBuffer.limit(this.msg.limit());
            this.header = ByteBuffer.allocate(9);
            this.header.put((byte)2);
            this.header.put(MathUtils.intToByteArray(uid));
            this.header.put(MathUtils.intToByteArray(bb.remaining()));
            this.header.clear();
            this.msgList.add(this.header);
            this.outstanding = new MessageWrapperImpl(this, this.wrapperSeq++, this.msgList);
            FileTransferImpl.this.enqueue(this.outstanding);
        }

        public String toString() {
            return "Outgoing msg<" + this.uid + "> size:" + this.getSize() + " priority:" + this.priority + " msg:" + this.msg;
        }

        @Override
        void failed() {
            if (this.deliverAckToMe != null) {
                this.deliverAckToMe.receiveException(new TransferFailedException(this));
            }
            super.failed();
        }

        @Override
        void complete(MessageWrapper wrapper) {
            this.msg.position(this.chunkBuffer.position());
            FileTransferImpl.this.notifyListenersSendMsgProgress(this, this.msg.position() - this.initialPosition, this.msg.limit() - this.initialPosition);
            if (this.msg.hasRemaining()) {
                if (this.msg.remaining() > FileTransferImpl.this.CHUNK_SIZE) {
                    this.chunkBuffer.limit(this.msg.position() + FileTransferImpl.this.CHUNK_SIZE);
                } else {
                    this.chunkBuffer.limit(this.msg.limit());
                }
                this.header.clear();
                this.header.put((byte)3);
                this.header.put(MathUtils.intToByteArray(this.uid));
                this.header.put(MathUtils.intToByteArray(this.chunkBuffer.remaining()));
                this.header.clear();
                this.msgList.add(this.header);
                this.msgList.add(this.chunkBuffer);
                this.outstanding.clear(this.msgList, this.wrapperSeq++);
                FileTransferImpl.this.enqueue(this.outstanding);
                return;
            }
            FileTransferImpl.this.outgoingData.remove(this.uid);
            if (this.deliverAckToMe != null) {
                this.deliverAckToMe.receiveResult(this);
            }
            this.completed = true;
        }

        @Override
        public byte[] getBytes() {
            return this.msgBytes;
        }

        @Override
        public long getSize() {
            return this.msg.limit() - this.initialPosition;
        }

        @Override
        public boolean cancel() {
            this.outstanding.cancel();
            return super.cancel();
        }

        @Override
        public void notifyReceiverCancelled() {
            if (this.deliverAckToMe != null) {
                this.deliverAckToMe.receiveException(new OperationCancelledException(this));
            }
        }
    }

    abstract class ReceiptImpl
    implements Receipt {
        byte priority;
        int uid;
        boolean cancelled = false;
        boolean completed = false;

        public ReceiptImpl(byte priority, int uid) {
            this.priority = priority;
            this.uid = uid;
            FileTransferImpl.this.outgoingData.put(uid, this);
        }

        public byte getPriority() {
            return this.priority;
        }

        public int getUID() {
            return this.uid;
        }

        void failed() {
            FileTransferImpl.this.notifyListenersTransferFailed(this, false);
            this.cancelled = true;
            FileTransferImpl.this.outgoingData.remove(this.uid);
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        abstract void complete(MessageWrapper var1);

        public boolean cancel() {
            this.cancelled = true;
            FileTransferImpl.this.outgoingData.remove(this.uid);
            FileTransferImpl.this.sendCancel(this.uid);
            return !this.completed;
        }

        public abstract void notifyReceiverCancelled();
    }
}

