/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Security;
import java.util.Hashtable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class PKCS10CertRequestTest
implements Test {
    public String getName() {
        return "PKCS10CertRequest";
    }

    public TestResult perform() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
            keyPairGenerator.initialize(512);
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            Hashtable<DERObjectIdentifier, String> hashtable = new Hashtable<DERObjectIdentifier, String>();
            hashtable.put(X509Principal.C, "AU");
            hashtable.put(X509Principal.O, "The Legion of the Bouncy Castle");
            hashtable.put(X509Principal.L, "Melbourne");
            hashtable.put(X509Principal.ST, "Victoria");
            hashtable.put(X509Principal.EmailAddress, "feedback-crypto@bouncycastle.org");
            X509Name x509Name = new X509Name(hashtable);
            PKCS10CertificationRequest pKCS10CertificationRequest = new PKCS10CertificationRequest("SHA1withRSA", x509Name, keyPair.getPublic(), null, keyPair.getPrivate());
            byte[] byArray = pKCS10CertificationRequest.getEncoded();
            PKCS10CertificationRequest pKCS10CertificationRequest2 = new PKCS10CertificationRequest(byArray);
            if (!pKCS10CertificationRequest2.verify()) {
                return new SimpleTestResult(false, this.getName() + ": Failed verify check.");
            }
            if (!pKCS10CertificationRequest2.getPublicKey().equals(pKCS10CertificationRequest.getPublicKey())) {
                return new SimpleTestResult(false, this.getName() + ": Failed public key check.");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
        }
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        PKCS10CertRequestTest pKCS10CertRequestTest = new PKCS10CertRequestTest();
        TestResult testResult = pKCS10CertRequestTest.perform();
        System.out.println(testResult.toString());
    }
}

