/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.CertificateChoices;

public class CertificateSet
extends CMSObject {
    private ASN1Set certificateChoices;

    public CertificateSet(Vector vector) {
        this.setCertificateChoices(vector);
    }

    public CertificateSet(ASN1Set aSN1Set) {
        this.certificateChoices = aSN1Set;
    }

    public CertificateSet(CertificateSet certificateSet) {
        this.certificateChoices = certificateSet.certificateChoices;
    }

    public static CertificateSet getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return CertificateSet.getInstance(ASN1Set.getInstance(aSN1TaggedObject, bl));
    }

    public static CertificateSet getInstance(Object object) {
        if (object == null || object instanceof CertificateSet) {
            return (CertificateSet)object;
        }
        if (object instanceof ASN1Set) {
            return new CertificateSet((ASN1Set)object);
        }
        if (object instanceof Vector) {
            return new CertificateSet((Vector)object);
        }
        CertificateChoices certificateChoices = CertificateChoices.getInstance(object);
        Vector<CertificateChoices> vector = new Vector<CertificateChoices>();
        vector.addElement(certificateChoices);
        return new CertificateSet(vector);
    }

    public Vector getCertificateChoices() {
        int n = this.certificateChoices.getSize();
        Vector<CertificateChoices> vector = new Vector<CertificateChoices>();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(CertificateChoices.getInstance(this.certificateChoices.getObjectAt(n2)));
            ++n2;
        }
        return vector;
    }

    public DERObject getDERObject() {
        return this.certificateChoices;
    }

    private void setCertificateChoices(Vector vector) {
        int n = vector.size();
        this.certificateChoices = new DERConstructedSet();
        int n2 = 0;
        while (n2 < n) {
            this.certificateChoices.addObject(CertificateChoices.getInstance(vector.elementAt(n2)));
            ++n2;
        }
    }
}

