/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.lookup;

import java.util.HashMap;
import rice.Continuation;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.commonapi.RouteMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookupService
implements Application {
    private Endpoint endpoint;
    private int seqno = 42;
    private HashMap<Integer, Continuation<NodeHandleSet, Exception>> pending = new HashMap();
    private long timeout;
    private Logger logger;

    public LookupService(Node node, long timeout) {
        this.endpoint = node.buildEndpoint(this, null);
        this.endpoint.register();
        this.logger = this.endpoint.getEnvironment().getLogManager().getLogger(this.getClass(), null);
        if (timeout > 0L) {
            this.timeout = timeout;
        } else {
            this.timeout = this.endpoint.getEnvironment().getParameters().getLong("lookup_service.timeout");
            if (this.timeout <= 0L) {
                this.timeout = 30000L;
            }
        }
    }

    public LookupService(Node node) {
        this(node, -1L);
    }

    @Override
    public boolean forward(RouteMessage message) {
        return true;
    }

    @Override
    public void deliver(Id id, Message message) {
        if (message instanceof NodeLookupQuery) {
            NodeLookupQuery query = (NodeLookupQuery)message;
            if (this.logger.level <= 400) {
                this.logger.log("NodeLookup query received for " + id + " with sequence number " + query.seqno);
            }
            this.endpoint.route(null, new NodeLookupResponse(this.endpoint.replicaSet(id, query.numNodes), query.seqno), query.source);
        } else if (message instanceof NodeLookupResponse) {
            NodeLookupResponse response = (NodeLookupResponse)message;
            if (this.pending.containsKey(response.seqno)) {
                if (this.logger.level <= 400) {
                    this.logger.log("NodeLookup response received with sequence number " + response.seqno);
                }
                this.pending.remove(response.seqno).receiveResult(response.nodes);
            } else if (this.logger.level <= 800) {
                this.logger.log("NodeLookup received response for non-existent or expired lookup " + response.seqno);
            }
        } else if (message instanceof NodeLookupTimeout) {
            NodeLookupTimeout response = (NodeLookupTimeout)message;
            if (this.pending.containsKey(response.seqno)) {
                if (this.logger.level <= 500) {
                    this.logger.log("NodeLookup timed out with sequence number " + response.seqno);
                }
                this.pending.remove(response.seqno).receiveException(new NodeLookupTimeoutException());
            }
        } else if (this.logger.level <= 900) {
            this.logger.log("NodeLookup received unexpected message " + message);
        }
    }

    @Override
    public void update(NodeHandle handle, boolean joined) {
    }

    public void requestNodeHandles(Id id, int num, Continuation<NodeHandleSet, Exception> cont) {
        int seq = this.seqno++;
        this.pending.put(seq, cont);
        if (this.logger.level <= 400) {
            this.logger.log("NodeLookup being sent to id  " + id + " with sequence number " + seq);
        }
        this.endpoint.route(id, new NodeLookupQuery(this.endpoint.getLocalNodeHandle(), num, seq), null);
        this.endpoint.scheduleMessage(new NodeLookupTimeout(seq), this.timeout);
    }

    public void requestNodeHandle(Id id, final Continuation<NodeHandle, Exception> cont) {
        int seq = this.seqno++;
        this.pending.put(seq, new Continuation<NodeHandleSet, Exception>(){

            @Override
            public void receiveException(Exception exception) {
                cont.receiveException(exception);
            }

            @Override
            public void receiveResult(NodeHandleSet result) {
                if (result.size() != 1) {
                    this.receiveException(new IndexOutOfBoundsException("Expected 1 result, got " + result.size()));
                } else {
                    cont.receiveResult(result.getHandle(0));
                }
            }
        });
        if (this.logger.level <= 400) {
            this.logger.log("NodeLookup being sent to id  " + id + " with sequence number " + seq);
        }
        this.endpoint.route(id, new NodeLookupQuery(this.endpoint.getLocalNodeHandle(), 1, seq), null);
        this.endpoint.scheduleMessage(new NodeLookupTimeout(seq), this.timeout);
    }

    public static class NodeLookupTimeoutException
    extends Exception {
        private static final long serialVersionUID = -9138111846775601203L;
    }

    public static class NodeLookupResponse
    implements Message {
        private static final long serialVersionUID = -3200682143184682743L;
        protected NodeHandleSet nodes;
        protected int seqno;

        public NodeLookupResponse(NodeHandleSet nodes, int seqno) {
            this.nodes = nodes;
            this.seqno = seqno;
        }

        public int getPriority() {
            return 0;
        }
    }

    public static class NodeLookupQuery
    implements Message {
        private static final long serialVersionUID = -4882776401593706141L;
        protected NodeHandle source;
        protected int numNodes;
        protected int seqno;

        public NodeLookupQuery(NodeHandle localHandle, int num, int seqno) {
            this.numNodes = num;
            this.seqno = seqno;
            this.source = localHandle;
        }

        public int getPriority() {
            return 0;
        }
    }

    public static class NodeLookupTimeout
    implements Message {
        private static final long serialVersionUID = 1648981192042898092L;
        int seqno;

        public NodeLookupTimeout(int seqno) {
            this.seqno = seqno;
        }

        public int getPriority() {
            return 0;
        }
    }
}

