/*
 * Decompiled with CFR 0.152.
 */
package rice.persistence;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.Id;
import rice.persistence.LockManager;
import rice.persistence.StorageManagerImpl;

public class LockManagerImpl
implements LockManager {
    private HashMap locks = new HashMap();
    protected Logger logger;

    public LockManagerImpl(Environment env) {
        this.logger = env.getLogManager().getLogger(StorageManagerImpl.class, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Id id, Continuation c) {
        Continuation torun = null;
        if (this.logger.level <= 500) {
            this.logger.log("locking on id " + id + " for continuation " + c);
        }
        LockManagerImpl lockManagerImpl = this;
        synchronized (lockManagerImpl) {
            if (this.locks.containsKey(id)) {
                List locklist = (List)this.locks.get(id);
                if (this.logger.level <= 400) {
                    this.logger.log("locking on id " + id + "; blocked on " + locklist.size() + " earlier continuations");
                }
                if (locklist.size() > 10 && this.logger.level <= 800) {
                    this.logger.log("locking on id " + id + "; " + locklist.size() + " continuations in queue.  That seems large");
                }
                locklist.add(c);
            } else {
                this.locks.put(id, new LinkedList());
                if (this.logger.level <= 400) {
                    this.logger.log("locking on id " + id + "; no contention so running " + c);
                }
                torun = c;
            }
        }
        if (torun != null) {
            torun.receiveResult(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Id id) {
        Continuation torun = null;
        if (this.logger.level <= 500) {
            this.logger.log("unlocking on id " + id);
        }
        LockManagerImpl lockManagerImpl = this;
        synchronized (lockManagerImpl) {
            if (this.locks.containsKey(id)) {
                if (((List)this.locks.get(id)).isEmpty()) {
                    if (this.logger.level <= 400) {
                        this.logger.log("unlocking on id " + id + "; last out the door -- removing lock ");
                    }
                    this.locks.remove(id);
                } else {
                    Continuation next = (Continuation)((List)this.locks.get(id)).remove(0);
                    if (this.logger.level <= 400) {
                        this.logger.log("unlocking on id " + id + "; starting next continuation " + next);
                    }
                    torun = next;
                }
            } else if (this.logger.level <= 900) {
                this.logger.log("unlocking on id " + id + "; no lock currently held!!");
            }
        }
        if (torun != null) {
            torun.receiveResult(null);
        }
    }
}

