/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.transport;

import java.io.IOException;
import java.util.Collection;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.params.Parameters;
import rice.p2p.commonapi.Cancellable;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.boot.Bootstrapper;
import rice.pastry.join.JoinProtocol;
import rice.pastry.leafset.LeafSet;
import rice.pastry.leafset.LeafSetProtocol;
import rice.pastry.messaging.MessageDispatch;
import rice.pastry.pns.PNSApplication;
import rice.pastry.routing.RouteSetProtocol;
import rice.pastry.routing.RouterStrategy;
import rice.pastry.routing.RoutingTable;
import rice.pastry.standard.ConsistentJoinProtocol;
import rice.pastry.standard.PeriodicLeafSetProtocol;
import rice.pastry.standard.ProximityNeighborSelector;
import rice.pastry.standard.RapidRerouter;
import rice.pastry.standard.StandardRouteSetProtocol;
import rice.pastry.transport.NodeHandleAdapter;
import rice.pastry.transport.TLDeserializer;
import rice.pastry.transport.TLPastryNode;

public abstract class TransportPastryNodeFactory
extends PastryNodeFactory {
    protected int leafSetMaintFreq;
    protected int routeSetMaintFreq;

    public TransportPastryNodeFactory(Environment env) {
        super(env);
        Parameters params = env.getParameters();
        this.leafSetMaintFreq = params.getInt("pastry_leafSetMaintFreq");
        this.routeSetMaintFreq = params.getInt("pastry_routeSetMaintFreq");
    }

    protected TLPastryNode nodeHandleHelper(TLPastryNode pn) throws IOException {
        NodeHandleFactory handleFactory = this.getNodeHandleFactory(pn);
        NodeHandle localhandle = this.getLocalHandle(pn, handleFactory);
        TLDeserializer deserializer = this.getTLDeserializer(handleFactory, pn);
        MessageDispatch msgDisp = new MessageDispatch(pn);
        RoutingTable routeTable = new RoutingTable(localhandle, this.rtMax, this.rtBase, pn);
        LeafSet leafSet = new LeafSet(localhandle, (int)this.lSetSize, routeTable);
        RapidRerouter router = new RapidRerouter(pn, msgDisp, this.getRouterStrategy(pn));
        pn.setElements(localhandle, msgDisp, leafSet, routeTable, router);
        NodeHandleAdapter nha = this.getNodeHandleAdapter(pn, handleFactory, deserializer);
        pn.setSocketElements(localhandle, this.leafSetMaintFreq, this.routeSetMaintFreq, nha, nha, nha, deserializer, handleFactory);
        router.register();
        this.registerApps(pn, leafSet, routeTable, nha, handleFactory);
        return pn;
    }

    protected RouterStrategy getRouterStrategy(PastryNode pn) {
        return null;
    }

    protected void registerApps(TLPastryNode pn, LeafSet leafSet, RoutingTable routeTable, NodeHandleAdapter nha, NodeHandleFactory handleFactory) {
        ProximityNeighborSelector pns = this.getProximityNeighborSelector(pn);
        Bootstrapper bootstrapper = this.getBootstrapper(pn, nha, handleFactory, pns);
        RouteSetProtocol rsProtocol = this.getRouteSetProtocol(pn, leafSet, routeTable);
        LeafSetProtocol lsProtocol = this.getLeafSetProtocol(pn, leafSet, routeTable);
        JoinProtocol jProtocol = this.getJoinProtocol(pn, leafSet, routeTable, lsProtocol);
        pn.setJoinProtocols(bootstrapper, jProtocol, lsProtocol, rsProtocol);
    }

    protected RouteSetProtocol getRouteSetProtocol(TLPastryNode pn, LeafSet leafSet, RoutingTable routeTable) {
        StandardRouteSetProtocol rsProtocol = new StandardRouteSetProtocol((PastryNode)pn, routeTable);
        rsProtocol.register();
        return rsProtocol;
    }

    protected LeafSetProtocol getLeafSetProtocol(TLPastryNode pn, LeafSet leafSet, RoutingTable routeTable) {
        PeriodicLeafSetProtocol lsProtocol = new PeriodicLeafSetProtocol((PastryNode)pn, pn.getLocalHandle(), leafSet, routeTable);
        lsProtocol.register();
        return lsProtocol;
    }

    protected JoinProtocol getJoinProtocol(TLPastryNode pn, LeafSet leafSet, RoutingTable routeTable, LeafSetProtocol lsProtocol) {
        ConsistentJoinProtocol jProtocol = new ConsistentJoinProtocol((PastryNode)pn, pn.getLocalHandle(), routeTable, leafSet, (PeriodicLeafSetProtocol)lsProtocol);
        jProtocol.register();
        return jProtocol;
    }

    protected TLDeserializer getTLDeserializer(NodeHandleFactory handleFactory, TLPastryNode pn) {
        TLDeserializer deserializer = new TLDeserializer(handleFactory, pn.getEnvironment());
        return deserializer;
    }

    protected ProximityNeighborSelector getProximityNeighborSelector(TLPastryNode pn) {
        if (this.environment.getParameters().getBoolean("transport_use_pns")) {
            PNSApplication pns = new PNSApplication(pn);
            pns.register();
            return pns;
        }
        return new ProximityNeighborSelector(){

            @Override
            public Cancellable getNearHandles(Collection<NodeHandle> bootHandles, Continuation<Collection<NodeHandle>, Exception> deliverResultToMe) {
                deliverResultToMe.receiveResult(bootHandles);
                return null;
            }
        };
    }

    protected abstract NodeHandle getLocalHandle(TLPastryNode var1, NodeHandleFactory var2) throws IOException;

    protected abstract NodeHandleAdapter getNodeHandleAdapter(TLPastryNode var1, NodeHandleFactory var2, TLDeserializer var3) throws IOException;

    protected abstract NodeHandleFactory getNodeHandleFactory(TLPastryNode var1) throws IOException;

    protected abstract Bootstrapper getBootstrapper(TLPastryNode var1, NodeHandleAdapter var2, NodeHandleFactory var3, ProximityNeighborSelector var4);
}

