/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing.rendezvous;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import rice.environment.Environment;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.leafset.LeafSet;
import rice.pastry.socket.internet.InternetPastryNodeFactory;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.pastry.testing.rendezvous.MyApp;

public class DistTutorialInternet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistTutorialInternet(InetAddress bindAddress, int bindport, InetSocketAddress bootaddress, Environment env) throws Exception {
        PastryNode node;
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        InternetPastryNodeFactory factory = new InternetPastryNodeFactory(nidFactory, bindAddress, bindport, env, null, Collections.singletonList(bootaddress), null);
        NodeHandle bootHandle = factory.getNodeHandle(bootaddress);
        PastryNode pastryNode = node = factory.newNode(bootHandle);
        synchronized (pastryNode) {
            while (!node.isReady() && !node.joinFailed()) {
                node.wait(500L);
                if (!node.joinFailed()) continue;
                throw new IOException("Could not join the FreePastry ring.  Reason:" + node.joinFailedReason());
            }
        }
        System.out.println("Finished creating new node " + node);
        MyApp app = new MyApp(node);
        env.getTimeSource().sleep(10000L);
        if (bootHandle != null) {
            for (int i = 0; i < 10; ++i) {
                Id randId = nidFactory.generateNodeId();
                app.routeMyMsg(randId);
                env.getTimeSource().sleep(1000L);
            }
            env.getTimeSource().sleep(10000L);
            LeafSet leafSet = node.getLeafSet();
            for (int i = -leafSet.ccwSize(); i <= leafSet.cwSize(); ++i) {
                if (i == 0) continue;
                NodeHandle nh = leafSet.get(i);
                app.routeMyMsgDirect(nh);
                env.getTimeSource().sleep(1000L);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Environment env = new Environment();
        try {
            int bindport = Integer.parseInt(args[0]);
            InetAddress bootaddr = InetAddress.getByName(args[1]);
            int bootport = Integer.parseInt(args[2]);
            InetSocketAddress bootaddress = new InetSocketAddress(bootaddr, bootport);
            InetAddress bindaddr = null;
            if (args.length >= 4) {
                bindaddr = InetAddress.getByName(args[3]);
            }
            DistTutorialInternet dt = new DistTutorialInternet(bindaddr, bindport, bootaddress, env);
        }
        catch (Exception e) {
            System.out.println("Usage:");
            System.out.println("java [-cp FreePastry-<version>.jar] rice.tutorial.lesson3.DistTutorial localbindport bootIP bootPort natted");
            System.out.println("example java rice.tutorial.DistTutorial 9001 pokey.cs.almamater.edu 9001 true");
            throw e;
        }
    }
}

