/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import rice.Continuation;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.pastry.ExponentialBackoffScheduledMessage;
import rice.pastry.Id;
import rice.pastry.JoinFailedException;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.ScheduledMessage;
import rice.pastry.client.PastryAppl;
import rice.pastry.join.InitiateJoin;
import rice.pastry.join.JoinAddress;
import rice.pastry.join.JoinProtocol;
import rice.pastry.join.JoinRequest;
import rice.pastry.leafset.BroadcastLeafSet;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.PJavaSerializedDeserializer;
import rice.pastry.routing.BroadcastRouteRow;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RouteMessageNotification;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.transport.PMessageNotification;
import rice.pastry.transport.PMessageReceipt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardJoinProtocol
extends PastryAppl
implements JoinProtocol {
    protected NodeHandle localHandle;
    protected RoutingTable routeTable;
    protected LeafSet leafSet;
    protected ScheduledMessage joinEvent;

    public StandardJoinProtocol(PastryNode ln, NodeHandle lh, RoutingTable rt, LeafSet ls) {
        this(ln, lh, rt, ls, null);
    }

    public StandardJoinProtocol(PastryNode ln, NodeHandle lh, RoutingTable rt, LeafSet ls, MessageDeserializer md) {
        super(ln, null, JoinAddress.getCode(), md == null ? new SJPDeserializer(ln) : md);
        this.localHandle = lh;
        this.routeTable = rt;
        this.leafSet = ls;
    }

    @Override
    public int getAddress() {
        return JoinAddress.getCode();
    }

    @Override
    public void initiateJoin(Collection<NodeHandle> bootstrap) {
        if (this.logger.level <= 700) {
            this.logger.log("initiateJoin(" + bootstrap + ")");
        }
        if (bootstrap == null || bootstrap.isEmpty()) {
            this.thePastryNode.setReady();
        } else {
            this.joinEvent = new ExponentialBackoffScheduledMessage(this.thePastryNode, new InitiateJoin(bootstrap), this.thePastryNode.getEnvironment().getSelectorManager().getTimer(), 0L, 2000L, 2.0, 60000L);
        }
    }

    @Override
    public void receiveMessage(Message msg) {
        if (msg instanceof JoinRequest) {
            JoinRequest jr = (JoinRequest)msg;
            this.handleJoinRequest(jr);
        } else if (msg instanceof RouteMessage) {
            RouteMessage rm = (RouteMessage)msg;
            this.handleIntermediateHop(rm);
        } else if (msg instanceof InitiateJoin) {
            InitiateJoin ij = (InitiateJoin)msg;
            this.handleInitiateJoin(ij);
        }
    }

    protected void handleInitiateJoin(InitiateJoin ij) {
        final NodeHandle nh = ij.getHandle();
        if (nh == null) {
            if (this.logger.level <= 1000) {
                this.logger.log("ERROR: Cannot join ring.  All bootstraps are faulty." + ij);
            }
            this.thePastryNode.joinFailed(new JoinFailedException("Cannot join ring.  All bootstraps are faulty." + ij));
        } else {
            if (this.logger.level <= 800) {
                this.logger.log("InitiateJoin attempting to join:" + nh + " liveness:" + nh.getLiveness());
            }
            this.getJoinRequest(nh, new Continuation<JoinRequest, Exception>(){

                @Override
                public void receiveResult(JoinRequest jr) {
                    RouteMessage rm = new RouteMessage(StandardJoinProtocol.this.localHandle.getNodeId(), jr, null, null, (byte)StandardJoinProtocol.this.thePastryNode.getEnvironment().getParameters().getInt("pastry_protocol_router_routeMsgVersion"));
                    rm.getOptions().setRerouteIfSuspected(false);
                    rm.setPrevNode(StandardJoinProtocol.this.localHandle);
                    StandardJoinProtocol.this.thePastryNode.send(nh, rm, null, StandardJoinProtocol.this.getOptions(jr, StandardJoinProtocol.this.options));
                }

                @Override
                public void receiveException(Exception exception) {
                }
            });
        }
    }

    protected void getJoinRequest(NodeHandle bootstrap, Continuation<JoinRequest, Exception> deliverJRToMe) {
        JoinRequest jr = new JoinRequest(this.localHandle, this.thePastryNode.getRoutingTable().baseBitLength(), this.thePastryNode.getEnvironment().getTimeSource().currentTimeMillis());
        deliverJRToMe.receiveResult(jr);
    }

    protected void handleIntermediateHop(RouteMessage rm) {
        block5: {
            try {
                JoinRequest jr = (JoinRequest)rm.unwrap(this.deserializer);
                Id localId = this.localHandle.getNodeId();
                NodeHandle jh = jr.getHandle();
                Id nid = jh.getNodeId();
                if (!jh.equals(this.localHandle)) {
                    byte base = this.thePastryNode.getRoutingTable().baseBitLength();
                    int msdd = localId.indexOfMSDD(nid, base);
                    int last = jr.lastRow();
                    for (int i = last - 1; msdd > 0 && i >= msdd; --i) {
                        RouteSet[] row = this.routeTable.getRow(i);
                        jr.pushRow(row);
                    }
                    rm.setRouteMessageNotification(new RouteMessageNotification(){

                        public void sendSuccess(RouteMessage message, NodeHandle nextHop) {
                            if (((StandardJoinProtocol)StandardJoinProtocol.this).logger.level <= 700) {
                                StandardJoinProtocol.this.logger.log("sendSuccess(" + message + "):" + nextHop);
                            }
                        }

                        public void sendFailed(RouteMessage message, Exception e) {
                            if (((StandardJoinProtocol)StandardJoinProtocol.this).logger.level <= 700) {
                                StandardJoinProtocol.this.logger.log("sendFailed(" + message + ")");
                            }
                        }
                    });
                    rm.setTLOptions(this.getOptions(jr, rm.getTLOptions()));
                    if (this.logger.level <= 700) {
                        this.logger.log("Routing " + rm);
                    }
                    this.thePastryNode.getRouter().route(rm);
                }
            }
            catch (IOException ioe) {
                if (this.logger.level > 1000) break block5;
                this.logger.logException("StandardJoinProtocol.receiveMessage()", ioe);
            }
        }
    }

    protected void handleJoinRequest(JoinRequest jr) {
        if (!jr.accepted()) {
            this.respondToJoiner(jr);
        } else {
            this.completeJoin(jr);
        }
    }

    protected void respondToJoiner(final JoinRequest jr) {
        NodeHandle joiner = jr.getHandle();
        if (this.thePastryNode.isReady()) {
            if (this.logger.level <= 700) {
                this.logger.log("acceptJoin " + jr);
            }
            jr.acceptJoin(this.localHandle, this.leafSet);
            this.thePastryNode.send(joiner, jr, new PMessageNotification(){

                public void sent(PMessageReceipt msg) {
                    if (((StandardJoinProtocol)StandardJoinProtocol.this).logger.level <= 700) {
                        StandardJoinProtocol.this.logger.log("acceptJoin.sent(" + msg + "):" + jr);
                    }
                }

                public void sendFailed(PMessageReceipt msg, Exception reason2) {
                    Throwable reason = reason2;
                    if (((StandardJoinProtocol)StandardJoinProtocol.this).logger.level <= 700) {
                        StandardJoinProtocol.this.logger.logException("acceptJoin.sendFailed(" + msg + "):" + jr, reason);
                        while (reason.getCause() != null) {
                            reason = reason.getCause();
                            StandardJoinProtocol.this.logger.logException("because", reason);
                        }
                    }
                }
            }, this.getOptions(jr, this.options));
        } else if (this.logger.level <= 800) {
            this.logger.log("NOTE: Dropping incoming JoinRequest " + jr + " because local node is not ready!");
        }
    }

    protected Map<String, Object> getOptions(JoinRequest jr, Map<String, Object> existing) {
        return existing;
    }

    protected void completeJoin(JoinRequest jr) {
        NodeHandle jh = jr.getJoinHandle();
        if (jh.getId().equals(this.localHandle.getId()) && !jh.equals(this.localHandle)) {
            if (this.logger.level <= 900) {
                this.logger.log("NodeId collision, unable to join: " + this.localHandle + ":" + jh);
            }
        } else if (jh.isAlive()) {
            this.routeTable.put(jh);
            BroadcastLeafSet bls = new BroadcastLeafSet(jh, jr.getLeafSet(), 1, 0L);
            this.thePastryNode.receiveMessage(bls);
            this.broadcastRows(jr);
            this.setReady();
        }
    }

    protected void setReady() {
        if (this.joinEvent != null) {
            this.joinEvent.cancel();
        }
        this.joinEvent = null;
        this.thePastryNode.setReady();
    }

    public void broadcastRows(JoinRequest jr) {
        BroadcastRouteRow brr;
        RouteSet[] row;
        int i;
        int n = jr.numRows();
        for (i = jr.lastRow(); i < n; ++i) {
            row = jr.getRow(i);
            if (row == null) continue;
            brr = new BroadcastRouteRow(this.localHandle, row);
            this.thePastryNode.receiveMessage(brr);
        }
        for (i = jr.lastRow(); i < n; ++i) {
            row = jr.getRow(i);
            brr = new BroadcastRouteRow(this.localHandle, row);
            for (int j = 0; j < row.length; ++j) {
                NodeHandle nh;
                RouteSet rs = row[j];
                if (rs == null || (nh = rs.closestNode()) == null) continue;
                this.thePastryNode.send(nh, brr, null, this.options);
            }
        }
    }

    @Override
    public void messageForAppl(Message msg) {
        throw new RuntimeException("Should not be called.");
    }

    @Override
    public boolean deliverWhenNotReady() {
        return true;
    }

    public static class SJPDeserializer
    extends PJavaSerializedDeserializer {
        public SJPDeserializer(PastryNode pn) {
            super(pn);
        }

        public Message deserialize(InputBuffer buf, short type, int priority, NodeHandle sender) throws IOException {
            switch (type) {
                case 1: {
                    return new JoinRequest(buf, this.pn, sender, this.pn);
                }
            }
            return null;
        }
    }
}

