/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.nat.rendezvous;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.identity.IdentitySerializer;
import org.mpisws.p2p.transport.liveness.LivenessProvider;
import org.mpisws.p2p.transport.liveness.Pinger;
import org.mpisws.p2p.transport.multiaddress.AddressStrategy;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.multiaddress.SimpleAddressStrategy;
import org.mpisws.p2p.transport.nat.FirewallTLImpl;
import org.mpisws.p2p.transport.priority.PriorityTransportLayer;
import org.mpisws.p2p.transport.proximity.ProximityProvider;
import org.mpisws.p2p.transport.rendezvous.ContactDeserializer;
import org.mpisws.p2p.transport.rendezvous.ContactDirectStrategy;
import org.mpisws.p2p.transport.rendezvous.PilotFinder;
import org.mpisws.p2p.transport.rendezvous.PilotManager;
import org.mpisws.p2p.transport.rendezvous.RendezvousGenerationStrategy;
import org.mpisws.p2p.transport.rendezvous.RendezvousStrategy;
import org.mpisws.p2p.transport.rendezvous.RendezvousTransportLayerImpl;
import org.mpisws.p2p.transport.rendezvous.ResponseStrategy;
import org.mpisws.p2p.transport.rendezvous.TimeoutResponseStrategy;
import org.mpisws.p2p.transport.sourceroute.SourceRoute;
import org.mpisws.p2p.transport.sourceroute.factory.MultiAddressSourceRouteFactory;
import org.mpisws.p2p.transport.sourceroute.manager.simple.NextHopStrategy;
import org.mpisws.p2p.transport.util.OptionsFactory;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.params.Parameters;
import rice.environment.random.RandomSource;
import rice.p2p.commonapi.Cancellable;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.ReadyStrategy;
import rice.pastry.boot.Bootstrapper;
import rice.pastry.join.JoinProtocol;
import rice.pastry.leafset.LeafSet;
import rice.pastry.leafset.LeafSetProtocol;
import rice.pastry.routing.RoutingTable;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketNodeHandleFactory;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.socket.TransportLayerNodeHandle;
import rice.pastry.socket.nat.rendezvous.LeafSetPilotFinder;
import rice.pastry.socket.nat.rendezvous.LeafSetPilotStrategy;
import rice.pastry.socket.nat.rendezvous.RendezvousApp;
import rice.pastry.socket.nat.rendezvous.RendezvousContactDirectStrategy;
import rice.pastry.socket.nat.rendezvous.RendezvousJoinProtocol;
import rice.pastry.socket.nat.rendezvous.RendezvousLeafSetNHStrategy;
import rice.pastry.socket.nat.rendezvous.RendezvousPNSApplication;
import rice.pastry.socket.nat.rendezvous.RendezvousRouterStrategy;
import rice.pastry.socket.nat.rendezvous.RendezvousSNHFactory;
import rice.pastry.socket.nat.rendezvous.RendezvousSPNFIdentitySerializer;
import rice.pastry.socket.nat.rendezvous.RendezvousSocketNodeHandle;
import rice.pastry.standard.PeriodicLeafSetProtocol;
import rice.pastry.standard.ProximityNeighborSelector;
import rice.pastry.standard.StandardRouter;
import rice.pastry.transport.NodeHandleAdapter;
import rice.pastry.transport.TLPastryNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RendezvousSocketPastryNodeFactory
extends SocketPastryNodeFactory {
    protected String CONTACT_STATE = "RendezvousSocketPastryNodeFactory.CONTACT_STATE";
    protected RandomSource random;
    public static final String RENDEZVOUS_STRATEGY = "RendezvousSocketPastryNodeFactory.RENDEZVOUS_STRATEGY";
    public static final String RENDEZVOUS_TL = "RendezvousSocketPastryNodeFactory.RENDEZVOUS_TL";
    public static final String SIMULATE_FIREWALL = "rendezvous_simulate_firewall";
    public static final String RENDEZVOUS_CONTACT_DIRECT_STRATEGY = "RendezvousSocketPastryNodeFactory.ContactDirectStrategy";
    byte localContactState = 0;
    boolean firstNode = true;

    public RendezvousSocketPastryNodeFactory(NodeIdFactory nf, InetAddress bindAddress, int startPort, Environment env, boolean firewalled) throws IOException {
        super(nf, bindAddress, startPort, env);
        this.init(firewalled);
    }

    public RendezvousSocketPastryNodeFactory(NodeIdFactory nf, int startPort, Environment env, boolean firewalled) throws IOException {
        super(nf, startPort, env);
        this.init(firewalled);
    }

    private void init(boolean firewalled) {
        this.random = this.environment.getRandomSource();
        if (firewalled) {
            this.setContactState((byte)1);
        }
    }

    public void setContactState(byte contactState) {
        this.localContactState = contactState;
    }

    protected void newNodeSelector(Id nodeId, MultiInetSocketAddress proxyAddress, Continuation<PastryNode, IOException> deliverResultToMe, Map<String, Object> initialVars, boolean firewalled) {
        byte contactState = this.localContactState;
        contactState = firewalled ? (byte)1 : 0;
        this.newNodeSelector(nodeId, proxyAddress, deliverResultToMe, initialVars, contactState);
    }

    protected void newNodeSelector(Id nodeId, MultiInetSocketAddress proxyAddress, Continuation<PastryNode, IOException> deliverResultToMe, Map<String, Object> initialVars, byte contactState) {
        initialVars = OptionsFactory.addOption(initialVars, this.CONTACT_STATE, contactState);
        super.newNodeSelector(nodeId, proxyAddress, deliverResultToMe, initialVars);
    }

    @Override
    protected JoinProtocol getJoinProtocol(TLPastryNode pn, LeafSet leafSet, RoutingTable routeTable, LeafSetProtocol lsProtocol) {
        RendezvousJoinProtocol jProtocol = new RendezvousJoinProtocol((PastryNode)pn, pn.getLocalHandle(), routeTable, leafSet, (ReadyStrategy)((PeriodicLeafSetProtocol)lsProtocol), (PilotManager)pn.getVars().get(RENDEZVOUS_TL));
        jProtocol.register();
        return jProtocol;
    }

    @Override
    protected TransportLayer<InetSocketAddress, ByteBuffer> getIpServiceTransportLayer(TransportLayer<InetSocketAddress, ByteBuffer> wtl, TLPastryNode pn) {
        TransportLayer<InetSocketAddress, ByteBuffer> mtl = super.getIpServiceTransportLayer(wtl, pn);
        if (pn.getLocalHandle() == null) {
            return mtl;
        }
        return this.getRendezvousTransportLayer(mtl, pn);
    }

    @Override
    protected IdentitySerializer<TransportLayerNodeHandle<MultiInetSocketAddress>, MultiInetSocketAddress, SourceRoute<MultiInetSocketAddress>> getIdentiySerializer(TLPastryNode pn, SocketNodeHandleFactory handleFactory) {
        return new RendezvousSPNFIdentitySerializer(pn, handleFactory);
    }

    protected TransportLayer<InetSocketAddress, ByteBuffer> getRendezvousTransportLayer(TransportLayer<InetSocketAddress, ByteBuffer> mtl, TLPastryNode pn) {
        RendezvousTransportLayerImpl<InetSocketAddress, RendezvousSocketNodeHandle> ret = new RendezvousTransportLayerImpl<InetSocketAddress, RendezvousSocketNodeHandle>(mtl, "identity.node_handle_to_index", (RendezvousSocketNodeHandle)pn.getLocalHandle(), this.getContactDeserializer(pn), this.getRendezvousGenerator(pn), this.getPilotFinder(pn), this.getRendezvousStrategyHelper(pn), this.getResponseStrategy(pn), this.getContactDirectStrategy(pn), pn.getEnvironment());
        pn.getVars().put(RENDEZVOUS_TL, ret);
        ((RendezvousStrategy)pn.getVars().get(RENDEZVOUS_STRATEGY)).setTransportLayer(ret);
        this.generatePilotStrategy(pn, ret);
        return ret;
    }

    @Override
    protected NextHopStrategy<MultiInetSocketAddress> getNextHopStrategy(TransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> ltl, LivenessProvider<SourceRoute<MultiInetSocketAddress>> livenessProvider, Pinger<SourceRoute<MultiInetSocketAddress>> pinger, TLPastryNode pn, MultiInetSocketAddress proxyAddress, MultiAddressSourceRouteFactory esrFactory) throws IOException {
        return new RendezvousLeafSetNHStrategy(pn.getLeafSet());
    }

    protected ResponseStrategy<InetSocketAddress> getResponseStrategy(TLPastryNode pn) {
        return new TimeoutResponseStrategy<InetSocketAddress>(3000, pn.getEnvironment());
    }

    protected ContactDirectStrategy<RendezvousSocketNodeHandle> getContactDirectStrategy(TLPastryNode pn) {
        AddressStrategy adrStrat = (AddressStrategy)pn.getVars().get("SocketPastryNodeFactory.milti-inet-addressStrategy");
        if (adrStrat == null) {
            adrStrat = new SimpleAddressStrategy();
        }
        RendezvousContactDirectStrategy ret = new RendezvousContactDirectStrategy((RendezvousSocketNodeHandle)pn.getLocalNodeHandle(), adrStrat, pn.getEnvironment());
        pn.getVars().put(RENDEZVOUS_CONTACT_DIRECT_STRATEGY, ret);
        return ret;
    }

    protected PilotFinder<RendezvousSocketNodeHandle> getPilotFinder(TLPastryNode pn) {
        return new LeafSetPilotFinder(pn);
    }

    protected void generatePilotStrategy(TLPastryNode pn, RendezvousTransportLayerImpl<InetSocketAddress, RendezvousSocketNodeHandle> rendezvousLayer) {
        RendezvousSocketNodeHandle handle = (RendezvousSocketNodeHandle)pn.getLocalHandle();
        if (handle != null && !handle.canContactDirect()) {
            new LeafSetPilotStrategy(pn.getLeafSet(), rendezvousLayer, pn.getEnvironment());
        }
    }

    protected ContactDeserializer<InetSocketAddress, RendezvousSocketNodeHandle> getContactDeserializer(final TLPastryNode pn) {
        return new ContactDeserializer<InetSocketAddress, RendezvousSocketNodeHandle>(){

            @Override
            public Map<String, Object> getOptions(RendezvousSocketNodeHandle high) {
                return OptionsFactory.addOption(null, "identity.node_handle_to_index", high);
            }

            @Override
            public RendezvousSocketNodeHandle deserialize(InputBuffer sib) throws IOException {
                return (RendezvousSocketNodeHandle)pn.readNodeHandle(sib);
            }

            @Override
            public InetSocketAddress convert(RendezvousSocketNodeHandle high) {
                return high.eaddress.getAddress(0);
            }

            @Override
            public void serialize(RendezvousSocketNodeHandle i, OutputBuffer buf) throws IOException {
                i.serialize(buf);
            }

            @Override
            public ByteBuffer serialize(RendezvousSocketNodeHandle i) throws IOException {
                SimpleOutputBuffer sob = new SimpleOutputBuffer();
                this.serialize(i, (OutputBuffer)sob);
                return sob.getByteBuffer();
            }
        };
    }

    protected RendezvousGenerationStrategy<RendezvousSocketNodeHandle> getRendezvousGenerator(TLPastryNode pn) {
        return null;
    }

    @Override
    protected ProximityNeighborSelector getProximityNeighborSelector(TLPastryNode pn) {
        if (this.environment.getParameters().getBoolean("transport_use_pns")) {
            RendezvousPNSApplication pns = new RendezvousPNSApplication((PastryNode)pn, (ContactDirectStrategy)pn.getVars().get(RENDEZVOUS_CONTACT_DIRECT_STRATEGY));
            pns.register();
            return pns;
        }
        return new ProximityNeighborSelector(){

            @Override
            public Cancellable getNearHandles(Collection<NodeHandle> bootHandles, Continuation<Collection<NodeHandle>, Exception> deliverResultToMe) {
                deliverResultToMe.receiveResult(bootHandles);
                return null;
            }
        };
    }

    protected RendezvousStrategy<RendezvousSocketNodeHandle> getRendezvousStrategyHelper(TLPastryNode pn) {
        RendezvousStrategy<RendezvousSocketNodeHandle> app = this.getRendezvousStrategy(pn);
        pn.getVars().put(RENDEZVOUS_STRATEGY, app);
        return app;
    }

    protected RendezvousStrategy<RendezvousSocketNodeHandle> getRendezvousStrategy(TLPastryNode pn) {
        RendezvousApp app = new RendezvousApp(pn);
        return app;
    }

    @Override
    protected void registerApps(TLPastryNode pn, LeafSet leafSet, RoutingTable routeTable, NodeHandleAdapter nha, NodeHandleFactory handleFactory) {
        super.registerApps(pn, leafSet, routeTable, nha, handleFactory);
        RendezvousStrategy app = (RendezvousStrategy)pn.getVars().get(RENDEZVOUS_STRATEGY);
        if (app instanceof RendezvousApp) {
            ((RendezvousApp)app).register();
        }
    }

    @Override
    public NodeHandleFactory getNodeHandleFactory(TLPastryNode pn) {
        return new RendezvousSNHFactory(pn);
    }

    @Override
    public NodeHandle getLocalHandle(TLPastryNode pn, NodeHandleFactory nhf) {
        byte contactState = this.localContactState;
        if (pn.getVars().containsKey(this.CONTACT_STATE)) {
            contactState = (Byte)pn.getVars().get(this.CONTACT_STATE);
        }
        Parameters p = this.environment.getParameters();
        if (this.firstNode && p.getBoolean("rendezvous_test_makes_bootstrap")) {
            this.firstNode = false;
        } else if (p.getBoolean("rendezvous_test_firewall") && this.random.nextFloat() <= p.getFloat("rendezvous_test_num_firewalled")) {
            pn.getVars().put(SIMULATE_FIREWALL, true);
            contactState = 1;
        }
        RendezvousSNHFactory pnhf = (RendezvousSNHFactory)nhf;
        MultiInetSocketAddress proxyAddress = (MultiInetSocketAddress)pn.getVars().get("SocketPastryNodeFactory.proxyAddress");
        SocketNodeHandle ret = pnhf.getNodeHandle(proxyAddress, pn.getEnvironment().getTimeSource().currentTimeMillis(), pn.getNodeId(), contactState);
        if (this.logger.level <= 500 || contactState != this.localContactState && this.logger.level <= 800) {
            switch (contactState) {
                case 0: {
                    this.logger.log(ret + " is not firewalled.");
                    break;
                }
                case 1: {
                    this.logger.log(ret + " is firewalled.");
                }
            }
        }
        return ret;
    }

    @Override
    protected TransportLayer<InetSocketAddress, ByteBuffer> getWireTransportLayer(InetSocketAddress innermostAddress, TLPastryNode pn) throws IOException {
        TransportLayer<InetSocketAddress, ByteBuffer> baseTl = super.getWireTransportLayer(innermostAddress, pn);
        Parameters p = pn.getEnvironment().getParameters();
        if (pn.getVars().containsKey(SIMULATE_FIREWALL) && ((Boolean)pn.getVars().get(SIMULATE_FIREWALL)).booleanValue() || p.contains(SIMULATE_FIREWALL) && p.getBoolean(SIMULATE_FIREWALL)) {
            return new FirewallTLImpl<InetSocketAddress, ByteBuffer>(baseTl, 5000, pn.getEnvironment());
        }
        return baseTl;
    }

    @Override
    protected PriorityTransportLayer<MultiInetSocketAddress> getPriorityTransportLayer(TransportLayer<MultiInetSocketAddress, ByteBuffer> trans, LivenessProvider<MultiInetSocketAddress> liveness, ProximityProvider<MultiInetSocketAddress> prox, TLPastryNode pn) {
        PriorityTransportLayer<MultiInetSocketAddress> ret = super.getPriorityTransportLayer(trans, liveness, prox, pn);
        ((StandardRouter)pn.getRouter()).setRouterStrategy(new RendezvousRouterStrategy(ret, pn.getEnvironment()));
        return ret;
    }

    @Override
    protected Bootstrapper getBootstrapper(TLPastryNode pn, NodeHandleAdapter tl, NodeHandleFactory handleFactory, ProximityNeighborSelector pns) {
        final PilotManager manager = (PilotManager)pn.getVars().get(RENDEZVOUS_TL);
        if (((RendezvousSocketNodeHandle)pn.getLocalHandle()).canContactDirect()) {
            return super.getBootstrapper(pn, tl, handleFactory, pns);
        }
        final boolean[] booted = new boolean[]{false};
        final ArrayList closeMeWhenReady = new ArrayList();
        Observer obs = new Observer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void update(Observable o, Object arg) {
                if (arg instanceof Boolean && ((Boolean)arg).booleanValue()) {
                    ArrayList arrayList = closeMeWhenReady;
                    synchronized (arrayList) {
                        booted[0] = true;
                    }
                    for (RendezvousSocketNodeHandle nh : closeMeWhenReady) {
                        manager.closePilot(nh);
                    }
                    closeMeWhenReady.clear();
                    o.deleteObserver(this);
                }
            }
        };
        pn.addObserver(obs);
        SocketPastryNodeFactory.TLBootstrapper bootstrapper = new SocketPastryNodeFactory.TLBootstrapper(pn, tl.getTL(), (SocketNodeHandleFactory)handleFactory, pns){

            @Override
            protected void checkLiveness(final SocketNodeHandle h, Map<String, Object> options) {
                ContactDirectStrategy contactStrat = (ContactDirectStrategy)this.pn.getVars().get(RendezvousSocketPastryNodeFactory.RENDEZVOUS_CONTACT_DIRECT_STRATEGY);
                RendezvousSocketNodeHandle rsnh = (RendezvousSocketNodeHandle)h;
                if (!rsnh.canContactDirect() && contactStrat.canContactDirect(rsnh)) {
                    super.checkLiveness(h, options);
                    return;
                }
                manager.openPilot((RendezvousSocketNodeHandle)h, new Continuation<SocketRequestHandle<RendezvousSocketNodeHandle>, Exception>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void receiveResult(SocketRequestHandle<RendezvousSocketNodeHandle> result) {
                        boolean close = false;
                        ArrayList arrayList = closeMeWhenReady;
                        synchronized (arrayList) {
                            if (booted[0]) {
                                close = true;
                            } else {
                                closeMeWhenReady.add(result.getIdentifier());
                            }
                        }
                        if (close) {
                            logger.log("closing pilot");
                            manager.closePilot(result.getIdentifier());
                            return;
                        }
                        pn.getLivenessProvider().checkLiveness(h, null);
                    }

                    @Override
                    public void receiveException(Exception exception) {
                        logger.logException("In Rendezvous Bootstrapper.checkLiveness(" + h + ")", exception);
                    }
                });
            }
        };
        return bootstrapper;
    }

    protected boolean isInternetRoutablePrefix(InetAddress address) {
        String ip = address.getHostAddress();
        String nattedNetworkPrefixes = this.environment.getParameters().getString("nat_network_prefixes");
        String[] nattedNetworkPrefix = nattedNetworkPrefixes.split(";");
        for (int i = 0; i < nattedNetworkPrefix.length; ++i) {
            if (!ip.startsWith(nattedNetworkPrefix[i])) continue;
            return false;
        }
        return true;
    }
}

