/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.nat.rendezvous;

import java.io.IOException;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.rendezvous.RendezvousContact;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.Id;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.transport.TLPastryNode;

public class RendezvousSocketNodeHandle
extends SocketNodeHandle
implements RendezvousContact {
    public static final byte CONTACT_DIRECT = 0;
    public static final byte CONTACT_FIREWALLED = 1;
    private byte contactStatus;

    RendezvousSocketNodeHandle(MultiInetSocketAddress eisa, long epoch, Id id, TLPastryNode node, byte contactStatus) {
        super(eisa, epoch, id, node);
        this.contactStatus = contactStatus;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        super.serialize(buf);
        buf.writeByte(this.contactStatus);
    }

    public boolean canContactDirect() {
        return this.contactStatus != 1;
    }

    static SocketNodeHandle build(InputBuffer buf, TLPastryNode local) throws IOException {
        MultiInetSocketAddress eaddr = MultiInetSocketAddress.build(buf);
        long epoch = buf.readLong();
        Id nid = Id.build(buf);
        byte contactStatus = buf.readByte();
        return new RendezvousSocketNodeHandle(eaddr, epoch, nid, local, contactStatus);
    }

    public byte getContactStatus() {
        return this.contactStatus;
    }

    public String toString() {
        String s = "[RSNH: " + this.nodeId + "/" + this.eaddress;
        if (!this.canContactDirect()) {
            s = s + "(NATTED)";
        }
        s = s + "]";
        return s;
    }
}

