/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.nat.rendezvous;

import java.util.Iterator;
import java.util.Map;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.priority.PriorityTransportLayer;
import org.mpisws.p2p.transport.util.OptionsFactory;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.pastry.NodeHandle;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RouterStrategy;
import rice.pastry.socket.nat.rendezvous.RendezvousSocketNodeHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RendezvousRouterStrategy
implements RouterStrategy {
    PriorityTransportLayer<MultiInetSocketAddress> priority;
    Environment environment;
    Logger logger;

    public RendezvousRouterStrategy(PriorityTransportLayer<MultiInetSocketAddress> priority, Environment env) {
        this.priority = priority;
        this.environment = env;
        this.logger = env.getLogManager().getLogger(RendezvousRouterStrategy.class, null);
    }

    @Override
    public NodeHandle pickNextHop(RouteMessage msg, Iterator<NodeHandle> i) {
        if (!i.hasNext()) {
            return null;
        }
        NodeHandle best = i.next();
        int bestRating = this.routingQuality(best);
        if (this.logger.level <= 300) {
            this.logger.log("Routing " + msg + "(0) " + best + ":" + bestRating);
        }
        if (bestRating == 0) {
            return best;
        }
        int ctr = 1;
        while (i.hasNext()) {
            NodeHandle next = i.next();
            int nextRating = this.routingQuality(next);
            if (this.logger.level <= 300) {
                this.logger.log("Routing " + msg + "(" + ctr++ + ") " + next + ":" + nextRating);
            }
            if (nextRating == 0) {
                return next;
            }
            if (nextRating >= bestRating) continue;
            best = next;
            bestRating = nextRating;
        }
        if (bestRating > 3) {
            if (this.logger.level <= 800) {
                this.logger.log("Can't find route for " + msg);
            }
            return null;
        }
        if (this.logger.level <= 300) {
            this.logger.log("Routing " + msg + "returning " + best + ":" + bestRating);
        }
        return best;
    }

    protected int routingQuality(NodeHandle nh) {
        RendezvousSocketNodeHandle rnh = (RendezvousSocketNodeHandle)nh;
        if (!nh.isAlive()) {
            return 10;
        }
        int connectionStatus = this.priority.connectionStatus(rnh.eaddress);
        int liveness = nh.getLiveness();
        boolean contactDirect = rnh.canContactDirect();
        if (contactDirect) {
            int ret = 2;
            if (liveness == 1) {
                --ret;
            }
            if (connectionStatus == 2) {
                --ret;
            } else {
                this.priority.openPrimaryConnection(rnh.eaddress, this.getOptions(rnh));
            }
            return ret;
        }
        if (connectionStatus > 1) {
            this.priority.openPrimaryConnection(rnh.eaddress, this.getOptions(rnh));
        }
        if (connectionStatus == 2) {
            if (liveness == 1) {
                return 0;
            }
            return 1;
        }
        return 5;
    }

    protected Map<String, Object> getOptions(NodeHandle nh) {
        return OptionsFactory.addOption(null, "identity.node_handle_to_index", nh);
    }
}

