/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.nat.rendezvous;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mpisws.p2p.transport.rendezvous.ContactDirectStrategy;
import rice.Continuation;
import rice.p2p.commonapi.Cancellable;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.leafset.LeafSet;
import rice.pastry.pns.PNSApplication;
import rice.pastry.routing.RouteSet;
import rice.pastry.socket.nat.rendezvous.NodeIsFirewalledException;
import rice.pastry.socket.nat.rendezvous.RendezvousSocketNodeHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RendezvousPNSApplication
extends PNSApplication {
    ContactDirectStrategy<RendezvousSocketNodeHandle> contactDirectStrategy;

    public RendezvousPNSApplication(PastryNode pn, ContactDirectStrategy<RendezvousSocketNodeHandle> contactDirectStrategy) {
        super(pn, pn.getEnvironment().getLogManager().getLogger(RendezvousPNSApplication.class, null));
        this.contactDirectStrategy = contactDirectStrategy;
        if (contactDirectStrategy == null) {
            throw new IllegalArgumentException("Need contactDirectStrategy was null");
        }
    }

    protected boolean ignore(NodeHandle handle, Continuation c) {
        if (this.useHandle(handle)) {
            return false;
        }
        if (this.logger.level <= 500) {
            this.logger.log("PNS not using firewalled node " + handle);
        }
        c.receiveException(new NodeIsFirewalledException(handle));
        return true;
    }

    protected boolean useHandle(NodeHandle handle) {
        RendezvousSocketNodeHandle rsnh = (RendezvousSocketNodeHandle)handle;
        return this.contactDirectStrategy.canContactDirect(rsnh);
    }

    @Override
    protected List<NodeHandle> getNearHandlesHelper(List<NodeHandle> handles) {
        ArrayList<NodeHandle> contactDirect = new ArrayList<NodeHandle>();
        ArrayList<NodeHandle> notContactDirect = new ArrayList<NodeHandle>();
        for (NodeHandle foo : handles) {
            RendezvousSocketNodeHandle rsnh = (RendezvousSocketNodeHandle)foo;
            if (rsnh.canContactDirect()) {
                contactDirect.add(foo);
                continue;
            }
            notContactDirect.add(foo);
        }
        if (contactDirect.isEmpty()) {
            return notContactDirect;
        }
        return contactDirect;
    }

    @Override
    public Cancellable getNearHandles(Collection<NodeHandle> bootHandles, Continuation<Collection<NodeHandle>, Exception> deliverResultToMe) {
        ArrayList<NodeHandle> newBootHandles = new ArrayList<NodeHandle>();
        if (this.logger.level <= 800) {
            this.logger.log("Booting off of " + bootHandles.size() + " nodes. " + bootHandles);
        }
        for (NodeHandle handle : bootHandles) {
            if (this.useHandle(handle)) {
                newBootHandles.add(handle);
                continue;
            }
            if (this.logger.level > 900) continue;
            this.logger.log("Can't use " + handle + " it is firewalled.");
        }
        return super.getNearHandles(newBootHandles, deliverResultToMe);
    }

    @Override
    public Cancellable getLeafSet(final NodeHandle input, final Continuation<LeafSet, Exception> c) {
        if (this.ignore(input, c)) {
            return null;
        }
        return super.getLeafSet(input, new Continuation<LeafSet, Exception>(){

            @Override
            public void receiveResult(LeafSet result) {
                for (NodeHandle handle : result) {
                    if (RendezvousPNSApplication.this.useHandle(handle)) continue;
                    if (((RendezvousPNSApplication)RendezvousPNSApplication.this).logger.level <= 500) {
                        RendezvousPNSApplication.this.logger.log("getLeafSet(" + input + ") Dropping " + handle);
                    }
                    result.remove(handle);
                }
                c.receiveResult(result);
            }

            @Override
            public void receiveException(Exception exception) {
                c.receiveException(exception);
            }
        });
    }

    @Override
    public Cancellable getRouteRow(final NodeHandle input, final short row, final Continuation<RouteSet[], Exception> c) {
        if (this.ignore(input, c)) {
            return null;
        }
        return super.getRouteRow(input, row, new Continuation<RouteSet[], Exception>(){

            @Override
            public void receiveResult(RouteSet[] result) {
                for (int ctr = 0; ctr < result.length; ++ctr) {
                    RouteSet rs = result[ctr];
                    if (rs == null) continue;
                    for (NodeHandle handle : rs) {
                        if (handle == null || RendezvousPNSApplication.this.useHandle(handle)) continue;
                        if (((RendezvousPNSApplication)RendezvousPNSApplication.this).logger.level <= 500) {
                            RendezvousPNSApplication.this.logger.log("getRouteRow(" + input + "," + row + ") Dropping " + handle);
                        }
                        rs.remove(handle);
                    }
                    if (!rs.isEmpty()) continue;
                    result[ctr] = null;
                }
                c.receiveResult(result);
            }

            @Override
            public void receiveException(Exception exception) {
                c.receiveException(exception);
            }
        });
    }

    @Override
    public Cancellable getNearest(NodeHandle seed, Continuation<Collection<NodeHandle>, Exception> retToMe) {
        if (this.ignore(seed, retToMe)) {
            return null;
        }
        return super.getNearest(seed, retToMe);
    }

    @Override
    public Cancellable getProximity(NodeHandle handle, Continuation<Integer, IOException> c, int timeout) {
        if (!this.useHandle(handle)) {
            c.receiveResult(Integer.MAX_VALUE);
            return null;
        }
        return super.getProximity(handle, c, timeout);
    }
}

