/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.nat.rendezvous;

import java.util.ArrayList;
import java.util.HashSet;
import org.mpisws.p2p.transport.rendezvous.PilotFinder;
import rice.environment.random.RandomSource;
import rice.pastry.NodeHandle;
import rice.pastry.leafset.LeafSet;
import rice.pastry.socket.nat.rendezvous.RendezvousSocketNodeHandle;
import rice.pastry.transport.TLPastryNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeafSetPilotFinder
implements PilotFinder<RendezvousSocketNodeHandle> {
    LeafSet leafSet;
    RandomSource random;

    public LeafSetPilotFinder(TLPastryNode pn) {
        this.leafSet = pn.getLeafSet();
        this.random = pn.getEnvironment().getRandomSource();
    }

    @Override
    public RendezvousSocketNodeHandle findPilot(RendezvousSocketNodeHandle dest) {
        if (dest.canContactDirect()) {
            throw new IllegalArgumentException("Dest " + dest + " is not firewalled.");
        }
        if (this.leafSet.contains(dest)) {
            ArrayList list;
            HashSet<RendezvousSocketNodeHandle> possibleIntermediates = new HashSet<RendezvousSocketNodeHandle>();
            if (this.leafSet.overlaps()) {
                for (NodeHandle foo : this.leafSet) {
                    RendezvousSocketNodeHandle nh = (RendezvousSocketNodeHandle)foo;
                    if (!nh.canContactDirect()) continue;
                    possibleIntermediates.add(nh);
                }
            } else {
                int index = this.leafSet.getIndex(dest);
                int maxDist = this.leafSet.maxSize() / 2;
                for (int i = -this.leafSet.ccwSize(); i <= this.leafSet.cwSize(); ++i) {
                    RendezvousSocketNodeHandle nh;
                    if (i == 0 || Math.abs(index - i) > maxDist || !(nh = (RendezvousSocketNodeHandle)this.leafSet.get(i)).canContactDirect()) continue;
                    possibleIntermediates.add(nh);
                }
            }
            if ((list = new ArrayList(possibleIntermediates)).isEmpty()) {
                return null;
            }
            return (RendezvousSocketNodeHandle)list.get(this.random.nextInt(list.size()));
        }
        return null;
    }
}

