/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.nat.connectivityverifiier;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.networkinfo.ConnectivityResult;
import org.mpisws.p2p.transport.networkinfo.InetSocketAddressLookup;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.Cancellable;
import rice.p2p.util.AttachableCancellable;
import rice.pastry.Id;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.socket.nat.connectivityverifiier.ConnectivityVerifier;
import rice.pastry.transport.TLPastryNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectivityVerifierImpl
implements ConnectivityVerifier {
    SocketPastryNodeFactory spnf;
    Environment environment;
    Logger logger;

    public ConnectivityVerifierImpl(SocketPastryNodeFactory spnf) {
        this.spnf = spnf;
        this.environment = spnf.getEnvironment();
        this.logger = this.environment.getLogManager().getLogger(ConnectivityVerifierImpl.class, null);
    }

    protected Cancellable getInetSocketAddressLookup(final InetSocketAddress bindAddress, final Continuation<InetSocketAddressLookup, IOException> deliverResultToMe) {
        final AttachableCancellable ret = new AttachableCancellable();
        Runnable r = new Runnable(){

            public void run() {
                if (ret.isCancelled()) {
                    return;
                }
                TLPastryNode pn = new TLPastryNode(Id.build(), ConnectivityVerifierImpl.this.spnf.getEnvironment());
                try {
                    InetSocketAddressLookup lookup = (InetSocketAddressLookup)((Object)ConnectivityVerifierImpl.this.spnf.getBottomLayers(pn, new MultiInetSocketAddress(bindAddress)));
                    deliverResultToMe.receiveResult(lookup);
                }
                catch (IOException ioe) {
                    deliverResultToMe.receiveException(ioe);
                }
            }
        };
        if (this.spnf.getEnvironment().getSelectorManager().isSelectorThread()) {
            r.run();
        } else {
            this.spnf.getEnvironment().getSelectorManager().invoke(r);
        }
        return ret;
    }

    @Override
    public Cancellable findExternalNodes(final InetSocketAddress local, final Collection<InetSocketAddress> probeAddresses, final Continuation<Collection<InetSocketAddress>, IOException> deliverResultToMe) {
        if (this.logger.level <= 400) {
            this.logger.log("findExternalAddress(" + local + "," + probeAddresses + "," + deliverResultToMe + ")");
        }
        final ArrayList<InetSocketAddress> probeList = new ArrayList<InetSocketAddress>(probeAddresses);
        final AttachableCancellable ret = new AttachableCancellable();
        ret.attach(this.getInetSocketAddressLookup(local, new Continuation<InetSocketAddressLookup, IOException>(){

            @Override
            public void receiveResult(InetSocketAddressLookup lookup) {
                ConnectivityVerifierImpl.this.findExternalNodesHelper(lookup, ret, local, probeList, deliverResultToMe);
            }

            @Override
            public void receiveException(IOException exception) {
                if (ConnectivityVerifierImpl.this.logger.level <= 800) {
                    ConnectivityVerifierImpl.this.logger.log("findExternalAddress(" + local + "," + probeAddresses + "," + deliverResultToMe + ").receiveException(" + exception + ")");
                }
                deliverResultToMe.receiveException(exception);
            }
        }));
        return ret;
    }

    public void findExternalNodesHelper(final InetSocketAddressLookup lookup, final AttachableCancellable ret, final InetSocketAddress local, final List<InetSocketAddress> probeList, final Continuation<Collection<InetSocketAddress>, IOException> deliverResultToMe) {
        if (this.logger.level <= 400) {
            this.logger.log("findExternalNodesHelper(" + lookup + "," + local + "," + probeList + ")");
        }
        InetSocketAddress target = probeList.remove(this.spnf.getEnvironment().getRandomSource().nextInt(probeList.size()));
        ret.attach(lookup.getExternalNodes(target, new Continuation<Collection<InetSocketAddress>, IOException>(){

            @Override
            public void receiveResult(final Collection<InetSocketAddress> result) {
                if (ConnectivityVerifierImpl.this.logger.level <= 800) {
                    ConnectivityVerifierImpl.this.logger.log("findExternalNodesHelper(" + lookup + "," + local + "," + probeList + ").success:" + result);
                }
                ret.cancel();
                lookup.destroy();
                ConnectivityVerifierImpl.this.environment.getSelectorManager().invoke(new Runnable(){

                    public void run() {
                        deliverResultToMe.receiveResult(result);
                    }
                });
            }

            @Override
            public void receiveException(final IOException exception) {
                if (ConnectivityVerifierImpl.this.logger.level <= 800) {
                    ConnectivityVerifierImpl.this.logger.log("findExternalNodesHelper(" + lookup + "," + local + "," + probeList + ").receiveException(" + exception + ")");
                }
                if (probeList.isEmpty()) {
                    lookup.destroy();
                    ConnectivityVerifierImpl.this.environment.getSelectorManager().invoke(new Runnable(){

                        public void run() {
                            deliverResultToMe.receiveException(exception);
                        }
                    });
                    return;
                }
                ConnectivityVerifierImpl.this.findExternalNodesHelper(lookup, ret, local, probeList, deliverResultToMe);
            }
        }, null));
    }

    @Override
    public Cancellable findExternalAddress(final InetSocketAddress local, final Collection<InetSocketAddress> probeAddresses, final Continuation<InetAddress, IOException> deliverResultToMe) {
        if (this.logger.level <= 400) {
            this.logger.log("findExternalAddress(" + local + "," + probeAddresses + "," + deliverResultToMe + ")");
        }
        final ArrayList<InetSocketAddress> probeList = new ArrayList<InetSocketAddress>(probeAddresses);
        final AttachableCancellable ret = new AttachableCancellable();
        ret.attach(this.getInetSocketAddressLookup(local, new Continuation<InetSocketAddressLookup, IOException>(){

            @Override
            public void receiveResult(InetSocketAddressLookup lookup) {
                ConnectivityVerifierImpl.this.findExternalAddressHelper(lookup, ret, local, probeList, deliverResultToMe);
            }

            @Override
            public void receiveException(IOException exception) {
                if (ConnectivityVerifierImpl.this.logger.level <= 800) {
                    ConnectivityVerifierImpl.this.logger.log("findExternalAddress(" + local + "," + probeAddresses + "," + deliverResultToMe + ").receiveException(" + exception + ")");
                }
                deliverResultToMe.receiveException(exception);
            }
        }));
        return ret;
    }

    public void findExternalAddressHelper(final InetSocketAddressLookup lookup, final AttachableCancellable ret, final InetSocketAddress local, final List<InetSocketAddress> probeList, final Continuation<InetAddress, IOException> deliverResultToMe) {
        if (this.logger.level <= 400) {
            this.logger.log("findExternalAddressHelper(" + lookup + "," + local + "," + probeList + ")");
        }
        InetSocketAddress target = probeList.remove(this.spnf.getEnvironment().getRandomSource().nextInt(probeList.size()));
        ret.attach(lookup.getMyInetAddress(target, new Continuation<InetSocketAddress, IOException>(){

            @Override
            public void receiveResult(final InetSocketAddress result) {
                if (ConnectivityVerifierImpl.this.logger.level <= 800) {
                    ConnectivityVerifierImpl.this.logger.log("findExternalAddressHelper(" + lookup + "," + local + "," + probeList + ").success:" + result);
                }
                ret.cancel();
                lookup.destroy();
                ConnectivityVerifierImpl.this.environment.getSelectorManager().invoke(new Runnable(){

                    public void run() {
                        deliverResultToMe.receiveResult(result.getAddress());
                    }
                });
            }

            @Override
            public void receiveException(final IOException exception) {
                if (ConnectivityVerifierImpl.this.logger.level <= 800) {
                    ConnectivityVerifierImpl.this.logger.log("findExternalAddressHelper(" + lookup + "," + local + "," + probeList + ").receiveException(" + exception + ")");
                }
                if (probeList.isEmpty()) {
                    lookup.destroy();
                    ConnectivityVerifierImpl.this.environment.getSelectorManager().invoke(new Runnable(){

                        public void run() {
                            deliverResultToMe.receiveException(exception);
                        }
                    });
                    return;
                }
                ConnectivityVerifierImpl.this.findExternalAddressHelper(lookup, ret, local, probeList, deliverResultToMe);
            }
        }, null));
    }

    @Override
    public Cancellable verifyConnectivity(final MultiInetSocketAddress local, final Collection<InetSocketAddress> probeAddresses, final ConnectivityResult deliverResultToMe) {
        final ArrayList<InetSocketAddress> probeList = new ArrayList<InetSocketAddress>(probeAddresses);
        if (this.logger.level <= 400) {
            this.logger.log("verifyConnectivity(" + local + "," + probeAddresses + ")");
        }
        for (int ctr = 0; ctr < local.getNumAddresses(); ++ctr) {
            probeList.remove(local.getAddress(ctr));
        }
        if (probeList.isEmpty()) {
            if (this.logger.level <= 400) {
                this.logger.log("verifyConnectivity(" + local + "," + probeAddresses + "). no valid addresses");
            }
            deliverResultToMe.receiveException(new IllegalStateException("No valid probe addresses. " + probeAddresses + " local:" + local));
            return null;
        }
        final AttachableCancellable ret = new AttachableCancellable();
        ret.attach(this.getInetSocketAddressLookup(local.getInnermostAddress(), new Continuation<InetSocketAddressLookup, IOException>(){

            @Override
            public void receiveResult(final InetSocketAddressLookup lookup) {
                ret.attach(new Cancellable(){

                    public boolean cancel() {
                        lookup.destroy();
                        return true;
                    }
                });
                ConnectivityVerifierImpl.this.verifyConnectivityHelper(lookup, ret, local, probeList, new ConnectivityResult(){
                    boolean udpSuccess = false;
                    boolean tcpSuccess = false;

                    @Override
                    public void udpSuccess(final InetSocketAddress from, final Map<String, Object> options) {
                        this.udpSuccess = true;
                        if (this.tcpSuccess) {
                            ret.cancel();
                            lookup.destroy();
                        }
                        if (ConnectivityVerifierImpl.this.logger.level <= 800) {
                            ConnectivityVerifierImpl.this.logger.log("verifyConnectivity(" + local + "," + probeAddresses + "). udpSuccess(" + from + ")");
                        }
                        ConnectivityVerifierImpl.this.environment.getSelectorManager().invoke(new Runnable(){

                            public void run() {
                                deliverResultToMe.udpSuccess(from, options);
                            }
                        });
                    }

                    @Override
                    public void tcpSuccess(final InetSocketAddress from, final Map<String, Object> options) {
                        this.tcpSuccess = true;
                        if (this.udpSuccess) {
                            ret.cancel();
                            lookup.destroy();
                        }
                        if (ConnectivityVerifierImpl.this.logger.level <= 800) {
                            ConnectivityVerifierImpl.this.logger.log("verifyConnectivity(" + local + "," + probeAddresses + "). tcpSuccess(" + from + ")");
                        }
                        ConnectivityVerifierImpl.this.environment.getSelectorManager().invoke(new Runnable(){

                            public void run() {
                                deliverResultToMe.tcpSuccess(from, options);
                            }
                        });
                    }

                    @Override
                    public void receiveException(final Exception exception) {
                        if (probeList.isEmpty()) {
                            lookup.destroy();
                            if (ConnectivityVerifierImpl.this.logger.level <= 800) {
                                ConnectivityVerifierImpl.this.logger.log("verifyConnectivity(" + local + "," + probeAddresses + "). failure no more addresses " + exception);
                            }
                            ConnectivityVerifierImpl.this.environment.getSelectorManager().invoke(new Runnable(){

                                public void run() {
                                    deliverResultToMe.receiveException(exception);
                                }
                            });
                            return;
                        }
                        ConnectivityVerifierImpl.this.verifyConnectivityHelper(lookup, ret, local, probeList, deliverResultToMe);
                    }
                });
            }

            @Override
            public void receiveException(IOException exception) {
                if (ConnectivityVerifierImpl.this.logger.level <= 800) {
                    ConnectivityVerifierImpl.this.logger.log("verifyConnectivity(" + local + "," + probeAddresses + "). couldn't get tl " + exception);
                }
                deliverResultToMe.receiveException(exception);
            }
        }));
        return ret;
    }

    public void verifyConnectivityHelper(InetSocketAddressLookup lookup, AttachableCancellable ret, MultiInetSocketAddress local, List<InetSocketAddress> probeList, ConnectivityResult deliverResultToMe) {
        if (this.logger.level <= 800) {
            this.logger.log("verifyConnectivityHelper(" + local + "," + probeList + ")");
        }
        InetSocketAddress target = probeList.remove(this.spnf.getEnvironment().getRandomSource().nextInt(probeList.size()));
        ret.attach(lookup.verifyConnectivity(local, target, deliverResultToMe, null));
    }
}

