/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.appsocket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import org.mpisws.p2p.transport.ClosedChannelException;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.liveness.LivenessListener;
import org.mpisws.p2p.transport.liveness.LivenessProvider;
import org.mpisws.p2p.transport.liveness.OverrideLiveness;
import org.mpisws.p2p.transport.liveness.PingListener;
import org.mpisws.p2p.transport.liveness.Pinger;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.sourceroute.SourceRoute;
import org.mpisws.p2p.transport.util.OptionsFactory;
import org.mpisws.p2p.transport.util.SocketRequestHandleImpl;
import org.mpisws.p2p.transport.wire.SocketManager;
import org.mpisws.p2p.transport.wire.WireTransportLayerImpl;
import rice.Continuation;
import rice.environment.Environment;
import rice.p2p.commonapi.Cancellable;
import rice.p2p.commonapi.appsocket.AppSocket;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.util.MathUtils;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeIdFactory;
import rice.pastry.socket.SocketNodeHandleFactory;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.socket.TransportLayerNodeHandle;
import rice.pastry.socket.appsocket.SocketFactory;
import rice.pastry.transport.NodeHandleAdapter;
import rice.pastry.transport.SocketAdapter;
import rice.pastry.transport.TLDeserializer;
import rice.pastry.transport.TLPastryNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppSocketPastryNodeFactory
extends SocketPastryNodeFactory {
    protected Map<Integer, SocketManager> socketTable = new HashMap<Integer, SocketManager>();
    public static final String STORE_SOCKET = "store_socket";
    SocketFactory sf;
    public static final String SOCKET_FACTORY_UID = "appSocketFactory.uid";

    public AppSocketPastryNodeFactory(NodeIdFactory nf, int startPort, Environment env) throws IOException {
        super(nf, startPort, env);
    }

    public AppSocketPastryNodeFactory(NodeIdFactory nf, InetAddress bindAddress, int startPort, Environment env) throws IOException {
        super(nf, bindAddress, startPort, env);
    }

    public synchronized SocketFactory getSocketFactory() throws IOException {
        if (this.sf != null) {
            return this.sf;
        }
        Id nodeId = Id.build();
        BogusTLPastryNode pn = new BogusTLPastryNode(nodeId, this.environment);
        final SocketNodeHandleFactory handleFactory = (SocketNodeHandleFactory)this.getNodeHandleFactory(pn);
        NodeHandle localhandle = this.getLocalHandle(pn, handleFactory);
        pn.setLocalHandle(localhandle);
        TLDeserializer deserializer = this.getTLDeserializer(handleFactory, pn);
        final NodeHandleAdapter nha = this.getNodeHandleAdapter(pn, handleFactory, deserializer);
        this.sf = new SocketFactory(){
            int uid = Integer.MIN_VALUE;

            @Override
            public Cancellable getAppSocket(InetSocketAddress addr, int appid, final Continuation<AppSocket, Exception> c, Map<String, Object> options) {
                return this.getSocket(addr, appid, new Continuation<P2PSocket<TransportLayerNodeHandle<MultiInetSocketAddress>>, Exception>(){

                    @Override
                    public void receiveException(Exception exception) {
                        c.receiveException(exception);
                    }

                    @Override
                    public void receiveResult(P2PSocket<TransportLayerNodeHandle<MultiInetSocketAddress>> result) {
                        c.receiveResult(new SocketAdapter<TransportLayerNodeHandle<MultiInetSocketAddress>>(result, AppSocketPastryNodeFactory.this.environment));
                    }
                }, options);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Cancellable getSocketChannel(InetSocketAddress addr, int appid, final Continuation<SocketChannel, Exception> c, Map<String, Object> options) {
                int myUid;
                1 var6_5 = this;
                synchronized (var6_5) {
                    myUid = this.uid++;
                }
                options = OptionsFactory.addOption(options, AppSocketPastryNodeFactory.STORE_SOCKET, myUid);
                return this.getSocket(addr, appid, new Continuation<P2PSocket<TransportLayerNodeHandle<MultiInetSocketAddress>>, Exception>(){

                    @Override
                    public void receiveException(Exception exception) {
                        c.receiveException(exception);
                    }

                    @Override
                    public void receiveResult(P2PSocket<TransportLayerNodeHandle<MultiInetSocketAddress>> result) {
                        SocketManager sm = AppSocketPastryNodeFactory.this.socketTable.remove(myUid);
                        SocketChannel ret = sm.getSocketChannel();
                        c.receiveResult(ret);
                    }
                }, options);
            }

            protected Cancellable getSocket(InetSocketAddress addr, final int appid, final Continuation<P2PSocket<TransportLayerNodeHandle<MultiInetSocketAddress>>, Exception> c, Map<String, Object> options) {
                TransportLayerNodeHandle<MultiInetSocketAddress> handle = this.getHandle(addr);
                final SocketRequestHandleImpl<TransportLayerNodeHandle<MultiInetSocketAddress>> ret = new SocketRequestHandleImpl<TransportLayerNodeHandle<MultiInetSocketAddress>>(handle, options, AppSocketPastryNodeFactory.this.logger);
                options = OptionsFactory.addOption(options, "identity.dont_verify_dest", true);
                ret.setSubCancellable(this.getTL().openSocket(handle, new SocketCallback<TransportLayerNodeHandle<MultiInetSocketAddress>>(){

                    @Override
                    public void receiveResult(SocketRequestHandle<TransportLayerNodeHandle<MultiInetSocketAddress>> cancellable, final P2PSocket<TransportLayerNodeHandle<MultiInetSocketAddress>> sock) {
                        ret.setSubCancellable(new Cancellable(){

                            public boolean cancel() {
                                sock.close();
                                return true;
                            }
                        });
                        try {
                            new P2PSocketReceiver<TransportLayerNodeHandle<MultiInetSocketAddress>>(){
                                ByteBuffer buf;
                                {
                                    byte[] idBytes = MathUtils.intToByteArray(appid);
                                    this.buf = ByteBuffer.wrap(idBytes);
                                }

                                @Override
                                public void receiveSelectResult(P2PSocket<TransportLayerNodeHandle<MultiInetSocketAddress>> socket, boolean canRead, boolean canWrite) throws IOException {
                                    if (socket.write(this.buf) < 0L) {
                                        c.receiveException(new ClosedChannelException("Socket was closed by remote host. " + socket));
                                        return;
                                    }
                                    if (this.buf.hasRemaining()) {
                                        socket.register(false, true, this);
                                        return;
                                    }
                                    c.receiveResult(socket);
                                }

                                @Override
                                public void receiveException(P2PSocket<TransportLayerNodeHandle<MultiInetSocketAddress>> socket, Exception ioe) {
                                    c.receiveException(ioe);
                                }
                            }.receiveSelectResult(sock, false, true);
                        }
                        catch (IOException ioe) {
                            c.receiveException(ioe);
                        }
                    }

                    @Override
                    public void receiveException(SocketRequestHandle<TransportLayerNodeHandle<MultiInetSocketAddress>> s, Exception ex) {
                    }
                }, options));
                return ret;
            }

            public TransportLayerNodeHandle<MultiInetSocketAddress> getHandle(InetSocketAddress addr) {
                return handleFactory.getNodeHandle(new MultiInetSocketAddress(addr), -1L, Id.build());
            }

            public TransportLayer<TransportLayerNodeHandle<MultiInetSocketAddress>, RawMessage> getTL() {
                return nha.getTL();
            }
        };
        return this.sf;
    }

    @Override
    protected TransportLayer<InetSocketAddress, ByteBuffer> getWireTransportLayer(InetSocketAddress innermostAddress, TLPastryNode pn) throws IOException {
        Environment environment = pn.getEnvironment();
        WireTransportLayerImpl wtl = new WireTransportLayerImpl(innermostAddress, environment, null, pn instanceof BogusTLPastryNode);
        wtl.addSocketCountListener(this.getSocketCountListener(pn));
        if (pn instanceof BogusTLPastryNode) {
            return ((BogusTLPastryNode)pn).getWireTransportLayer(wtl);
        }
        return wtl;
    }

    @Override
    protected SocketPastryNodeFactory.TransLiveness<SourceRoute<MultiInetSocketAddress>, ByteBuffer> getLivenessTransportLayer(final TransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> tl, TLPastryNode pn) {
        if (pn instanceof BogusTLPastryNode) {
            return new SocketPastryNodeFactory.TransLiveness<SourceRoute<MultiInetSocketAddress>, ByteBuffer>(){

                @Override
                public TransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> getTransportLayer() {
                    return tl;
                }

                @Override
                public LivenessProvider<SourceRoute<MultiInetSocketAddress>> getLivenessProvider() {
                    return new LivenessProvider<SourceRoute<MultiInetSocketAddress>>(){

                        @Override
                        public void addLivenessListener(LivenessListener<SourceRoute<MultiInetSocketAddress>> name) {
                        }

                        @Override
                        public boolean checkLiveness(SourceRoute<MultiInetSocketAddress> i, Map<String, Object> options) {
                            return false;
                        }

                        @Override
                        public void clearState(SourceRoute<MultiInetSocketAddress> i) {
                        }

                        @Override
                        public int getLiveness(SourceRoute<MultiInetSocketAddress> i, Map<String, Object> options) {
                            return 1;
                        }

                        @Override
                        public boolean removeLivenessListener(LivenessListener<SourceRoute<MultiInetSocketAddress>> name) {
                            return false;
                        }
                    };
                }

                @Override
                public OverrideLiveness<SourceRoute<MultiInetSocketAddress>> getOverrideLiveness() {
                    return new OverrideLiveness<SourceRoute<MultiInetSocketAddress>>(){

                        @Override
                        public void setLiveness(SourceRoute<MultiInetSocketAddress> i, int liveness, Map<String, Object> options) {
                        }
                    };
                }

                @Override
                public Pinger<SourceRoute<MultiInetSocketAddress>> getPinger() {
                    return new Pinger<SourceRoute<MultiInetSocketAddress>>(){

                        @Override
                        public void addPingListener(PingListener<SourceRoute<MultiInetSocketAddress>> name) {
                        }

                        @Override
                        public boolean ping(SourceRoute<MultiInetSocketAddress> i, Map<String, Object> options) {
                            return false;
                        }

                        @Override
                        public boolean removePingListener(PingListener<SourceRoute<MultiInetSocketAddress>> name) {
                            return false;
                        }
                    };
                }
            };
        }
        return super.getLivenessTransportLayer(tl, pn);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BogusTLPastryNode
    extends TLPastryNode {
        public BogusTLPastryNode(Id id, Environment e) {
            super(id, e);
        }

        public TransportLayer<InetSocketAddress, ByteBuffer> getWireTransportLayer(WireTransportLayerImpl wtl) {
            return new AppSocketFactoryLayer(wtl);
        }

        public void setLocalHandle(NodeHandle localhandle) {
            this.localhandle = localhandle;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AppSocketFactoryLayer
    implements TransportLayer<InetSocketAddress, ByteBuffer>,
    TransportLayerCallback<InetSocketAddress, ByteBuffer> {
        protected WireTransportLayerImpl wtl;
        private TransportLayerCallback<InetSocketAddress, ByteBuffer> callback;

        public AppSocketFactoryLayer(WireTransportLayerImpl wtl) {
            this.wtl = wtl;
            this.wtl.setCallback(this);
        }

        @Override
        public void acceptMessages(boolean b) {
            this.wtl.acceptMessages(b);
        }

        @Override
        public void acceptSockets(boolean b) {
            this.wtl.acceptSockets(b);
        }

        @Override
        public InetSocketAddress getLocalIdentifier() {
            return this.wtl.getLocalIdentifier();
        }

        @Override
        public SocketRequestHandle<InetSocketAddress> openSocket(InetSocketAddress i, final SocketCallback<InetSocketAddress> deliverSocketToMe, final Map<String, Object> options) {
            return this.wtl.openSocket(i, new SocketCallback<InetSocketAddress>(){

                @Override
                public void receiveResult(SocketRequestHandle<InetSocketAddress> cancellable, P2PSocket<InetSocketAddress> sock) {
                    SocketManager sa = (SocketManager)sock;
                    if (options.containsKey(AppSocketPastryNodeFactory.STORE_SOCKET)) {
                        AppSocketPastryNodeFactory.this.socketTable.put((Integer)options.get(AppSocketPastryNodeFactory.STORE_SOCKET), sa);
                    }
                    deliverSocketToMe.receiveResult(cancellable, sock);
                }

                @Override
                public void receiveException(SocketRequestHandle<InetSocketAddress> s, Exception ex) {
                    deliverSocketToMe.receiveException(s, ex);
                }
            }, options);
        }

        @Override
        public MessageRequestHandle<InetSocketAddress, ByteBuffer> sendMessage(InetSocketAddress i, ByteBuffer m, MessageCallback<InetSocketAddress, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
            return this.wtl.sendMessage(i, m, deliverAckToMe, options);
        }

        @Override
        public void setCallback(TransportLayerCallback<InetSocketAddress, ByteBuffer> callback) {
            this.callback = callback;
        }

        @Override
        public void setErrorHandler(ErrorHandler<InetSocketAddress> handler) {
        }

        @Override
        public void incomingSocket(P2PSocket<InetSocketAddress> s) throws IOException {
            this.callback.incomingSocket(s);
        }

        @Override
        public void messageReceived(InetSocketAddress i, ByteBuffer m, Map<String, Object> options) throws IOException {
            this.callback.messageReceived(i, m, options);
        }

        @Override
        public void destroy() {
        }
    }
}

