/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Observable;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.Id;
import rice.pastry.dist.DistNodeHandle;
import rice.pastry.messaging.Message;
import rice.pastry.transport.TLPastryNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketNodeHandle
extends DistNodeHandle<MultiInetSocketAddress> {
    public MultiInetSocketAddress eaddress;
    long epoch;

    protected SocketNodeHandle(MultiInetSocketAddress eisa, long epoch, Id id, TLPastryNode node) {
        super(id);
        this.eaddress = eisa;
        this.epoch = epoch;
        this.setLocalNode(node);
    }

    @Override
    public long getEpoch() {
        return this.epoch;
    }

    public void setLocalNode(TLPastryNode pn) {
        this.localnode = pn;
        this.logger = this.localnode.getEnvironment().getLogManager().getLogger(this.getClass(), null);
    }

    public MultiInetSocketAddress getIdentifier() {
        return this.eaddress;
    }

    @Override
    public int getLiveness() {
        if (this.isLocal()) {
            return 1;
        }
        return ((TLPastryNode)this.localnode).getLivenessProvider().getLiveness(this, null);
    }

    @Override
    public MultiInetSocketAddress getAddress() {
        return this.eaddress;
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        return this.eaddress.getAddress(0);
    }

    @Override
    public boolean checkLiveness() {
        if (this.logger.level <= 500) {
            this.logger.log(this + ".checkLiveness()");
        }
        ((TLPastryNode)this.localnode).getLivenessProvider().checkLiveness(this, null);
        return this.isAlive();
    }

    public boolean isLocal() {
        this.assertLocalNode();
        return this.getLocalNode().getLocalHandle().equals(this);
    }

    @Override
    public void receiveMessage(Message msg) {
        this.assertLocalNode();
        HashMap<String, Object> options = new HashMap<String, Object>(1);
        options.put("OPTION_PRIORITY", msg.getPriority());
        this.getLocalNode().send(this, msg, null, options);
    }

    @Override
    public String toString() {
        return "[SNH: " + this.nodeId + "/" + this.eaddress + "]";
    }

    public String toStringFull() {
        return "[SNH: " + this.nodeId + "/" + this.eaddress + " " + this.epoch + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SocketNodeHandle)) {
            return false;
        }
        SocketNodeHandle other = (SocketNodeHandle)obj;
        boolean ret = this.epoch == other.epoch && other.getNodeId().equals(this.getNodeId()) && other.eaddress.equals(this.eaddress);
        return ret;
    }

    @Override
    public int hashCode() {
        int hash = (int)this.epoch ^ this.getNodeId().hashCode() ^ this.eaddress.hashCode();
        return hash;
    }

    @Override
    public int proximity() {
        return ((TLPastryNode)this.localnode).getProxProvider().proximity(this, null);
    }

    @Override
    public boolean ping() {
        if (this.localnode.getLocalHandle().equals(this)) {
            return false;
        }
        ((TLPastryNode)this.localnode).getLivenessProvider().checkLiveness(this, null);
        return this.isAlive();
    }

    @Override
    public void update(Observable o, Object obj) {
    }

    static SocketNodeHandle build(InputBuffer buf, TLPastryNode local) throws IOException {
        MultiInetSocketAddress eaddr = MultiInetSocketAddress.build(buf);
        long epoch = buf.readLong();
        Id nid = Id.build(buf);
        return new SocketNodeHandle(eaddr, epoch, nid, local);
    }

    @Override
    public void serialize(OutputBuffer buf) throws IOException {
        this.eaddress.serialize(buf);
        buf.writeLong(this.epoch);
        this.nodeId.serialize(buf);
    }
}

