/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.mpisws.p2p.transport.identity.IdentitySerializer;
import org.mpisws.p2p.transport.identity.SerializerListener;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.sourceroute.SourceRoute;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.Id;
import rice.pastry.NodeHandleFactoryListener;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketNodeHandleFactory;
import rice.pastry.socket.TransportLayerNodeHandle;
import rice.pastry.transport.TLPastryNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPNFIdentitySerializer
implements IdentitySerializer<TransportLayerNodeHandle<MultiInetSocketAddress>, MultiInetSocketAddress, SourceRoute<MultiInetSocketAddress>> {
    protected TLPastryNode pn;
    protected SocketNodeHandleFactory factory;
    Map<SerializerListener<TransportLayerNodeHandle<MultiInetSocketAddress>>, NodeHandleFactoryListener<SocketNodeHandle>> listeners = new HashMap<SerializerListener<TransportLayerNodeHandle<MultiInetSocketAddress>>, NodeHandleFactoryListener<SocketNodeHandle>>();

    public SPNFIdentitySerializer(TLPastryNode pn, SocketNodeHandleFactory factory) {
        this.pn = pn;
        this.factory = factory;
    }

    @Override
    public void serialize(OutputBuffer buf, TransportLayerNodeHandle<MultiInetSocketAddress> i) throws IOException {
        long epoch = i.getEpoch();
        Id nid = (Id)i.getId();
        buf.writeLong(epoch);
        nid.serialize(buf);
    }

    @Override
    public TransportLayerNodeHandle<MultiInetSocketAddress> deserialize(InputBuffer buf, SourceRoute<MultiInetSocketAddress> i) throws IOException {
        long epoch = buf.readLong();
        Id nid = Id.build(buf);
        SocketNodeHandle ret = this.buildSNH(buf, i.getLastHop(), epoch, nid);
        return this.factory.coalesce(ret);
    }

    protected SocketNodeHandle buildSNH(InputBuffer buf, MultiInetSocketAddress i, long epoch, Id nid) throws IOException {
        return new SocketNodeHandle(i, epoch, nid, this.pn);
    }

    @Override
    public MultiInetSocketAddress translateDown(TransportLayerNodeHandle<MultiInetSocketAddress> i) {
        return i.getAddress();
    }

    @Override
    public MultiInetSocketAddress translateUp(SourceRoute<MultiInetSocketAddress> i) {
        return i.getLastHop();
    }

    @Override
    public void addSerializerListener(final SerializerListener<TransportLayerNodeHandle<MultiInetSocketAddress>> listener) {
        NodeHandleFactoryListener<SocketNodeHandle> foo = new NodeHandleFactoryListener<SocketNodeHandle>(){

            @Override
            public void nodeHandleFound(SocketNodeHandle nodeHandle) {
                listener.nodeHandleFound(nodeHandle);
            }
        };
        this.listeners.put(listener, foo);
        this.factory.addNodeHandleFactoryListener(foo);
    }

    @Override
    public void removeSerializerListener(SerializerListener<TransportLayerNodeHandle<MultiInetSocketAddress>> listener) {
        this.factory.removeNodeHandleFactoryListener(this.listeners.get(listener));
    }
}

