/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.pns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mpisws.p2p.transport.proximity.ProximityListener;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.Cancellable;
import rice.p2p.commonapi.exception.TimeoutException;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.util.AttachableCancellable;
import rice.p2p.util.tuples.MutableTuple;
import rice.p2p.util.tuples.Tuple;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.pns.messages.LeafSetRequest;
import rice.pastry.pns.messages.LeafSetResponse;
import rice.pastry.pns.messages.RouteRowRequest;
import rice.pastry.pns.messages.RouteRowResponse;
import rice.pastry.routing.RouteSet;
import rice.pastry.standard.ProximityNeighborSelector;
import rice.pastry.transport.PMessageNotification;
import rice.pastry.transport.PMessageReceipt;
import rice.selector.Timer;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PNSApplication
extends PastryAppl
implements ProximityNeighborSelector,
ProximityListener<NodeHandle> {
    public static final int DEFAULT_PROXIMITY = 3600000;
    protected Map<NodeHandle, Integer> pingCache = new HashMap<NodeHandle, Integer>();
    protected final byte rtBase;
    protected Environment environment;
    protected Timer timer;
    final short depth;
    Map<NodeHandle, Collection<Tuple<Continuation<LeafSet, Exception>, Cancellable>>> waitingForLeafSet = new HashMap<NodeHandle, Collection<Tuple<Continuation<LeafSet, Exception>, Cancellable>>>();
    Map<NodeHandle, Collection<Tuple<Continuation<RouteSet[], Exception>, Cancellable>>[]> waitingForRouteRow = new HashMap<NodeHandle, Collection<Tuple<Continuation<RouteSet[], Exception>, Cancellable>>[]>();
    Map<NodeHandle, Collection<Continuation<Integer, IOException>>> waitingForPing = new HashMap<NodeHandle, Collection<Continuation<Integer, IOException>>>();

    public PNSApplication(PastryNode pn) {
        this(pn, pn.getEnvironment().getLogManager().getLogger(PNSApplication.class, null));
    }

    public PNSApplication(PastryNode pn, Logger logger) {
        super(pn, null, 0, null, logger);
        this.setDeserializer(new PNSDeserializer());
        this.environment = pn.getEnvironment();
        this.rtBase = (byte)this.environment.getParameters().getInt("pastry_rtBaseBitLength");
        this.depth = (short)(160 / this.rtBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageForAppl(Message msg) {
        if (this.logger.level <= 400) {
            this.logger.log("messageForAppl(" + msg + ")");
        }
        if (msg instanceof LeafSetRequest) {
            LeafSetRequest req = (LeafSetRequest)msg;
            this.thePastryNode.send(req.getSender(), new LeafSetResponse(this.thePastryNode.getLeafSet(), this.getAddress()), null, null);
            return;
        }
        if (msg instanceof LeafSetResponse) {
            LeafSetResponse response = (LeafSetResponse)msg;
            Map<NodeHandle, Collection<Tuple<Continuation<LeafSet, Exception>, Cancellable>>> map = this.waitingForLeafSet;
            synchronized (map) {
                LeafSet ls = response.leafset;
                Collection<Tuple<Continuation<LeafSet, Exception>, Cancellable>> waiters = this.waitingForLeafSet.remove(ls.get(0));
                if (waiters != null) {
                    for (Tuple<Continuation<LeafSet, Exception>, Cancellable> w : waiters) {
                        w.b().cancel();
                        w.a().receiveResult(ls);
                    }
                }
            }
            return;
        }
        if (msg instanceof RouteRowRequest) {
            RouteRowRequest req = (RouteRowRequest)msg;
            this.thePastryNode.send(req.getSender(), new RouteRowResponse(this.thePastryNode.getLocalHandle(), req.index, this.thePastryNode.getRoutingTable().getRow(req.index), this.getAddress()), null, null);
            return;
        }
        if (msg instanceof RouteRowResponse) {
            RouteRowResponse response = (RouteRowResponse)msg;
            Map<NodeHandle, Collection<Tuple<Continuation<RouteSet[], Exception>, Cancellable>>[]> map = this.waitingForRouteRow;
            synchronized (map) {
                Collection<Tuple<Continuation<RouteSet[], Exception>, Cancellable>>[] waiters = this.waitingForRouteRow.get(response.getSender());
                if (waiters != null && waiters[response.index] != null) {
                    for (Tuple<Continuation<RouteSet[], Exception>, Cancellable> w : new ArrayList<Tuple<Continuation<RouteSet[], Exception>, Cancellable>>(waiters[response.index])) {
                        w.b().cancel();
                        w.a().receiveResult(response.row);
                    }
                    waiters[response.index].clear();
                    waiters[response.index] = null;
                    boolean deleteIt = true;
                    for (int i = 0; i < this.depth; ++i) {
                        if (waiters[i] == null) continue;
                        deleteIt = false;
                        break;
                    }
                    if (deleteIt) {
                        this.waitingForRouteRow.remove(response.getSender());
                    }
                }
            }
            return;
        }
        if (this.logger.level <= 900) {
            this.logger.log("unrecognized message in messageForAppl(" + msg + ")");
        }
    }

    @Override
    public Cancellable getNearHandles(final Collection<NodeHandle> bootHandles, final Continuation<Collection<NodeHandle>, Exception> deliverResultToMe) {
        if (bootHandles == null || bootHandles.size() == 0 || bootHandles.iterator().next() == null) {
            deliverResultToMe.receiveResult(bootHandles);
            return null;
        }
        final AttachableCancellable ret = new AttachableCancellable();
        final HashSet<NodeHandle> remaining = new HashSet<NodeHandle>(bootHandles);
        this.thePastryNode.addProximityListener(this);
        final MutableTuple best = new MutableTuple();
        Iterator<NodeHandle> i$ = bootHandles.iterator();
        while (i$.hasNext()) {
            NodeHandle nh;
            final NodeHandle handle = nh = i$.next();
            Continuation<Integer, IOException> c = new Continuation<Integer, IOException>(){

                @Override
                public void receiveResult(Integer result) {
                    if (((PNSApplication)PNSApplication.this).logger.level <= 500) {
                        PNSApplication.this.logger.log("got proximity for " + handle + " in getNearHandles()");
                    }
                    if (best.a() != null && PNSApplication.this.pingCache.get(best.a()) < result) {
                        return;
                    }
                    if (best.b() != null) {
                        ((Cancellable)best.b()).cancel();
                    }
                    Cancellable cancellable = PNSApplication.this.getNearest(handle, new Continuation<Collection<NodeHandle>, Exception>(){

                        @Override
                        public void receiveResult(Collection<NodeHandle> result) {
                            if (((PNSApplication)PNSApplication.this).logger.level <= 500) {
                                PNSApplication.this.logger.log("receiveResult(" + result + ") in getNearHandles()");
                            }
                            ret.cancel();
                            this.finish();
                        }

                        @Override
                        public void receiveException(Exception exception) {
                            PNSApplication.this.logger.logException("PNS got an exception in getNearHandles() returning what we got.", exception);
                            this.finish();
                        }

                        public void finish() {
                            PNSApplication.this.thePastryNode.removeProximityListener(PNSApplication.this);
                            List<NodeHandle> ret = PNSApplication.this.sortedProximityCache();
                            PNSApplication.this.purgeProximityCache();
                            if (((PNSApplication)PNSApplication.this).logger.level <= 800) {
                                PNSApplication.this.logger.log("getNearHandles(" + bootHandles + "):" + ret.size() + ret);
                            }
                            deliverResultToMe.receiveResult(PNSApplication.this.getNearHandlesHelper(ret));
                        }
                    });
                    ret.attach(cancellable);
                    best.set(handle, cancellable);
                }

                @Override
                public void receiveException(IOException exception) {
                    remaining.remove(handle);
                }
            };
            this.getProximity(handle, c, 10000);
        }
        return ret;
    }

    protected List<NodeHandle> getNearHandlesHelper(List<NodeHandle> handles) {
        return handles;
    }

    public Cancellable getLeafSet(final NodeHandle handle, final Continuation<LeafSet, Exception> c) {
        final AttachableCancellable cancellable = new AttachableCancellable(){

            public boolean cancel() {
                PNSApplication.this.removeFromWaitingForLeafSet(handle, c);
                super.cancel();
                return true;
            }
        };
        TimerTask task = new TimerTask(){

            public void run() {
                cancellable.cancel();
                c.receiveException(new TimeoutException("Ping to " + handle + " timed out."));
            }
        };
        this.addToWaitingForLeafSet(handle, c, task);
        cancellable.attach(task);
        cancellable.attach(this.thePastryNode.send(handle, new LeafSetRequest(this.getNodeHandle(), this.getAddress()), new PMessageNotification(){

            public void sent(PMessageReceipt msg) {
            }

            public void sendFailed(PMessageReceipt msg, Exception reason) {
                cancellable.cancel();
                c.receiveException(reason);
            }
        }, null));
        return cancellable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToWaitingForLeafSet(NodeHandle handle, Continuation<LeafSet, Exception> c, Cancellable cancelMeWhenSuccess) {
        Map<NodeHandle, Collection<Tuple<Continuation<LeafSet, Exception>, Cancellable>>> map = this.waitingForLeafSet;
        synchronized (map) {
            Collection<Tuple<Continuation<LeafSet, Exception>, Cancellable>> waiters = this.waitingForLeafSet.get(handle);
            if (waiters == null) {
                waiters = new ArrayList<Tuple<Continuation<LeafSet, Exception>, Cancellable>>();
                this.waitingForLeafSet.put(handle, waiters);
            }
            waiters.add(new Tuple<Continuation<LeafSet, Exception>, Cancellable>(c, cancelMeWhenSuccess));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeFromWaitingForLeafSet(NodeHandle handle, Continuation<LeafSet, Exception> c) {
        Map<NodeHandle, Collection<Tuple<Continuation<LeafSet, Exception>, Cancellable>>> map = this.waitingForLeafSet;
        synchronized (map) {
            Collection<Tuple<Continuation<LeafSet, Exception>, Cancellable>> waiters = this.waitingForLeafSet.get(handle);
            if (waiters == null) {
                return false;
            }
            boolean ret = false;
            Iterator<Tuple<Continuation<LeafSet, Exception>, Cancellable>> i = waiters.iterator();
            while (i.hasNext()) {
                Tuple<Continuation<LeafSet, Exception>, Cancellable> foo = i.next();
                if (!foo.a().equals(c)) continue;
                ret = true;
                foo.b().cancel();
                i.remove();
            }
            if (waiters.isEmpty()) {
                this.waitingForLeafSet.remove(handle);
            }
            return ret;
        }
    }

    public Cancellable getRouteRow(final NodeHandle handle, final short row, final Continuation<RouteSet[], Exception> c) {
        final AttachableCancellable cancellable = new AttachableCancellable(){

            public boolean cancel() {
                PNSApplication.this.removeFromWaitingForRouteRow(handle, row, c);
                super.cancel();
                return true;
            }
        };
        TimerTask task = new TimerTask(){

            public void run() {
                cancellable.cancel();
                c.receiveException(new TimeoutException("Ping to " + handle + " timed out."));
            }
        };
        this.addToWaitingForRouteRow(handle, row, c, task);
        cancellable.attach(task);
        cancellable.attach(this.thePastryNode.send(handle, new RouteRowRequest(this.getNodeHandle(), row, this.getAddress()), new PMessageNotification(){

            public void sent(PMessageReceipt msg) {
            }

            public void sendFailed(PMessageReceipt msg, Exception reason) {
                cancellable.cancel();
                c.receiveException(reason);
            }
        }, null));
        return cancellable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToWaitingForRouteRow(NodeHandle handle, int row, Continuation<RouteSet[], Exception> c, Cancellable cancelMeWhenSuccess) {
        Map<NodeHandle, Collection<Tuple<Continuation<RouteSet[], Exception>, Cancellable>>[]> map = this.waitingForRouteRow;
        synchronized (map) {
            Collection<Tuple<Continuation<RouteSet[], Exception>, Cancellable>>[] waiters = this.waitingForRouteRow.get(handle);
            if (waiters == null) {
                waiters = new Collection[this.depth];
                this.waitingForRouteRow.put(handle, waiters);
            }
            if (waiters[row] == null) {
                waiters[row] = new ArrayList<Tuple<Continuation<RouteSet[], Exception>, Cancellable>>();
            }
            waiters[row].add(new Tuple<Continuation<RouteSet[], Exception>, Cancellable>(c, cancelMeWhenSuccess));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeFromWaitingForRouteRow(NodeHandle handle, int row, Continuation<RouteSet[], Exception> c) {
        Map<NodeHandle, Collection<Tuple<Continuation<RouteSet[], Exception>, Cancellable>>[]> map = this.waitingForRouteRow;
        synchronized (map) {
            Collection<Tuple<Continuation<RouteSet[], Exception>, Cancellable>>[] waiters = this.waitingForRouteRow.get(handle);
            if (waiters == null) {
                return false;
            }
            if (waiters[row] == null) {
                return false;
            }
            boolean ret = false;
            Iterator<Tuple<Continuation<RouteSet[], Exception>, Cancellable>> it = waiters[row].iterator();
            while (it.hasNext()) {
                Tuple<Continuation<RouteSet[], Exception>, Cancellable> foo = it.next();
                if (!foo.a().equals(c)) continue;
                ret = true;
                foo.b().cancel();
                it.remove();
            }
            if (waiters[row].isEmpty()) {
                waiters[row] = null;
            }
            boolean deleteIt = true;
            for (int i = 0; i < this.depth; ++i) {
                if (waiters[i] == null) continue;
                deleteIt = false;
                break;
            }
            if (deleteIt) {
                this.waitingForRouteRow.remove(handle);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cancellable getProximity(final NodeHandle handle, final Continuation<Integer, IOException> c, int timeout) {
        int prox;
        if (this.logger.level <= 300) {
            this.logger.log("getProximity(" + handle + ")");
        }
        Map<NodeHandle, Object> map = this.waitingForPing;
        synchronized (map) {
            prox = this.thePastryNode.proximity(handle);
            if (prox == 3600000) {
                Collection<Continuation<Integer, IOException>> waiters;
                if (this.logger.level <= 500) {
                    this.logger.log("getProximity(" + handle + "): waiting for proximity update");
                }
                if ((waiters = this.waitingForPing.get(handle)) == null) {
                    waiters = new ArrayList<Continuation<Integer, IOException>>();
                    this.waitingForPing.put(handle, waiters);
                }
                waiters.add(c);
                final AttachableCancellable cancellable = new AttachableCancellable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean cancel() {
                        Map<NodeHandle, Collection<Continuation<Integer, IOException>>> map = PNSApplication.this.waitingForPing;
                        synchronized (map) {
                            Collection<Continuation<Integer, IOException>> waiters = PNSApplication.this.waitingForPing.get(handle);
                            if (waiters != null) {
                                waiters.remove(c);
                                if (waiters.isEmpty()) {
                                    PNSApplication.this.waitingForPing.remove(handle);
                                }
                            }
                        }
                        super.cancel();
                        return true;
                    }
                };
                TimerTask task = new TimerTask(){

                    public void run() {
                        cancellable.cancel();
                        c.receiveException(new TimeoutException("Ping to " + handle + " timed out."));
                    }
                };
                cancellable.attach(task);
                this.environment.getSelectorManager().schedule(task, timeout);
                return cancellable;
            }
        }
        map = this.pingCache;
        synchronized (map) {
            this.pingCache.put(handle, prox);
        }
        c.receiveResult(prox);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void proximityChanged(NodeHandle i, int newProximity, Map<String, Object> options) {
        if (this.logger.level <= 500) {
            this.logger.log("proximityChanged(" + i + "," + newProximity + ")");
        }
        Map<NodeHandle, Object> map = this.pingCache;
        synchronized (map) {
            this.pingCache.put(i, newProximity);
        }
        map = this.waitingForPing;
        synchronized (map) {
            if (this.waitingForPing.containsKey(i)) {
                Collection<Continuation<Integer, IOException>> waiting = this.waitingForPing.remove(i);
                for (Continuation<Integer, IOException> c : waiting) {
                    c.receiveResult(newProximity);
                }
            }
        }
    }

    private void purgeProximityCache() {
        this.pingCache.clear();
    }

    public List<NodeHandle> sortedProximityCache() {
        ArrayList<NodeHandle> handles = new ArrayList<NodeHandle>(this.pingCache.keySet());
        Collections.sort(handles, new Comparator<NodeHandle>(){

            @Override
            public int compare(NodeHandle a, NodeHandle b) {
                return PNSApplication.this.pingCache.get(a) - PNSApplication.this.pingCache.get(b);
            }
        });
        return handles;
    }

    public Cancellable getNearest(final NodeHandle seed, final Continuation<Collection<NodeHandle>, Exception> retToMe) {
        if (this.logger.level <= 500) {
            this.logger.log("getNearest(" + seed + ")");
        }
        if (seed == null) {
            if (this.logger.level <= 900) {
                this.logger.logException("getNearest(" + seed + ")", new Exception("Stack Trace"));
            }
            this.environment.getSelectorManager().invoke(new Runnable(){

                public void run() {
                    retToMe.receiveResult(null);
                }
            });
            return null;
        }
        final AttachableCancellable ret = new AttachableCancellable();
        ret.attach(this.getLeafSet(seed, new Continuation<LeafSet, Exception>(){

            @Override
            public void receiveResult(LeafSet result) {
                if (((PNSApplication)PNSApplication.this).logger.level <= 500) {
                    PNSApplication.this.logger.log("getNearest(" + seed + ") got " + result);
                }
                NodeHandle nearNode = seed;
                NodeHandle currentClosest = seed;
                ret.attach(PNSApplication.this.closestToMe(nearNode, result, (Continuation<NodeHandle, Exception>)new Continuation<NodeHandle, Exception>(){

                    @Override
                    public void receiveResult(NodeHandle result) {
                        NodeHandle nearNode = result;
                        short i = 0;
                        if (!PNSApplication.this.environment.getParameters().getString("pns_num_rows_to_use").equalsIgnoreCase("all")) {
                            i = (short)(PNSApplication.this.depth - (short)PNSApplication.this.environment.getParameters().getInt("pns_num_rows_to_use"));
                        }
                        if (i < 0) {
                            i = 0;
                        }
                        ret.attach(PNSApplication.this.seekThroughRouteRows(i, PNSApplication.this.depth, nearNode, new Continuation<NodeHandle, Exception>(){

                            @Override
                            public void receiveResult(NodeHandle result) {
                                NodeHandle nearNode = result;
                                retToMe.receiveResult(PNSApplication.this.sortedProximityCache());
                            }

                            @Override
                            public void receiveException(Exception exception) {
                                retToMe.receiveResult(PNSApplication.this.sortedProximityCache());
                            }
                        }));
                    }

                    @Override
                    public void receiveException(Exception exception) {
                        retToMe.receiveResult(PNSApplication.this.sortedProximityCache());
                    }
                }));
            }

            @Override
            public void receiveException(Exception exception) {
                retToMe.receiveException(exception);
            }
        }));
        return ret;
    }

    private Cancellable seekThroughRouteRows(final short i, final short depth, final NodeHandle currentClosest, final Continuation<NodeHandle, Exception> returnToMe) {
        final AttachableCancellable ret = new AttachableCancellable();
        ret.attach(this.getRouteRow(currentClosest, i, new Continuation<RouteSet[], Exception>(){

            @Override
            public void receiveResult(RouteSet[] result) {
                ret.attach(PNSApplication.this.closestToMe(currentClosest, result, (Continuation<NodeHandle, Exception>)new Continuation<NodeHandle, Exception>(){

                    @Override
                    public void receiveResult(NodeHandle nearNode) {
                        if (i >= depth - 1 && currentClosest.equals(nearNode)) {
                            returnToMe.receiveResult(nearNode);
                        } else {
                            short newIndex = (short)(i + 1);
                            if (newIndex > depth - 1) {
                                newIndex = (short)(depth - 1);
                            }
                            PNSApplication.this.seekThroughRouteRows(newIndex, depth, nearNode, returnToMe);
                        }
                    }

                    @Override
                    public void receiveException(Exception exception) {
                        returnToMe.receiveException(exception);
                    }
                }));
            }

            @Override
            public void receiveException(Exception exception) {
                returnToMe.receiveException(exception);
            }
        }));
        return ret;
    }

    private Cancellable closestToMe(NodeHandle handle, LeafSet leafSet, Continuation<NodeHandle, Exception> c) {
        int i;
        if (leafSet == null) {
            c.receiveResult(handle);
            return null;
        }
        HashSet<NodeHandle> handles = new HashSet<NodeHandle>();
        for (i = 1; i <= leafSet.cwSize(); ++i) {
            handles.add(leafSet.get(i));
        }
        for (i = -leafSet.ccwSize(); i < 0; ++i) {
            handles.add(leafSet.get(i));
        }
        return this.closestToMe(handle, handles, c);
    }

    private Cancellable closestToMe(NodeHandle handle, RouteSet[] routeSets, Continuation<NodeHandle, Exception> c) {
        ArrayList<NodeHandle> handles = new ArrayList<NodeHandle>();
        for (int i = 0; i < routeSets.length; ++i) {
            RouteSet set = routeSets[i];
            if (set == null) continue;
            for (int j = 0; j < set.size(); ++j) {
                handles.add(set.get(j));
            }
        }
        return this.closestToMe(handle, handles, c);
    }

    private Cancellable closestToMe(final NodeHandle handle, final Collection<NodeHandle> handles, final Continuation<NodeHandle, Exception> c) {
        if (this.logger.level <= 500) {
            this.logger.log("closestToMe(" + handle + "," + handles + ")");
        }
        final AttachableCancellable ret = new AttachableCancellable();
        final NodeHandle[] closestNode = new NodeHandle[]{handle};
        final HashSet<NodeHandle> remaining = new HashSet<NodeHandle>(handles);
        if (!remaining.contains(handle)) {
            remaining.add(handle);
        }
        final int[] nearestdist = new int[]{Integer.MAX_VALUE};
        ArrayList<NodeHandle> temp = new ArrayList<NodeHandle>(remaining);
        Iterator<NodeHandle> i$ = temp.iterator();
        while (i$.hasNext()) {
            NodeHandle nh;
            final NodeHandle tempNode = nh = i$.next();
            if (this.logger.level <= 400) {
                this.logger.log("closestToMe checking prox on " + tempNode + "(" + handle + "," + handles + ")");
            }
            ret.attach(this.getProximity(handle, new Continuation<Integer, IOException>(){

                @Override
                public void receiveResult(Integer result) {
                    if (((PNSApplication)PNSApplication.this).logger.level <= 300) {
                        PNSApplication.this.logger.log("closestToMe got prox(" + result + ") on " + tempNode + "(" + handle + "," + handles + ")");
                    }
                    remaining.remove(tempNode);
                    int prox = result;
                    if (prox >= 0 && prox < nearestdist[0] && tempNode.isAlive()) {
                        nearestdist[0] = prox;
                        closestNode[0] = tempNode;
                    }
                    this.finish();
                }

                @Override
                public void receiveException(IOException exception) {
                    remaining.remove(tempNode);
                    this.finish();
                }

                public void finish() {
                    if (remaining.isEmpty()) {
                        ret.cancel();
                        c.receiveResult(closestNode[0]);
                    }
                }
            }, 10000));
        }
        return ret;
    }

    class PNSDeserializer
    implements MessageDeserializer {
        PNSDeserializer() {
        }

        public rice.p2p.commonapi.Message deserialize(InputBuffer buf, short type, int priority, rice.p2p.commonapi.NodeHandle sender) throws IOException {
            switch (type) {
                case 1: {
                    return LeafSetRequest.build(buf, (NodeHandle)sender, PNSApplication.this.getAddress());
                }
                case 2: {
                    return LeafSetResponse.build(buf, PNSApplication.this.thePastryNode, PNSApplication.this.getAddress());
                }
                case 3: {
                    return RouteRowRequest.build(buf, (NodeHandle)sender, PNSApplication.this.getAddress());
                }
                case 4: {
                    return new RouteRowResponse(buf, PNSApplication.this.thePastryNode, (NodeHandle)sender, PNSApplication.this.getAddress());
                }
            }
            return null;
        }
    }
}

