/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.messaging;

import java.util.HashMap;
import rice.Destructable;
import rice.environment.logging.Logger;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.RawMessageDelivery;

public class MessageDispatch
implements Destructable {
    private HashMap addressBook = new HashMap();
    protected PastryNode localNode;
    protected Logger logger;

    public MessageDispatch(PastryNode pn) {
        this.localNode = pn;
        this.logger = pn.getEnvironment().getLogManager().getLogger(this.getClass(), null);
    }

    public void registerReceiver(int address, PastryAppl receiver) {
        if (this.logger.level <= 500) {
            this.logger.log("Registering " + receiver + " for address " + address);
        }
        if (this.logger.level <= 300) {
            this.logger.logException("Registering receiver for address " + address, new Exception("stack trace"));
        }
        if (this.addressBook.get(address) != null) {
            throw new IllegalArgumentException("Registering receiver for already-registered address " + address);
        }
        this.addressBook.put(address, receiver);
    }

    public PastryAppl getDestination(Message msg) {
        return this.getDestinationByAddress(msg.getDestination());
    }

    public PastryAppl getDestinationByAddress(int addr) {
        PastryAppl mr = (PastryAppl)this.addressBook.get(addr);
        return mr;
    }

    public boolean dispatchMessage(Message msg) {
        if (msg.getDestination() == 0) {
            Logger logger = this.localNode.getEnvironment().getLogManager().getLogger(MessageDispatch.class, null);
            if (logger.level <= 900) {
                logger.logException("Message " + msg + "," + msg.getClass().getName() + " has no destination.", new Exception("Stack Trace"));
            }
            return false;
        }
        PastryAppl mr = (PastryAppl)this.addressBook.get(msg.getDestination());
        if (mr == null) {
            if (this.logger.level <= 500 || this.localNode.isReady() && this.logger.level <= 800) {
                this.logger.log("Dropping message " + msg + " because the application address " + msg.getDestination() + " is unknown.");
            }
            return false;
        }
        mr.receiveMessage(msg);
        return true;
    }

    public boolean dispatchMessage(RawMessageDelivery msg) {
        if (msg.getAddress() == 0) {
            Logger logger = this.localNode.getEnvironment().getLogManager().getLogger(MessageDispatch.class, null);
            if (logger.level <= 900) {
                logger.logException("Message " + msg + "," + msg.getClass().getName() + " has no destination.", new Exception("Stack Trace"));
            }
            return false;
        }
        PastryAppl mr = (PastryAppl)this.addressBook.get(msg.getAddress());
        if (mr == null) {
            if (this.logger.level <= 900) {
                this.logger.log("Dropping message " + msg + " because the application address " + msg.getAddress() + " is unknown.");
            }
            return false;
        }
        mr.receiveMessageInternal(msg);
        return true;
    }

    public void destroy() {
        for (PastryAppl mr : this.addressBook.values()) {
            if (this.logger.level <= 800) {
                this.logger.log("Destroying " + mr);
            }
            mr.destroy();
        }
        this.addressBook.clear();
    }
}

