/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.util.ArrayList;
import java.util.List;
import org.mpisws.p2p.transport.direct.Delivery;
import org.mpisws.p2p.transport.direct.DirectTransportLayer;
import org.mpisws.p2p.transport.direct.GenericNetworkSimulator;
import org.mpisws.p2p.transport.liveness.LivenessProvider;
import rice.environment.Environment;
import rice.environment.params.Parameters;
import rice.environment.random.RandomSource;
import rice.environment.random.simple.SimpleRandomSource;
import rice.p2p.commonapi.CancellableTask;
import rice.pastry.direct.BasicNetworkSimulator;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectPastryNode;
import rice.pastry.direct.GenericSimulatorListener;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.NodeRecord;
import rice.pastry.direct.ProximityGenerator;
import rice.pastry.direct.TestRecord;
import rice.pastry.transport.TLPastryNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkSimulatorImpl<Identifier, MessageType>
implements NetworkSimulator<Identifier, MessageType> {
    protected BasicNetworkSimulator<Identifier, MessageType> simulator;
    protected RandomSource random;
    protected ProximityGenerator generator;
    protected LivenessProvider<Identifier> livenessProvider;
    private TestRecord testRecord;
    List<GenericSimulatorListener<Identifier, MessageType>> listeners = new ArrayList<GenericSimulatorListener<Identifier, MessageType>>();

    public NetworkSimulatorImpl(Environment env, ProximityGenerator generator) {
        Parameters params = env.getParameters();
        this.random = params.contains("pastry_direct_use_own_random") && params.getBoolean("pastry_direct_use_own_random") ? (params.contains("pastry_direct_random_seed") && !params.getString("pastry_direct_random_seed").equalsIgnoreCase("clock") ? new SimpleRandomSource(params.getLong("pastry_direct_random_seed"), env.getLogManager(), "direct") : new SimpleRandomSource(env.getLogManager(), "direct")) : env.getRandomSource();
        generator.setRandom(this.random);
        this.generator = generator;
        this.simulator = new BasicNetworkSimulator(env, this.random, this);
        this.livenessProvider = this.simulator;
    }

    @Override
    public Environment getEnvironment() {
        return this.simulator.getEnvironment();
    }

    @Override
    public void setFullSpeed() {
        this.simulator.setFullSpeed();
    }

    @Override
    public void setMaxSpeed(float rate) {
        this.simulator.setMaxSpeed(rate);
    }

    @Override
    public void start() {
        this.simulator.start();
    }

    @Override
    public void stop() {
        this.simulator.stop();
    }

    @Override
    public TestRecord getTestRecord() {
        return this.testRecord;
    }

    @Override
    public void setTestRecord(TestRecord tr) {
        this.testRecord = tr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addSimulatorListener(GenericSimulatorListener<Identifier, MessageType> sl) {
        List<GenericSimulatorListener<Identifier, MessageType>> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(sl)) {
                return false;
            }
            this.listeners.add(sl);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSimulatorListener(GenericSimulatorListener<Identifier, MessageType> sl) {
        List<GenericSimulatorListener<Identifier, MessageType>> list = this.listeners;
        synchronized (list) {
            return this.listeners.remove(sl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySimulatorListenersSent(MessageType m, Identifier from, Identifier to, int delay) {
        ArrayList<GenericSimulatorListener<Identifier, MessageType>> temp;
        List<GenericSimulatorListener<Identifier, MessageType>> list = this.listeners;
        synchronized (list) {
            temp = new ArrayList<GenericSimulatorListener<Identifier, MessageType>>(this.listeners);
        }
        for (GenericSimulatorListener genericSimulatorListener : temp) {
            genericSimulatorListener.messageSent(m, from, to, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySimulatorListenersReceived(MessageType m, Identifier from, Identifier to) {
        ArrayList<GenericSimulatorListener<Identifier, MessageType>> temp;
        List<GenericSimulatorListener<Identifier, MessageType>> list = this.listeners;
        synchronized (list) {
            temp = new ArrayList<GenericSimulatorListener<Identifier, MessageType>>(this.listeners);
        }
        for (GenericSimulatorListener genericSimulatorListener : temp) {
            genericSimulatorListener.messageReceived(m, from, to);
        }
    }

    @Override
    public void destroy(DirectPastryNode dpn) {
    }

    @Override
    public CancellableTask enqueueDelivery(Delivery del, int delay) {
        return null;
    }

    @Override
    public NodeRecord generateNodeRecord() {
        return this.generator.generateNodeRecord();
    }

    @Override
    public DirectNodeHandle getClosest(DirectNodeHandle nh) {
        return null;
    }

    @Override
    public boolean isAlive(Identifier nh) {
        return this.simulator.isAlive(nh);
    }

    @Override
    public float networkDelay(Identifier a, Identifier b) {
        return this.simulator.networkDelay(a, b);
    }

    @Override
    public float proximity(Identifier a, Identifier b) {
        return this.simulator.proximity(a, b);
    }

    @Override
    public void removeNode(TLPastryNode node) {
    }

    @Override
    public NodeRecord getNodeRecord(DirectNodeHandle handle) {
        return this.simulator.getNodeRecord(handle);
    }

    @Override
    public LivenessProvider<Identifier> getLivenessProvider() {
        return this.livenessProvider;
    }

    @Override
    public GenericNetworkSimulator<Identifier, MessageType> getGenericSimulator() {
        return this.simulator;
    }

    @Override
    public void registerNode(Identifier i, DirectTransportLayer<Identifier, MessageType> dtl, NodeRecord nr) {
        this.simulator.registerIdentifier(i, dtl, nr);
    }
}

