/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util.testing;

import java.io.IOException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import rice.p2p.util.MathUtils;
import rice.p2p.util.SecurityUtils;

public class SecurityUtilsUnit {
    public static void main(String[] argv) throws NoSuchAlgorithmException, IOException, ClassNotFoundException {
        System.out.println("SecurityUtils Test Suite");
        System.out.println("-------------------------------------------------------------");
        System.out.println("  Initializing Tests");
        System.out.print("    Generating key pairs\t\t\t\t");
        KeyPair pair = SecurityUtils.generateKeyAsymmetric();
        KeyPair pair2 = SecurityUtils.generateKeyAsymmetric();
        System.out.println("[ DONE ]");
        System.out.print("    Building cipher\t\t\t\t\t");
        System.out.println("[ DONE ]");
        System.out.println("-------------------------------------------------------------");
        System.out.println("  Running Tests");
        System.out.print("    Testing serialization\t\t\t\t");
        String testString = "test";
        byte[] testStringByte = SecurityUtils.serialize(testString);
        String testStringOutput = (String)SecurityUtils.deserialize(testStringByte);
        if (testStringOutput.equals(testString)) {
            System.out.println("[ PASSED ]");
        } else {
            System.out.println("[ FAILED ]");
            System.out.println("    Input: \t" + testString);
            System.out.println("    Output:\t" + testStringOutput);
        }
        System.out.print("    Testing hashing\t\t\t\t\t");
        byte[] testStringHash = SecurityUtils.hash(testStringByte);
        if (testStringHash != null && testStringHash.length == 20) {
            System.out.println("[ PASSED ]");
        } else {
            System.out.println("[ FAILED ]");
            System.out.println("    Input: \t" + testString);
            System.out.println("    Output:\t" + testStringHash);
            if (testStringHash != null) {
                System.out.println("    Length:\t" + testStringHash.length);
            }
        }
        System.out.print("    Testing symmetric encryption\t\t\t");
        byte[] key = SecurityUtils.generateKeySymmetric();
        byte[] testStringCipherText = SecurityUtils.encryptSymmetric(testStringByte, key);
        byte[] testStringPlainText = SecurityUtils.decryptSymmetric(testStringCipherText, key);
        if (Arrays.equals(testStringByte, testStringPlainText)) {
            System.out.println("[ PASSED ]");
        } else {
            System.out.println("[ FAILED ]");
            System.out.println("    Input: \t" + testString);
            System.out.println("    Length:\t" + testStringByte.length);
            System.out.println("    Cipher Len:\t" + testStringCipherText.length);
            System.out.println("    Output Len:\t" + testStringPlainText.length);
        }
        System.out.print("    Testing signing and verification (phase 1)\t\t");
        byte[] testStringSig = SecurityUtils.sign(testStringByte, pair.getPrivate());
        if (SecurityUtils.verify(testStringByte, testStringSig, pair.getPublic())) {
            System.out.println("[ PASSED ]");
        } else {
            System.out.println("[ FAILED ]");
            System.out.println("    Input: \t" + testString);
            System.out.println("    Length:\t" + testStringByte.length);
            System.out.println("    Sig Len:\t" + testStringSig.length);
        }
        System.out.print("    Testing signing and verification (phase 2)\t\t");
        testStringSig[0] = (byte)(testStringSig[0] + 1);
        if (!SecurityUtils.verify(testStringByte, testStringSig, pair.getPublic())) {
            System.out.println("[ PASSED ]");
        } else {
            System.out.println("[ FAILED ]");
            System.out.println("    Input: \t" + testString);
            System.out.println("    Length:\t" + testStringByte.length);
            System.out.println("    Sig Len:\t" + testStringSig.length);
        }
        System.out.print("    Testing asymmetric encryption\t\t\t");
        byte[] testStringEncrypted = SecurityUtils.encryptAsymmetric(testStringByte, pair.getPublic());
        byte[] testStringDecrypted = SecurityUtils.decryptAsymmetric(testStringEncrypted, pair.getPrivate());
        if (Arrays.equals(testStringByte, testStringDecrypted)) {
            System.out.println("[ PASSED ]");
        } else {
            System.out.println("[ FAILED ]");
            System.out.println("    Input: \t" + testString);
            System.out.println("    Length:\t" + testStringByte.length);
            System.out.println("    Enc Len:\t" + testStringEncrypted.length);
            System.out.println("    Dec Len:\t" + testStringDecrypted.length);
        }
        System.out.print("    Testing hmac algorithm\t\t\t\t");
        String hmacText = "<1896.697170952@postoffice.reston.mci.net>";
        String hmacKey = "tanstaaftanstaaf";
        byte[] hmac = SecurityUtils.hmac(hmacKey.getBytes(), hmacText.getBytes());
        byte[] hmacResult = new byte[]{-71, 19, -90, 2, -57, -19, -89, -92, -107, -76, -26, -25, 51, 77, 56, -112};
        if (Arrays.equals(hmac, hmacResult)) {
            System.out.println("[ PASSED ]");
        } else {
            System.out.println("[ FAILED ]");
            System.out.println("    Input: \t" + hmacText);
            System.out.println("    Key: \t" + hmacKey);
            System.out.println("    Res Len:\t" + hmac.length);
            System.out.println("    Real Len:\t" + hmacResult.length);
        }
        System.out.print("    Testing hmac algorithm again\t\t\t");
        String hmacText2 = "<1080369447214@The-Edge.local>";
        String hmacKey2 = "monkey";
        byte[] hmac2 = SecurityUtils.hmac(hmacKey2.getBytes(), hmacText2.getBytes());
        byte[] hmacResult2 = new byte[]{-101, -82, 82, -17, 85, 69, 36, -111, 54, -123, 116, 114, 33, -69, -124, 34};
        if (Arrays.equals(hmac2, hmacResult2)) {
            System.out.println("[ PASSED ]");
        } else {
            System.out.println("[ FAILED ]");
            System.out.println("    Input: \t" + hmacText2);
            System.out.println("    Key: \t" + hmacKey2);
            System.out.println("    Res Len:\t" + hmac2.length);
            System.out.println("    Real Len:\t" + hmacResult2.length);
        }
        System.out.print("    Testing asymmetic symmetric key encryption\t\t");
        byte[] keySym = SecurityUtils.generateKeySymmetric();
        if (Arrays.equals(SecurityUtils.encryptAsymmetric(keySym, pair.getPublic()), SecurityUtils.encryptAsymmetric(keySym, pair2.getPublic()))) {
            System.out.println("[ FAILED ]");
            System.out.println("    Input: \t" + MathUtils.toHex(keySym));
            System.out.println("    Output 1: \t" + MathUtils.toHex(SecurityUtils.encryptAsymmetric(keySym, pair.getPublic())));
            System.out.println("    Output 2: \t" + MathUtils.toHex(SecurityUtils.encryptAsymmetric(keySym, pair2.getPublic())));
        } else {
            System.out.println("[ PASSED ]");
        }
        System.out.print("    Testing asymmetic public writing\t\t\t");
        PublicKey k = SecurityUtils.decodePublicKey(SecurityUtils.encodePublicKey(pair.getPublic()));
        if (!Arrays.equals(k.getEncoded(), pair.getPublic().getEncoded())) {
            System.out.println("[ FAILED ]");
            System.out.println("  Output 1: \t" + MathUtils.toHex(SecurityUtils.encryptAsymmetric(keySym, k)));
            System.out.println("     Res 1: \t" + MathUtils.toHex(SecurityUtils.decryptAsymmetric(SecurityUtils.encryptAsymmetric(keySym, k), pair.getPrivate())));
            System.out.println("  Output 2: \t" + MathUtils.toHex(SecurityUtils.encryptAsymmetric(keySym, pair.getPublic())));
            System.out.println("     Res 2: \t" + MathUtils.toHex(SecurityUtils.decryptAsymmetric(SecurityUtils.encryptAsymmetric(keySym, pair.getPublic()), pair.getPrivate())));
        } else {
            System.out.println("[ PASSED ]");
        }
        System.out.print("    Testing asymmetic private writing\t\t\t");
        PrivateKey k2 = SecurityUtils.decodePrivateKey(SecurityUtils.encodePrivateKey(pair.getPrivate()));
        if (!Arrays.equals(SecurityUtils.sign(keySym, k2), SecurityUtils.sign(keySym, pair.getPrivate()))) {
            System.out.println("[ FAILED ]");
            System.out.println("  Output 1: \t" + MathUtils.toHex(k2.getEncoded()));
            System.out.println("  Output 2: \t" + MathUtils.toHex(pair.getPrivate().getEncoded()));
        } else {
            System.out.println("[ PASSED ]");
        }
        System.out.print("    Testing asymmetic serialized writing\t\t");
        testStringEncrypted = SecurityUtils.encryptAsymmetric(testStringByte, k);
        testStringDecrypted = SecurityUtils.decryptAsymmetric(testStringEncrypted, pair.getPrivate());
        if (Arrays.equals(testStringByte, testStringDecrypted)) {
            System.out.println("[ PASSED ]");
        } else {
            System.out.println("[ FAILED ]");
            System.out.println("    Input: \t" + testString);
            System.out.println("    Length:\t" + testStringByte.length);
            System.out.println("    Enc Len:\t" + testStringEncrypted.length);
            System.out.println("    Dec Len:\t" + testStringDecrypted.length);
        }
        System.out.println("-------------------------------------------------------------");
    }
}

