/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;
import rice.p2p.util.Base64;

public class XMLWriter {
    protected XmlSerializer serializer;
    protected Writer writer;

    public XMLWriter(OutputStream out) throws IOException {
        try {
            this.writer = new BufferedWriter(new OutputStreamWriter(out));
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
            this.serializer = factory.newSerializer();
            this.serializer.setOutput(this.writer);
            this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)" ");
            this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
            this.serializer.setFeature("http://xmlpull.org/v1/doc/features.html#serializer-attvalue-use-apostrophe", true);
        }
        catch (XmlPullParserException e) {
            throw new IOException("XML Exception thrown: " + (Object)((Object)e));
        }
    }

    public void flush() throws IOException {
        this.serializer.flush();
    }

    public void close() throws IOException {
        this.serializer.text("\n");
        this.serializer.flush();
        this.writer.close();
    }

    public void writeBase64(byte[] bytes, int off, int len) throws IOException {
        this.flush();
        this.writer.write(Base64.encodeBytes(bytes, off, len));
    }

    public void writeHeader() throws IOException {
        this.serializer.startDocument(null, null);
        this.serializer.text("\n\n");
    }

    public void attribute(String name, int value) throws IOException {
        this.attribute(name, String.valueOf(value));
    }

    public void attribute(String name, double value) throws IOException {
        this.attribute(name, String.valueOf(value));
    }

    public void attribute(String name, float value) throws IOException {
        this.attribute(name, String.valueOf(value));
    }

    public void attribute(String name, long value) throws IOException {
        this.attribute(name, String.valueOf(value));
    }

    public void attribute(String name, char value) throws IOException {
        this.attribute(name, String.valueOf(value));
    }

    public void attribute(String name, boolean value) throws IOException {
        this.attribute(name, String.valueOf(value));
    }

    public void attribute(String name, Object value) throws IOException {
        if (value == null) {
            return;
        }
        this.attribute(name, value.toString());
    }

    protected void attribute(String name, String value) throws IOException {
        this.serializer.attribute(null, name, value);
    }

    public void start(String name) throws IOException {
        this.serializer.startTag(null, name);
    }

    public void end(String name) throws IOException {
        this.serializer.endTag(null, name);
    }
}

