/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.splitstream;

import java.util.Hashtable;
import java.util.Vector;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.scribe.Scribe;
import rice.p2p.scribe.ScribeClient;
import rice.p2p.scribe.ScribeContent;
import rice.p2p.scribe.ScribeImpl;
import rice.p2p.scribe.Topic;
import rice.p2p.splitstream.Channel;
import rice.p2p.splitstream.SplitStreamClient;
import rice.p2p.splitstream.SplitStreamContent;
import rice.p2p.splitstream.SplitStreamScribePolicy;
import rice.p2p.splitstream.StripeId;
import rice.selector.TimerTask;

public class Stripe
implements ScribeClient {
    public final int MAX_FAILED_SUBSCRIPTION;
    protected StripeId stripeId;
    protected Topic topic;
    protected Scribe scribe;
    protected boolean isPrimary;
    protected Vector clients;
    protected Channel channel;
    protected Hashtable failed;
    protected String instance;
    Logger logger;

    public Stripe(StripeId stripeId, Scribe scribe, String instance, Channel channel, int maxFailedSubscriptions) {
        this.instance = instance;
        this.MAX_FAILED_SUBSCRIPTION = maxFailedSubscriptions;
        this.stripeId = stripeId;
        this.scribe = scribe;
        this.logger = scribe.getEnvironment().getLogManager().getLogger(Stripe.class, instance);
        this.channel = channel;
        this.isPrimary = false;
        this.failed = new Hashtable();
        if (SplitStreamScribePolicy.getPrefixMatch(this.channel.getLocalId(), stripeId.getId(), channel.getStripeBase()) > 0) {
            this.isPrimary = true;
        }
        this.clients = new Vector();
        this.topic = new Topic(stripeId.getId());
    }

    public StripeId getStripeId() {
        return this.stripeId;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public boolean isSubscribed() {
        return this.clients.size() != 0;
    }

    public void subscribe(SplitStreamClient client) {
        if (!this.clients.contains(client)) {
            if (this.clients.size() == 0) {
                this.scribe.subscribe(this.topic, this);
            }
            this.clients.add(client);
        }
    }

    public void unsubscribe(SplitStreamClient client) {
        if (this.clients.contains(client)) {
            this.clients.remove(client);
            if (this.clients.size() == 0) {
                this.scribe.unsubscribe(this.topic, this);
            }
        }
    }

    public void publish(byte[] data) {
        this.scribe.publish(this.topic, new SplitStreamContent(data));
    }

    public boolean anycast(Topic topic, ScribeContent content) {
        return false;
    }

    public void deliver(Topic topic, ScribeContent content) {
        if (this.topic.equals(topic)) {
            if (content instanceof SplitStreamContent) {
                byte[] data = ((SplitStreamContent)content).getData();
                SplitStreamClient[] clients = this.clients.toArray(new SplitStreamClient[0]);
                for (int i = 0; i < clients.length; ++i) {
                    clients[i].deliver(this, data);
                }
            } else if (this.logger.level <= 900) {
                this.logger.log("Received unexpected content " + content);
            }
        } else if (this.logger.level <= 900) {
            this.logger.log("Received update for unexcpected topic " + topic + " content " + content);
        }
    }

    public void childAdded(Topic topic, NodeHandle child) {
        if (this.logger.level <= 500) {
            this.logger.log("childAdded(" + topic + "," + child + ")");
        }
    }

    public void childRemoved(Topic topic, NodeHandle child) {
        if (this.logger.level <= 500) {
            this.logger.log("childRemoved(" + topic + "," + child + ")");
        }
    }

    public void subscribeFailed(final Topic topic) {
        Integer count = (Integer)this.failed.get(topic);
        if (count == null) {
            count = new Integer(0);
        }
        if (count < this.MAX_FAILED_SUBSCRIPTION) {
            count = new Integer(count + 1);
            if (this.logger.level <= 900) {
                this.logger.log("DEBUG :: Subscription failed at " + this.channel.getLocalId() + " for topic " + topic + " - retrying.");
            }
            this.scribe.subscribe(topic, this);
            this.failed.put(topic, count);
        } else {
            TimerTask resubscribeTask = new TimerTask(){

                public void run() {
                    if (Stripe.this.getParent() == null) {
                        Stripe.this.scribe.subscribe(topic, Stripe.this);
                    }
                }
            };
            this.scribe.getEnvironment().getSelectorManager().getTimer().schedule(resubscribeTask, this.scribe.getEnvironment().getParameters().getInt("p2p_splitStream_stripe_max_failed_subscription_retry_delay"));
        }
    }

    public String toString() {
        return "Stripe " + this.stripeId;
    }

    public NodeHandle[] getChildren() {
        return this.scribe.getChildren(new Topic(this.getStripeId().getId()));
    }

    public NodeHandle getParent() {
        return ((ScribeImpl)this.scribe).getParent(new Topic(this.getStripeId().getId()));
    }

    public boolean isRoot() {
        return ((ScribeImpl)this.scribe).isRoot(this.topic);
    }
}

