/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.splitstream;

import java.io.IOException;
import java.util.Hashtable;
import rice.environment.Environment;
import rice.environment.params.Parameters;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.scribe.Scribe;
import rice.p2p.scribe.ScribeContent;
import rice.p2p.scribe.ScribeImpl;
import rice.p2p.scribe.ScribePolicy;
import rice.p2p.scribe.rawserialization.ScribeContentDeserializer;
import rice.p2p.splitstream.Channel;
import rice.p2p.splitstream.ChannelId;
import rice.p2p.splitstream.SplitStream;
import rice.p2p.splitstream.SplitStreamContent;
import rice.p2p.splitstream.SplitStreamScribePolicy;
import rice.p2p.splitstream.SplitStreamScribePolicyFactory;
import rice.p2p.splitstream.SplitStreamSubscribeContent;

public class SplitStreamImpl
implements SplitStream {
    protected Scribe scribe;
    protected Node node;
    protected Hashtable channels;
    protected final int stripeBaseBitLength;
    protected final int maxFailedSubscriptions;
    protected final int defaultMaxChildren;
    protected String instance;

    public SplitStreamImpl(Node node, String instance) {
        this(node, instance, new SplitStreamScribePolicyFactory(){

            public ScribePolicy getSplitStreamScribePolicy(Scribe scribe, SplitStream splitstream) {
                return new SplitStreamScribePolicy(scribe, splitstream);
            }
        });
    }

    public SplitStreamImpl(Node node, String instance, SplitStreamScribePolicyFactory factory) {
        this.instance = instance;
        Environment environment = node.getEnvironment();
        Parameters p = environment.getParameters();
        this.defaultMaxChildren = p.getInt("p2p_splitStream_policy_default_maximum_children");
        this.maxFailedSubscriptions = p.getInt("p2p_splitStream_stripe_max_failed_subscription");
        this.stripeBaseBitLength = p.getInt("p2p_splitStream_stripeBaseBitLength");
        this.scribe = new ScribeImpl(node, instance);
        this.scribe.setContentDeserializer(new ScribeContentDeserializer(){

            public ScribeContent deserializeScribeContent(InputBuffer buf, Endpoint endpoint, short contentType) throws IOException {
                switch (contentType) {
                    case 1: {
                        return new SplitStreamContent(buf);
                    }
                    case 2: {
                        return new SplitStreamSubscribeContent(buf);
                    }
                }
                throw new IllegalArgumentException("Invalid type:" + contentType);
            }
        });
        this.node = node;
        this.channels = new Hashtable();
        this.scribe.setPolicy(factory.getSplitStreamScribePolicy(this.scribe, this));
    }

    public Channel createChannel(ChannelId id) {
        return this.attachChannel(id);
    }

    public Channel attachChannel(ChannelId id) {
        Channel channel = (Channel)this.channels.get(id);
        if (channel == null) {
            channel = new Channel(id, this.scribe, this.instance, this.node.getIdFactory(), this.node.getId(), this.stripeBaseBitLength, this.maxFailedSubscriptions);
            this.channels.put(id, channel);
        }
        ((SplitStreamScribePolicy)this.scribe.getPolicy()).setMaxChildren(id, this.defaultMaxChildren);
        return channel;
    }

    public Channel[] getChannels() {
        return this.channels.values().toArray(new Channel[0]);
    }

    public SplitStreamScribePolicy getPolicy() {
        return (SplitStreamScribePolicy)this.scribe.getPolicy();
    }

    public int getStripeBaseBitLength() {
        return this.stripeBaseBitLength;
    }

    public Environment getEnvironment() {
        return this.scribe.getEnvironment();
    }

    public void destroy() {
        this.scribe.destroy();
    }
}

