/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.scribe.messaging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.scribe.Topic;
import rice.p2p.scribe.messaging.AbstractSubscribeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscribeAckMessage
extends AbstractSubscribeMessage {
    public static final short TYPE = 3;
    protected List<List<Id>> pathsToRoot;

    public SubscribeAckMessage(NodeHandle source, List<Topic> topics, List<List<Id>> pathsToRoot, int id) {
        super(source, topics, id);
        if (topics.size() != pathsToRoot.size()) {
            throw new IllegalArgumentException("Must be a path for each topic.  Topics: " + topics.size() + " Paths:" + pathsToRoot.size());
        }
        this.topics = topics;
        this.pathsToRoot = pathsToRoot;
    }

    public List<List<Id>> getPathsToRoot() {
        return this.pathsToRoot;
    }

    @Override
    public String toString() {
        if (this.topics.size() == 1) {
            return "SubscribeAckMessage{" + this.topics.get(0) + " ID:" + this.id + "}";
        }
        return "SubscribeAckMessage{" + this.topics.size() + " ID:" + this.id + "}";
    }

    @Override
    public short getType() {
        return 3;
    }

    @Override
    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)1);
        super.serialize(buf);
        int numTopics = this.topics.size();
        buf.writeInt(numTopics);
        Iterator j = this.topics.iterator();
        Iterator<List<Id>> i = this.pathsToRoot.iterator();
        while (j.hasNext()) {
            ((Topic)j.next()).serialize(buf);
            List<Id> pathToRoot = i.next();
            buf.writeInt(pathToRoot.size());
            for (Id id : pathToRoot) {
                buf.writeShort(id.getType());
                id.serialize(buf);
            }
        }
    }

    public static SubscribeAckMessage build(InputBuffer buf, Endpoint endpoint) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return null;
            }
            case 1: {
                return new SubscribeAckMessage(buf, endpoint);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }

    private SubscribeAckMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        super(buf, endpoint);
        int numTopics = buf.readInt();
        this.topics = new ArrayList(numTopics);
        this.pathsToRoot = new ArrayList<List<Id>>(numTopics);
        for (int i = 0; i < numTopics; ++i) {
            this.topics.add(new Topic(buf, endpoint));
            int length = buf.readInt();
            ArrayList<Id> pathToRoot = new ArrayList<Id>(length);
            for (int j = 0; j < length; ++j) {
                pathToRoot.add(endpoint.readId(buf, buf.readShort()));
            }
            this.pathsToRoot.add(pathToRoot);
        }
    }
}

