/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.rawserialization;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.past.Past;
import rice.p2p.past.PastContent;
import rice.p2p.past.PastContentHandle;
import rice.p2p.past.PastException;
import rice.p2p.past.rawserialization.RawPastContent;
import rice.p2p.util.rawserialization.JavaSerializationException;

public class JavaSerializedPastContent
implements RawPastContent {
    public static final short TYPE = 0;
    public PastContent content;

    public JavaSerializedPastContent(PastContent content) {
        this.content = content;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.content);
            oos.close();
            byte[] temp = baos.toByteArray();
            buf.writeInt(temp.length);
            buf.write(temp, 0, temp.length);
        }
        catch (IOException ioe) {
            throw new JavaSerializationException(this.content, ioe);
        }
    }

    public short getType() {
        return 0;
    }

    public String toString() {
        return "JSPC [" + this.content + "]";
    }

    public PastContent getContent() {
        return this.content;
    }

    public PastContent checkInsert(Id id, PastContent existingContent) throws PastException {
        return this.content.checkInsert(id, existingContent);
    }

    public PastContentHandle getHandle(Past local) {
        return this.content.getHandle(local);
    }

    public Id getId() {
        return this.content.getId();
    }

    public boolean isMutable() {
        return this.content.isMutable();
    }
}

