/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.multiring.messaging;

import java.io.IOException;
import java.util.Hashtable;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.multiring.RingId;
import rice.p2p.scribe.rawserialization.RawScribeContent;
import rice.p2p.util.rawserialization.JavaSerializedMessage;

public class RingMessage
implements RawScribeContent {
    private static final long serialVersionUID = -7097995807488121199L;
    public static final short TYPE = 1;
    protected RingId id;
    protected RawMessage message;
    protected String application;

    public RingMessage(RingId id, RawMessage message, String application) {
        this.id = id;
        this.message = message;
        this.application = application;
    }

    public int getPriority() {
        return this.message.getPriority();
    }

    public RingId getId() {
        return this.id;
    }

    public RawMessage getRawMessage() {
        return this.message;
    }

    public Message getMessage() {
        if (this.message.getType() == 0) {
            return ((JavaSerializedMessage)this.message).getMessage();
        }
        return this.message;
    }

    public String getApplication() {
        return this.application;
    }

    public short getType() {
        return 1;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        this.id.serialize(buf);
        buf.writeUTF(this.application);
        buf.writeShort(this.message.getType());
        int priority = this.message.getPriority();
        if (priority > 127) {
            throw new IllegalStateException("Priority must be in the range of -128 to 127.  Lower values are higher priority. Priority of " + this.message + " was " + priority + ".");
        }
        if (priority < -128) {
            throw new IllegalStateException("Priority must be in the range of -128 to 127.  Lower values are higher priority. Priority of " + this.message + " was " + priority + ".");
        }
        buf.writeByte((byte)priority);
        this.message.serialize(buf);
    }

    public RingMessage(InputBuffer buf, Endpoint ringEndpoint, Hashtable endpoints) throws IOException {
        this.id = new RingId(buf, ringEndpoint);
        this.application = buf.readUTF();
        Endpoint endpoint = (Endpoint)endpoints.get(this.application);
        if (endpoint == null) {
            throw new IOException("Couldn't find application:" + this.application);
        }
        MessageDeserializer md = endpoint.getDeserializer();
        short type = buf.readShort();
        byte priority = buf.readByte();
        Message m = md.deserialize(buf, type, priority, null);
        this.message = type == 0 ? new JavaSerializedMessage(m) : (RawMessage)m;
    }
}

