/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.glacier.v2.messaging.GlacierMessage;

public class GlacierNeighborResponseMessage
extends GlacierMessage {
    public static final short TYPE = 4;
    protected Id[] neighbors;
    protected long[] lastSeen;

    public GlacierNeighborResponseMessage(int uid, Id[] neighbors, long[] lastSeen, NodeHandle source, Id dest, char tag) {
        super(uid, source, dest, true, tag);
        this.neighbors = neighbors;
        this.lastSeen = lastSeen;
    }

    public int numNeighbors() {
        if (this.neighbors == null || this.lastSeen == null) {
            return 0;
        }
        if (this.lastSeen.length < this.neighbors.length) {
            return this.lastSeen.length;
        }
        return this.neighbors.length;
    }

    public Id getNeighbor(int index) {
        return this.neighbors[index];
    }

    public long getLastSeen(int index) {
        return this.lastSeen[index];
    }

    public String toString() {
        return "[GlacierNeighborResponse with " + this.numNeighbors() + " keys]";
    }

    public short getType() {
        return 4;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        int i;
        buf.writeByte((byte)0);
        super.serialize(buf);
        buf.writeInt(this.lastSeen.length);
        for (i = 0; i < this.lastSeen.length; ++i) {
            buf.writeLong(this.lastSeen[i]);
        }
        buf.writeInt(this.neighbors.length);
        for (i = 0; i < this.neighbors.length; ++i) {
            buf.writeShort(this.neighbors[i].getType());
            this.neighbors[i].serialize(buf);
        }
    }

    public static GlacierNeighborResponseMessage build(InputBuffer buf, Endpoint endpoint) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new GlacierNeighborResponseMessage(buf, endpoint);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }

    private GlacierNeighborResponseMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        super(buf, endpoint);
        int i;
        this.lastSeen = new long[buf.readInt()];
        for (i = 0; i < this.lastSeen.length; ++i) {
            this.lastSeen[i] = buf.readLong();
        }
        this.neighbors = new Id[buf.readInt()];
        for (i = 0; i < this.lastSeen.length; ++i) {
            this.neighbors[i] = endpoint.readId(buf, buf.readShort());
        }
    }
}

