/*
 * Decompiled with CFR 0.152.
 */
package rice.environment.time.simulated;

import java.util.ArrayList;
import java.util.HashSet;
import rice.environment.logging.LogManager;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.environment.time.TimeSource;
import rice.selector.SelectorManager;
import rice.selector.TimerTask;

public class DirectTimeSource
implements TimeSource {
    protected long time = 0L;
    protected Logger logger = null;
    protected String instance;
    protected SelectorManager selectorManager;
    protected HashSet<BlockingTimerTask> pendingTimers = new HashSet();

    public DirectTimeSource(long time) {
        this(time, null);
    }

    public DirectTimeSource(long time, String instance) {
        if (time < 0L) {
            time = System.currentTimeMillis();
        } else {
            this.time = time;
        }
        this.instance = instance;
    }

    public DirectTimeSource(Parameters p) {
        this(p.getLong("direct_simulator_start_time"));
    }

    public void setLogManager(LogManager manager) {
        this.logger = manager.getLogger(DirectTimeSource.class, this.instance);
    }

    public void setSelectorManager(SelectorManager sm) {
        this.selectorManager = sm;
    }

    public long currentTimeMillis() {
        return this.time;
    }

    public void setTime(long newTime) {
        if (newTime < this.time) {
            if (this.logger.level <= 900) {
                this.logger.log("Attempted to set time from " + this.time + " to " + newTime + ", ignoring.");
            }
            return;
        }
        if (this.logger.level <= 400) {
            this.logger.log("DirectTimeSource.setTime(" + this.time + "=>" + newTime + ")");
        }
        this.time = newTime;
    }

    public void incrementTime(int millis) {
        this.setTime(this.time + (long)millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep(long delay) throws InterruptedException {
        SelectorManager selectorManager = this.selectorManager;
        synchronized (selectorManager) {
            BlockingTimerTask btt = new BlockingTimerTask();
            this.pendingTimers.add(btt);
            if (this.logger.level <= 500) {
                this.logger.log("DirectTimeSource.sleep(" + delay + ")");
            }
            this.selectorManager.getTimer().schedule(btt, delay);
            while (!btt.done) {
                this.selectorManager.wait();
                if (!btt.interrupted) continue;
                throw new InterruptedException("TimeSource destroyed.");
            }
            this.pendingTimers.remove(btt);
        }
    }

    public void destroy() {
        for (BlockingTimerTask btt : new ArrayList<BlockingTimerTask>(this.pendingTimers)) {
            btt.interrupt();
        }
        this.pendingTimers.clear();
    }

    private class BlockingTimerTask
    extends TimerTask {
        boolean done = false;
        boolean interrupted = false;

        private BlockingTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SelectorManager selectorManager = DirectTimeSource.this.selectorManager;
            synchronized (selectorManager) {
                this.done = true;
                DirectTimeSource.this.selectorManager.notifyAll();
            }
        }

        public void interrupt() {
            this.interrupted = true;
        }
    }
}

