/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.util;

import java.util.Map;
import org.mpisws.p2p.transport.ErrorHandler;
import rice.environment.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultErrorHandler<Identifier>
implements ErrorHandler<Identifier> {
    public int NUM_BYTES_TO_PRINT = 8;
    Logger logger;

    public DefaultErrorHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void receivedUnexpectedData(Identifier id, byte[] bytes, int pos, Map<String, Object> options) {
        if (this.logger.level <= 800) {
            String s = "";
            int numBytes = this.NUM_BYTES_TO_PRINT;
            if (bytes.length < numBytes) {
                numBytes = bytes.length;
            }
            for (int i = 0; i < numBytes; ++i) {
                s = s + bytes[i] + ",";
            }
            this.logger.log("Unexpected data from " + id + " " + s);
        }
    }

    @Override
    public void receivedException(Identifier i, Throwable error) {
        if (this.logger.level <= 800) {
            this.logger.logException(i == null ? null : i.toString(), error);
        }
    }
}

