/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.simpleidentity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.mpisws.p2p.transport.ClosedChannelException;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.simpleidentity.LocalIdentifierStrategy;
import org.mpisws.p2p.transport.simpleidentity.Serializer;
import org.mpisws.p2p.transport.util.InsufficientBytesException;
import org.mpisws.p2p.transport.util.SocketInputBuffer;
import org.mpisws.p2p.transport.util.SocketRequestHandleImpl;
import org.mpisws.p2p.transport.util.SocketWrapperSocket;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleIdentityTransportLayer<Identifier, MessageType>
implements TransportLayer<Identifier, MessageType>,
TransportLayerCallback<Identifier, MessageType> {
    protected TransportLayer<Identifier, MessageType> tl;
    protected Logger logger;
    private TransportLayerCallback<Identifier, MessageType> callback;
    protected ErrorHandler<Identifier> errorHandler;
    protected Serializer<Identifier> serializer;
    LocalIdentifierStrategy<Identifier> localIdStrategy;

    public SimpleIdentityTransportLayer(TransportLayer<Identifier, MessageType> tl, Serializer<Identifier> serializer, LocalIdentifierStrategy<Identifier> localIdStrategy, Environment env, ErrorHandler<Identifier> handler) throws IOException {
        this.tl = tl;
        this.tl.setCallback(this);
        this.errorHandler = handler;
        this.logger = env.getLogManager().getLogger(this.getClass(), null);
        this.serializer = serializer;
        this.localIdStrategy = localIdStrategy;
        if (this.localIdStrategy == null) {
            this.localIdStrategy = new DefaultLocalIdentifierStrategy<Identifier>(tl.getLocalIdentifier());
        }
    }

    @Override
    public void acceptMessages(boolean b) {
        this.tl.acceptMessages(b);
    }

    @Override
    public void acceptSockets(boolean b) {
        this.tl.acceptSockets(b);
    }

    @Override
    public Identifier getLocalIdentifier() {
        return this.tl.getLocalIdentifier();
    }

    @Override
    public SocketRequestHandle<Identifier> openSocket(Identifier i, final SocketCallback<Identifier> deliverSocketToMe, Map<String, Object> options) {
        final SocketRequestHandleImpl<Identifier> ret = new SocketRequestHandleImpl<Identifier>(i, options, this.logger);
        ret.setSubCancellable(this.tl.openSocket(i, new SocketCallback<Identifier>(){

            @Override
            public void receiveResult(SocketRequestHandle<Identifier> cancellable, P2PSocket<Identifier> sock) {
                try {
                    final ByteBuffer writeMe = ByteBuffer.wrap(SimpleIdentityTransportLayer.this.localIdStrategy.getLocalIdentifierBytes());
                    new P2PSocketReceiver<Identifier>(){

                        @Override
                        public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
                            if (socket.write(writeMe) < 0L) {
                                deliverSocketToMe.receiveException(ret, new ClosedChannelException("Socket closed."));
                                return;
                            }
                            if (writeMe.hasRemaining()) {
                                socket.register(false, true, this);
                                return;
                            }
                            deliverSocketToMe.receiveResult(ret, new SocketWrapperSocket(socket.getIdentifier(), socket, SimpleIdentityTransportLayer.this.logger, socket.getOptions()));
                        }

                        @Override
                        public void receiveException(P2PSocket<Identifier> socket, Exception ioe) {
                            deliverSocketToMe.receiveException(ret, ioe);
                        }
                    }.receiveSelectResult(sock, false, true);
                }
                catch (IOException ioe) {
                    deliverSocketToMe.receiveException(ret, ioe);
                }
            }

            @Override
            public void receiveException(SocketRequestHandle<Identifier> s, Exception ex) {
                deliverSocketToMe.receiveException(ret, ex);
            }
        }, options));
        return ret;
    }

    @Override
    public MessageRequestHandle<Identifier, MessageType> sendMessage(Identifier i, MessageType m, MessageCallback<Identifier, MessageType> deliverAckToMe, Map<String, Object> options) {
        return this.tl.sendMessage(i, m, deliverAckToMe, options);
    }

    @Override
    public void setCallback(TransportLayerCallback<Identifier, MessageType> callback) {
        this.callback = callback;
    }

    @Override
    public void setErrorHandler(ErrorHandler<Identifier> handler) {
        this.errorHandler = handler;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void incomingSocket(P2PSocket<Identifier> s) throws IOException {
        final SocketInputBuffer sib = new SocketInputBuffer(s);
        new P2PSocketReceiver<Identifier>(){

            @Override
            public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
                try {
                    Object remoteIdentifier = SimpleIdentityTransportLayer.this.serializer.deserialize(sib, socket.getIdentifier(), socket.getOptions());
                    SimpleIdentityTransportLayer.this.callback.incomingSocket(new SocketWrapperSocket(remoteIdentifier, socket, SimpleIdentityTransportLayer.this.logger, socket.getOptions()));
                }
                catch (InsufficientBytesException ibe) {
                    socket.register(true, false, this);
                }
            }

            @Override
            public void receiveException(P2PSocket<Identifier> socket, Exception ioe) {
                SimpleIdentityTransportLayer.this.errorHandler.receivedException(socket.getIdentifier(), ioe);
            }
        }.receiveSelectResult(s, true, false);
    }

    @Override
    public void messageReceived(Identifier i, MessageType m, Map<String, Object> options) throws IOException {
        this.callback.messageReceived(i, m, options);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DefaultLocalIdentifierStrategy<Identifier>
    implements LocalIdentifierStrategy<Identifier> {
        byte[] localIdentifierBytes;

        public DefaultLocalIdentifierStrategy(Identifier i) throws IOException {
            SimpleOutputBuffer sob = new SimpleOutputBuffer();
            SimpleIdentityTransportLayer.this.serializer.serialize(SimpleIdentityTransportLayer.this.tl.getLocalIdentifier(), sob);
            this.localIdentifierBytes = sob.getBytes();
        }

        @Override
        public byte[] getLocalIdentifierBytes() {
            return this.localIdentifierBytes;
        }
    }
}

